<?php $__env->startSection("title", "Wishlist"); ?>
<?php $__env->startSection("style"); ?>
<?php echo $__env->make('partial.user_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .mn-wishlist-table {
        background: #fff;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.05);
        overflow: hidden;
    }

    .mn-wishlist-table table {
        width: 100%;
    }

    .mn-wishlist-table th {
        background: #f8f9fa;
        padding: 15px 20px;
        font-weight: 600;
        text-align: left;
        color: #4a5568;
        border-bottom: 1px solid #eee;
    }

    .mn-wishlist-table td {
        padding: 15px 20px;
        border-bottom: 1px solid #eee;
        color: #4a5568;
        vertical-align: middle;
    }

    .mn-wishlist-table tr:last-child td {
        border-bottom: none;
    }

    .product-info {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .product-img {
        width: 60px;
        height: 60px;
        object-fit: cover;
        border-radius: 8px;
    }

    .product-title {
        color: #2d3748;
        font-weight: 500;
        text-decoration: none;
        margin-bottom: 4px;
        display: block;
    }

    .product-title:hover {
        color: #4299e1;
    }

    .product-desc {
        font-size: 13px;
        color: #718096;
        margin: 0;
    }

    .price {
        font-weight: 600;
        color: #2d3748;
        font-size: 16px;
    }

    .btn-action {
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 14px;
        font-weight: 500;
        transition: all 0.2s;
    }

    .btn-view {
        background: #4299e1;
        color: white;
        border: none;
    }

    .btn-view:hover {
        background: #3182ce;
        color: white;
    }

    .btn-remove {
        background: transparent;
        color: #e53e3e;
        border: 1px solid #e53e3e;
    }

    .btn-remove:hover {
        background: #e53e3e;
        color: white;
    }

    .empty-wishlist {
        text-align: center;
        padding: 40px 20px;
    }

    .empty-wishlist i {
        font-size: 48px;
        color: #a0aec0;
        margin-bottom: 15px;
    }

    @media (max-width: 768px) {
        .mn-wishlist-table {
            display: block;
            overflow-x: auto;
        }
        
        .mn-wishlist-table table {
            min-width: 800px;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
<div class="container account-wrapper">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            <?php echo $__env->make('partial.user_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="mb-0">My Wishlist</h4>
                    <span class="text-muted"><?php echo e($wishlist->total()); ?> items</span>
                </div>

                <?php if($wishlist->count() > 0): ?>
                    <div class="mn-wishlist-table">
                        <table>
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Price</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $wishlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $product = $item->product;
                                        $defaultVariation = $product->variations->where('default', true)->first();
                                    ?>
                                    <tr>
                                        <td>
                                            <div class="product-info">
                                                <img src="<?php echo e($product->primary_image->url); ?>" 
                                                    alt="<?php echo e($product->title); ?>" class="product-img">
                                                <div>
                                                    <a href="<?php echo e(route('product.view', $product->slug)); ?>" class="product-title">
                                                        <?php echo e($product->title); ?>

                                                    </a>
                                                    <p class="product-desc"><?php echo e(Str::limit($product->description, 50)); ?></p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if($defaultVariation): ?>
                                                <span class="price">৳<?php echo e(number_format($defaultVariation->sale_price)); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="d-flex gap-2">
                                                <a href="<?php echo e(route('product.view', $product->slug)); ?>" class="btn btn-action btn-view">
                                                    <i class="ri-eye-line"></i>
                                                </a>
                                                <form action="<?php echo e(route('wishlist.remove', $product->id)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-action btn-remove">
                                                        <i class="ri-delete-bin-line"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if($wishlist->hasPages()): ?>
                        <?php echo $__env->make('partial.pagination', ['paginator' => $wishlist], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="empty-wishlist">
                        <i class="ri-heart-line"></i>
                        <h5>Your wishlist is empty</h5>
                        <p class="text-muted">Browse our products and add items to your wishlist</p>
                        <a href="<?php echo e(route('product.list')); ?>" class="mn-btn-2"><span>Browse Products</span></a>
                    </div>
                <?php endif; ?>
            </div>                
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/user/wishlist.blade.php ENDPATH**/ ?>