<?php $__env->startSection("title", "Computers, Laptops, and IT Solutions Hub"); ?>
<?php $__env->startSection("style"); ?>
<style>
.mn-hero {
  border-radius: 15px;
  overflow: hidden;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  -webkit-box-pack: center;
      -ms-flex-pack: center;
          justify-content: center;
  -ms-flex-wrap: wrap;
      flex-wrap: wrap;
}
.mn-hero .owl-nav button.owl-prev, .mn-hero .owl-nav button.owl-next {
  position: absolute;
  top: 50%;
  -webkit-transform: translateY(-50%);
  transform: translateY(-50%);
  z-index: 9;
  width: 30px;
  height: 40px;
  line-height: 40px;
  -webkit-transition: all 0.3s;
  transition: all 0.3s;
  margin: auto;
  border-radius: 0;
  text-align: center;
  color: #313b50;
  background-color: #f1f4f7;
  z-index: 5;
}
.mn-hero .owl-nav button.owl-prev:before, .mn-hero .owl-nav button.owl-next:before {
  font-family: "remixicon";
  font-size: 30px;
  line-height: 42px;
  outline: 0;
}
.mn-hero .owl-nav button.owl-prev span, .mn-hero .owl-nav button.owl-next span {
  display: none;
}
.mn-hero .owl-nav button.owl-prev {
  border-radius: 0 20px 20px 0;
  left: 0;
}
.mn-hero .owl-nav button.owl-prev:before {
  content: "\ea64";
  margin-left: -7px;
  font-family: "remixicon";
  font-size: 30px;
  outline: 0;
}
.mn-hero .owl-nav button.owl-prev:after {
  content: "";
  width: 18px;
  height: 70px;
  position: absolute;
  top: 50%;
  left: 0;
  background-image: url("<?php echo e(asset('assets/shape-1.png')); ?>");
  background-repeat: no-repeat;
  background-size: 100%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
}
.mn-hero .owl-nav button.owl-next {
  border-radius: 20px 0px 0px 20px;
  right: 0;
}
.mn-hero .owl-nav button.owl-next:before {
  content: "\ea6e";
  margin-right: -7px;
}
.mn-hero .owl-nav button.owl-next:after {
  content: "";
  width: 18px;
  height: 70px;
  position: absolute;
  top: 50%;
  right: 0;
  background-image: url("<?php echo e(asset('assets/shape-1.png')); ?>");
  background-repeat: no-repeat;
  background-size: 100%;
  -webkit-transform: translateY(-50%) rotate(180deg);
          transform: translateY(-50%) rotate(180deg);
}
.mn-hero .owl-dots {
  width: auto;
  padding: 12px 15px 0 15px;
  background-color: #f1f4f7;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  position: absolute;
  left: 50%;
  bottom: 0;
  -webkit-transform: translateX(-50%);
          transform: translateX(-50%);
  border-radius: 20px 20px 0px 0px;
}
.mn-hero .owl-dots:before {
  content: "";
  width: 18px;
  height: 15px;
  position: absolute;
  left: -15px;
  bottom: -6px;
  background-image: url("<?php echo e(asset('assets/shape-2.png')); ?>");
  background-repeat: no-repeat;
  background-size: 100%;
  -webkit-transform: translateY(-50%) rotate(270deg);
          transform: translateY(-50%) rotate(270deg);
}
.mn-hero .owl-dots:after {
  content: "";
  width: 18px;
  height: 15px;
  position: absolute;
  right: -17px;
  bottom: -8px;
  background-image: url("<?php echo e(asset('assets/shape-2.png')); ?>");
  background-repeat: no-repeat;
  background-size: 100%;
  -webkit-transform: translateY(-50%);
          transform: translateY(-50%);
}
.mn-hero .owl-dots .owl-dot {
  -webkit-transition: all 0.3s ease-in-out;
  transition: all 0.3s ease-in-out;
  width: 12px;
  height: 12px;
  margin: 2px;
  background-color: transparent !important;
  border: 1px solid #313b50;
  opacity: 1;
  border-radius: 10px;
}
.mn-hero .owl-dots .owl-dot.active {
  width: 25px;
  background-color: #159abe !important;
  border-color: #159abe;
}
.mn-hero .mn-hero-slide {
  background-repeat: no-repeat;
  background-size: cover;
  background-position: center;
  overflow-y: hidden;
}
.mn-hero .mn-hero-slider .mn-hero-slide {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail {
  height: 600px;
  padding-left: 100px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-orient: vertical;
  -webkit-box-direction: normal;
      -ms-flex-direction: column;
          flex-direction: column;
  -webkit-box-align: start;
      -ms-flex-align: start;
          align-items: flex-start;
  -webkit-box-pack: center;
      -ms-flex-pack: center;
          justify-content: center;
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h2 {
  font-size: 65px;
  color: #fff;
  font-weight: 600;
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail p {
  font-size: 15px;
  color: #fff;
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail .label {
  height: 60px;
  width: 60px;
  margin-bottom: 30px;
  padding: 5px 10px;
  background-color: #1cbce8;
  display: -webkit-inline-box;
  display: -ms-inline-flexbox;
  display: inline-flex;
  position: relative;
  -webkit-box-align: center;
      -ms-flex-align: center;
          align-items: center;
  -webkit-box-pack: center;
      -ms-flex-pack: center;
          justify-content: center;
  border-radius: 5px;
  -webkit-animation: jingle 4s infinite alternate ease-in-out;
          animation: jingle 4s infinite alternate ease-in-out;
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail .label:after, .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail .label:before {
  height: 60px;
  width: 60px;
  content: "";
  position: absolute;
  top: 0;
  left: 0;
  border-radius: 5px;
  background: #1cbce8;
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail .label:before {
  -webkit-transform: rotate(30deg);
          transform: rotate(30deg);
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail .label:after {
  -webkit-transform: rotate(60deg);
          transform: rotate(60deg);
}
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail .label span {
  z-index: 5;
  text-align: center;
  font-weight: 700;
  font-size: 18px;
  line-height: 21px;
  color: #313b50;
}
@-webkit-keyframes jingle {
  0% {
    -webkit-transform: rotate(-10deg);
            transform: rotate(-10deg);
  }
  100% {
    -webkit-transform: rotate(10deg);
            transform: rotate(10deg);
  }
}
@media only screen and (max-width: 1599px) {
  .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h2 {
    font-size: 60px;
    line-height: 65px;
  }
}
@media only screen and (max-width: 1399px) {
  .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail {
    height: 500px;
  }
  .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h2 {
    font-size: 50px;
    line-height: 56px;
  }
}
@media only screen and (max-width: 1199px) {
  .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail {
    height: 450px;
  }
  .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h2 {
    font-size: 48px;
    line-height: 54px;
  }
}
@media only screen and (max-width: 991px) {
  .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail {
    padding-left: 70px;
  }
  .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail h2 {
    font-size: 45px;
    line-height: 50px;
  }
}
@media only screen and (max-width: 767px) {
  .mn-hero .mn-hero-slider .mn-hero-detail {
    height: 400px;
    padding-left: 50px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-detail h2 {
    margin-bottom: 15px;
    font-size: 34px;
    line-height: 42px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail p {
    display: none;
  }
}
@media only screen and (max-width: 575px) {
  .mn-hero .mn-hero-slider .mn-hero-detail {
    height: 350px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-detail h2 {
    font-size: 28px;
    line-height: 32px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail .label {
    height: 50px;
    width: 50px;
    margin-bottom: 15px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail .label:after, .mn-hero .mn-hero-slider .mn-hero-detail .label:before {
    height: 50px;
    width: 50px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail .label span {
    font-size: 12px;
    line-height: 13px;
  }
}
@media only screen and (max-width: 480px) {
  .mn-hero .owl-dots {
    display: none;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail {
    height: 300px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-detail h2 {
    font-size: 25px;
    line-height: 30px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail .label {
    height: 40px;
    width: 40px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail .label:after, .mn-hero .mn-hero-slider .mn-hero-detail .label:before {
    height: 40px;
    width: 40px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail .label span {
    font-size: 12px;
    line-height: 13px;
  }
}
@media only screen and (max-width: 420px) {
  .mn-hero .mn-hero-slider .mn-hero-detail {
    height: 280px;
    padding-left: 30px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-detail h2 {
    font-size: 23px;
    line-height: 28px;
  }
  .mn-hero .owl-nav {
    display: none;
  }
}
@media only screen and (max-width: 380px) {
  .mn-hero .mn-hero-slider .mn-hero-detail {
    height: 230px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-detail h2 {
    font-size: 21px;
    line-height: 25px;
  }
  .mn-hero .owl-nav {
    display: none;
  }
}
@media only screen and (max-width: 340px) {
  .mn-hero .mn-hero-slider .mn-hero-detail {
    height: 200px;
  }
  .mn-hero .mn-hero-slider .mn-hero-detail h1, .mn-hero .mn-hero-slider .mn-hero-detail h2 {
    font-size: 18px;
    line-height: 22px;
  }
  .mn-hero .owl-nav {
    display: none;
  }
}

.mn-cat .mn-cat-card {
  padding: 15px;
  border-radius: 15px;
  position: relative;
  overflow: hidden;
  background-color: #e1e5e9;
}
.mn-cat .mn-cat-card:hover:after {
  bottom: -100px;
}
.mn-cat .mn-cat-card:after {
  -webkit-transition: all 0.3s ease-in-out;
  transition: all 0.3s ease-in-out;
  content: "";
  width: 100%;
  height: 100px;
  background: -webkit-gradient(linear, left bottom, left top, from(rgba(0, 0, 0, 0.15)), to(rgba(0, 0, 0, 0)));
  background: linear-gradient(0deg, rgba(0, 0, 0, 0.15) 0%, rgba(0, 0, 0, 0) 100%);
  position: absolute;
  bottom: 0;
  left: 0;
}
.mn-cat .mn-cat-card h3 {
  font-size: 25px;
  font-weight: 700;
  color: #313b50;
  text-transform: capitalize;
  position: relative;
  z-index: 2;
}
.mn-cat .mn-cat-card h4 {
  margin: 0;
  font-size: 18px;
  font-weight: 700;
  color: #313b50;
  text-transform: capitalize;
  position: relative;
  z-index: 2;
}
.mn-cat .mn-cat-card p {
  color: #313b50;
}

.mn-cat .mn-cat-card ul {
  margin: -5px;
  display: -webkit-inline-box;
  display: -ms-inline-flexbox;
  display: inline-flex;
  position: relative;
  z-index: 5;
}
.mn-cat .mn-cat-card ul li {
  margin: 5px;
  padding: 5px;
  background-color: #f1f0f4;
  border-radius: 15px;
}
.mn-cat .mn-cat-card ul li img {
  width: 100%;
  border-radius: 10px;
}
@media only screen and (max-width: 991px) {
  .mn-cat .mn-cat-card h3 {
    font-size: 24px;
  }
  .mn-cat .mn-cat-card h4 {
    font-size: 17px;
  }
}
@media only screen and (max-width: 767px) {
  .mn-cat .mn-cat-card h3 {
    font-size: 23px;
  }
  .mn-cat .mn-cat-card h4 {
    font-size: 16px;
  }
}
@media only screen and (max-width: 575px) {
  .mn-cat .mn-cat-card h3 {
    font-size: 22px;
  }
}

/* Remix icon fallback for service section (scoped to home only) */
.mn-ser-inner .mn-service-image .sb-service-icon {
  font-size: 50px;
  line-height: 1;
  display: inline-block;
  color: #159abe; /* match previous svg path fill */
}
.mn-ser-inner:hover .mn-service-image .sb-service-icon {
  transform: translateY(-1px);
}
/* Dynamic hero backgrounds */
.mn-hero .mn-hero-slide { background-size: cover; background-position: center; }
.mn-product-card .mn-product-detail .cat a { text-transform: none !important; }
.mn-card-meta { display:flex; align-items:center; justify-content:space-between; margin:-4px 0 6px 0; }
.mn-card-rating { display:inline-flex; align-items:center; gap:4px; font-size:14px; }
.mn-card-rating .num { color:#666; }
/* Hero split layout */
/* Make exact match to WoodMart reference */
.mn-hero { border-radius:0; overflow:visible; }
/* Hero split layout */
.mn-hero-grid { display:flex; gap:15px; }
.mn-hero-left { flex: 0 0 57%; max-width: 57%; }
.mn-hero-right { flex: 0 0 43%; max-width: 43%; display:flex; flex-direction:column; gap:15px; }
/* left slider shorter to match reference */
.mn-hero .mn-hero-slider .mn-hero-slide .mn-hero-detail { height: 450px; padding-left:60px; }
.mn-hero .mn-hero-slider .mn-hero-slide { border-radius:12px; overflow:hidden; }
/* right: big banner + two small cards */
.mn-hero-banner { border-radius:12px; padding:32px; min-height:220px; background: #f6f7fb; display:flex; flex-direction:column; justify-content:flex-start; position:relative; overflow:hidden; background-size:cover; background-position:center; }
.mn-hero-banner h3 { font-size:32px; font-weight:800; margin:0 0 15px 0; color:#ffffff; }
.mn-hero-banner p { margin:0 0 15px 0; font-size:14px; color:#ffffff; }
.mn-hero-sm-grid { display:grid; grid-template-columns:1fr 1fr; gap:15px; }
.mn-hero-card { border-radius:12px; padding:25px; min-height:210px; display:flex; align-items:center; justify-content:flex-start; color:#111; overflow:hidden; background-size:cover; background-position:center; }
.mn-hero-card h3 { font-size:20px; font-weight:700; margin:0 0 4px 0; color:#ffffff; }
.mn-hero-card p { margin:0 0 15px 0; font-size:14px; color:#ffffff; }
.mn-hero-banner .mn-btn-2 {padding:0; width:130px; text-align:center; border-radius:35px; line-height:40px; }
.mn-hero-card .mn-btn-2 { padding:0; width:130px; text-align:center; border-radius:35px; line-height:36px; }
.mn-btn-2 span { display:inline-block; width:100%; }
.mn-hero-card .icon { font-size:46px; color:#9aa3af; }
.mn-hero-left .owl-dots { border-radius:30px 30px 0 0; }
/* Remove gradient backgrounds as we're using images */
@media (max-width: 1100px) {
  .mn-hero-grid { flex-direction: column; }
  .mn-hero-left, .mn-hero-right { max-width: 100%; flex-basis: 100%; }
  .mn-hero-card { min-height: 140px; }
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
    <div class="col-xxl-12">
        <!-- Hero Section split layout -->
        <div class="mn-hero-grid m-b-15">
          <div class="mn-hero-left">
            <section class="mn-hero swiper-container" style="border-radius:12px; overflow:visible;">
                <div class="mn-hero-slider owl-carousel">
                    <?php $slides = $homeCustomization['sliders'] ?? []; ?>
                    <?php if(!empty($slides)): ?>
                        <?php $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mn-hero-slide swiper-slide" style="background-image: url('<?php echo e(Storage::url($s['bg_img_path'])); ?>')">
                                <div class="mn-hero-detail">
                                    <?php if(!empty($s['badge'])): ?>
                                        <p class="label"><span><?php echo $s['badge']; ?></span></p>
                                    <?php endif; ?>
                                    <?php if(!empty($s['title'])): ?>
                                        <h1><?php echo $s['title']; ?></h1>
                                    <?php endif; ?>
                                    <?php if(!empty($s['slogan'])): ?>
                                        <p><?php echo e($s['slogan']); ?></p>
                                    <?php endif; ?>
                                    <?php if(!empty($s['btn_link'])): ?>
                                        <a href="<?php echo e($s['btn_link']); ?>" class="mn-btn-2"><span>Shop Now</span></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </section>
          </div>
          <aside class="mn-hero-right">
            <?php $heroBoxes = $homeCustomization['hero_boxes'] ?? []; ?>
            <?php 
              $box1 = $heroBoxes[0] ?? null; 
              $box1Bg = (!empty($box1['bg_img_path']) ? Storage::url($box1['bg_img_path']) : '');
            ?>
            <div class="mn-hero-banner" style="background-image:url('<?php echo e($box1Bg); ?>')">
                <h3><?php echo e($box1['title'] ?? ''); ?></h3>
                <p><?php echo e($box1['text'] ?? ''); ?></p>
                <a href="<?php echo e($box1['btn_link'] ?? '#'); ?>" class="mn-btn-2"><span>Buy Now</span></a>
            </div>
            <!-- Two small cards -->
            <div class="mn-hero-sm-grid">
              <?php 
                $box2 = $heroBoxes[1] ?? null; 
                $box2Bg = (!empty($box2['bg_img_path']) ? Storage::url($box2['bg_img_path']) : '');
              ?>
              <div class="mn-hero-card box-1" style="background-image:url('<?php echo e($box2Bg); ?>')">
                <div>
                  <h3><?php echo e($box2['title'] ?? ''); ?></h3>
                  <p><?php echo e($box2['text'] ?? ''); ?></p>
                  <a href="<?php echo e($box2['btn_link'] ?? '#'); ?>" class="mn-btn-2"><span>View Details</span></a>
                </div>
              </div>
              <?php 
                $box3 = $heroBoxes[2] ?? null; 
                $box3Bg = (!empty($box3['bg_img_path']) ? Storage::url($box3['bg_img_path']) : '');
              ?>
              <div class="mn-hero-card box-2" style="background-image:url('<?php echo e($box3Bg); ?>')">
                <div>
                  <h3><?php echo e($box3['title'] ?? ''); ?></h3>
                  <p><?php echo e($box3['text'] ?? ''); ?></p>
                  <a href="<?php echo e($box3['btn_link'] ?? '#'); ?>" class="mn-btn-2"><span>View Details</span></a>
                </div>
              </div>
            </div>
          </aside>
        </div>
        <!-- Category Section -->
        <section class="mn-category p-tb-15">
            <div class="mn-cat owl-carousel">
                
                <!-- Category Cards -->
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="mn-cat-card cat-card-<?php echo e($index + 1); ?>">
                    <h3><a href="<?php echo e(route('product.list', ['category' => $category['slug']])); ?>" style="color: #666666; text-decoration: none;"><?php echo e($category['name']); ?></a></h3>
                    <p>Items (<?php echo e($category['product_count']); ?>)</p>
                    <ul>
                        <?php $__currentLoopData = $category['random_products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($product->primary_image): ?>
                            <li>
                                <a href="<?php echo e(route('product.view', $product->slug)); ?>">
                                    <img src="<?php echo e($product->primary_image->url); ?>" 
                                         alt="<?php echo e($product->title); ?>">
                                </a>
                            </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </section>
        <!-- best deals -->
        <section class="mn-new-product p-tb-15">
          <div class="mn-title mn-title-2">
              <div class="mn-timer">
                  <h2><?php if($activeDeal): ?>
                      <?php
                          $words = explode(' ', $activeDeal->name);
                          $firstWord = array_shift($words);
                          $remainingWords = implode(' ', $words);
                      ?>
                      <?php echo e($firstWord); ?> <?php if($remainingWords): ?><span><?php echo e($remainingWords); ?></span><?php endif; ?>
                  <?php else: ?> 
                      No Best <span>Deals</span>&nbsp;Available!
                  <?php endif; ?></h2>
                  <?php if($dealEndDate): ?>
                  <div class="timer1 timer dealend-timer" data-date="<?php echo e($dealEndDate->format('F d, Y H:i:s T')); ?>">
                  </div>
                  <?php endif; ?>
              </div>
          </div>
          <div class="mn-product owl-carousel">
              <?php $__currentLoopData = $bestDealProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="mn-product-card" 
                       data-product-id="<?php echo e($product->id); ?>"
                       data-default-variant-id="<?php echo e($product->variations->where('default', true)->first()->id); ?>">
                  <div class="mn-product-img">
                      <div class="mn-img">
                              <a href="<?php echo e(route('product.view', $product->slug)); ?>" class="image">
                                  <?php if($product->images->first()): ?>
                                      <img class="main-img" src="<?php echo e($product->images->first()->url); ?>" alt="<?php echo e($product->title); ?>">
                                  <?php else: ?>
                                      <img class="main-img" src="<?php echo e(asset('assets/default_img.png')); ?>" alt="Default Image">
                                  <?php endif; ?>
                          </a>
                          <div class="mn-pro-loader"></div>
                          <div class="mn-options mn-options-always-visible">
                            <ul>
                                <li>
                                          <a href="javascript:void(0)" 
                                             data-tooltip 
                                             title="Wishlist" 
                                             class="mn-wishlist"
                                             data-product-id="<?php echo e($product->id); ?>">
                                              <i class="ri-heart-line"></i>
                                    </a>
                                </li>
                                
                                <li>
                                  <a href="javascript:void(0)" 
                                     data-tooltip 
                                     title="Compare" 
                                     class="mn-compare" 
                                     data-product-id="<?php echo e($product->id); ?>">
                                      <i class="ri-repeat-line"></i>
                                  </a>
                                </li>
                                <li>
                                    <?php
                                        $defaultInStock = ($product->relationLoaded('variations')
                                            ? (int)optional($product->variations->first())->in_stock > 0
                                            : (int)($product->variations()->where('default', true)->value('in_stock') ?? 0) > 0);
                                        $variantsCount = $product->variants_count ?? $product->variations()->count();
                                        $inStockCount = $product->in_stock_variants_count ?? $product->variations()->where('in_stock', '>', 0)->count();
                                        $allOut = ($inStockCount === 0);
                                        $defaultOut = !$defaultInStock;
                                    ?>
                                    <?php if($variantsCount > 1 && $defaultOut && !$allOut): ?>
                                        <a href="<?php echo e(route('product.view', ['slug' => $product->slug])); ?>" data-tooltip title="Open" class="mn-add-cart open-link">
                                            <i class="ri-eye-line"></i>
                                            Open
                                        </a>
                                    <?php elseif(($variantsCount === 1 && $defaultOut) || ($variantsCount > 1 && $allOut)): ?>
                                        <a href="javascript:void(0)" class="mn-add-cart out-stock disabled" style="pointer-events: none; opacity: .85; background: #dc3545; border-color: #dc3545; color: #fff;">
                                            <i class="ri-close-line"></i>
                                            Out of stock
                                        </a>
                                    <?php else: ?>
                                        <a href="javascript:void(0)" data-tooltip title="Add To Cart" class="mn-add-cart">
                                            <i class="ri-shopping-cart-line"></i>
                                            Add to Cart
                                        </a>
                                    <?php endif; ?>
                                </li>
                            </ul>
                          </div>
                      </div>
                  </div>
                  <div class="mn-product-detail">
                      <div class="cat" style="display:flex; align-items:center; justify-content:space-between; gap:10px;">
                          <a href="<?php echo e(route('product.list', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->name); ?></a>
                          <?php if($product->brand): ?>
                              <a href="<?php echo e(route('product.list', ['brand' => Str::slug($product->brand->title)])); ?>"><?php echo e($product->brand->title); ?></a>
                          <?php endif; ?>
                      </div>
                          <h5><a href="<?php echo e(route('product.view', $product->slug)); ?>"><?php echo e($product->title); ?></a></h5>
                          <?php $avg = $product->average_rating ?? ($product->averageRating ?? 0); ?>
                          <div class="mn-card-meta">
                              <div class="mn-price" style="margin:0;">
                                  <?php
                                      $defaultVariation = $product->variations->where('default', true)->first();
                                  ?>
                                  <?php if($defaultVariation): ?>
                                      <div class="mn-price-new">৳<?php echo e(number_format($defaultVariation->sale_price)); ?></div>
                                      <?php if($defaultVariation->regular_price > $defaultVariation->sale_price): ?>
                                          <div class="mn-price-old">৳<?php echo e(number_format($defaultVariation->regular_price)); ?></div>
                                      <?php endif; ?>
                                  <?php endif; ?>
                              </div>
                              <div class="mn-card-rating">
                                  <?php
                                      $icon = 'ri-star-line';
                                      if ($avg >= 0.75) { $icon = 'ri-star-fill'; }
                                      elseif ($avg >= 0.25) { $icon = 'ri-star-half-s-fill'; }
                                  ?>
                                  <i class="<?php echo e($icon); ?>"></i>
                                  <span class="num"><?php echo e(number_format($avg,1)); ?></span>
                              </div>
                          </div>
                  </div>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </section>
        <!-- Service Section -->
        <section class="mn-service p-tb-15">
            <div class="row m-b-m-24">
                <?php $services = $homeCustomization['services'] ?? []; ?>
                <?php if(!empty($services)): ?>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mn-ser-content mn-ser-content-<?php echo e(($i % 4) + 1); ?> col-sm-6 col-xl-3 m-b-24" data-aos="fade-up"
                            data-aos-duration="1000" data-aos-delay="<?php echo e(200 + ($i*200)); ?>">
                            <div class="mn-ser-box">
                                <div class="mn-ser-inner">
                                    <div class="mn-service-image">
                                        <i class="ri-<?php echo e($f['icon']); ?> sb-service-icon" aria-hidden="true"></i>
                                    </div>
                                    <div class="mn-service-desc">
                                        <h3><?php echo e($f['title'] ?? ''); ?></h3>
                                        <p><?php echo e($f['text'] ?? ''); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </section>
        <!-- Banner slider -->
        <section class="mn-banner p-tb-15">
            <div class="row">
                <div class="col-12" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                    <div class="mn-modern-banner owl-carousel">
                        <?php $featured = $homeCustomization['featured'] ?? []; ?>
                        <?php if(!empty($featured)): ?>
                            <?php $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="modern-banner">
                                    <div class="mn-banner-img" style="background-image: url('<?php echo e(Storage::url($item['bg_img_path'])); ?>')"></div>
                                    <div class="mn-banner-contact banner-animation">
                                        <div class="inner-banner">
                                            <?php if(!empty($item['title'])): ?>
                                                <h4><?php echo e($item['title']); ?></h4>
                                            <?php endif; ?>
                                        </div>
                                        <div class="inner-text">
                                            <?php if(!empty($item['text'])): ?>
                                                <p><?php echo e($item['text']); ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <?php if(!empty($item['btn_link'])): ?>
                                            <div class="banner-btn">
                                                <a href="<?php echo e($item['btn_link']); ?>" class="mn-btn-1"><span>Shop Now</span></a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- all product section -->
        <section class="mn-new-product p-tb-15">
            <div class="mn-title">
                <h2>Latest <span>Products</span></h2>
            </div>
            <div class="row">
                <?php $__currentLoopData = $latestProducts->take(12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-12 m-b-24 mn-product-box pro-gl-content">
                        <div class="mn-product-card"
                             data-product-id="<?php echo e($product->id); ?>"
                             data-default-variant-id="<?php echo e($product->variations->where('default', true)->first()->id); ?>">
                            <div class="mn-product-img">
                                <div class="mn-img">
                                    <a href="<?php echo e(route('product.view', $product->slug)); ?>" class="image">
                                        <?php if($product->images->first()): ?>
                                            <img class="main-img" src="<?php echo e($product->images->first()->url); ?>" alt="<?php echo e($product->title); ?>">
                                        <?php else: ?>
                                            <img class="main-img" src="<?php echo e(asset('assets/default_img.png')); ?>" alt="Default Image">
                                        <?php endif; ?>
                                    </a>
                                    <div class="mn-options mn-options-always-visible">
                                      <ul>
                                          <li>
                                                <a href="javascript:void(0)" 
                                                   data-tooltip 
                                                   title="Wishlist" 
                                                   class="mn-wishlist"
                                                   data-product-id="<?php echo e($product->id); ?>">
                                                    <i class="ri-heart-line"></i>
                                              </a>
                                          </li>
                                          
                                          <li>
                                            <a href="javascript:void(0)" 
                                               data-tooltip 
                                               title="Compare" 
                                               class="mn-compare" 
                                               data-product-id="<?php echo e($product->id); ?>">
                                                <i class="ri-repeat-line"></i>
                                            </a>
                                          </li>
                                          <li>
                                              <?php
                                              $defaultInStock = ($product->relationLoaded('variations')
                                               ? (int)optional($product->variations->first())->in_stock > 0
                                               : (int)($product->variations()->where('default', true)->value('in_stock') ?? 0) > 0);
                                              $variantsCount = $product->variants_count ?? $product->variations()->count();
                                              $inStockCount = $product->in_stock_variants_count ?? $product->variations()->where('in_stock', '>', 0)->count();
                                              $allOut = ($inStockCount === 0);
                                              $defaultOut = !$defaultInStock;
                                          ?>
                                              <?php if($variantsCount > 1 && $defaultOut && !$allOut): ?>
                                                  <a href="<?php echo e(route('product.view', ['slug' => $product->slug])); ?>" data-tooltip title="Open" class="mn-add-cart open-link">
                                                      <i class="ri-eye-line"></i>
                                                      Open
                                                  </a>
                                              <?php elseif(($variantsCount === 1 && $defaultOut) || ($variantsCount > 1 && $allOut)): ?>
                                                  <a href="javascript:void(0)" class="mn-add-cart out-stock disabled" style="pointer-events: none; opacity: .85; background: #dc3545; border-color: #dc3545; color: #fff;">
                                                      <i class="ri-close-line"></i>
                                                      Out of stock
                                                  </a>
                                              <?php else: ?>
                                                  <a href="javascript:void(0)" data-tooltip title="Add To Cart" class="mn-add-cart">
                                                      <i class="ri-shopping-cart-line"></i>
                                                      Add to Cart
                                                  </a>
                                              <?php endif; ?>
                                          </li>
                                      </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="mn-product-detail">
                                <div class="cat" style="display:flex; align-items:center; justify-content:space-between; gap:10px;">
                                    <a href="<?php echo e(route('product.list', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->name); ?></a>
                                    <?php if($product->brand): ?>
                                        <a href="<?php echo e(route('product.list', ['brand' => Str::slug($product->brand->title)])); ?>"><?php echo e($product->brand->title); ?></a>
                                    <?php endif; ?>
                                </div>
                                <h5><a href="<?php echo e(route('product.view', $product->slug)); ?>"><?php echo e($product->title); ?></a></h5>
                                <?php $avg = $product->average_rating ?? ($product->averageRating ?? 0); ?>
                                <div class="mn-card-meta">
                                    <div class="mn-price" style="margin:0;">
                                    <?php
                                        $defaultVariation = $product->variations->where('default', true)->first();
                                    ?>
                                    <?php if($defaultVariation): ?>
                                        <div class="mn-price-new">৳<?php echo e(number_format($defaultVariation->sale_price)); ?></div>
                                        <?php if($defaultVariation->regular_price > $defaultVariation->sale_price): ?>
                                            <div class="mn-price-old">৳<?php echo e(number_format($defaultVariation->regular_price)); ?></div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    </div>
                                    <div class="mn-card-rating">
                                        <?php
                                            $icon = 'ri-star-line';
                                            if ($avg >= 0.75) { $icon = 'ri-star-fill'; }
                                            elseif ($avg >= 0.25) { $icon = 'ri-star-half-s-fill'; }
                                        ?>
                                        <i class="<?php echo e($icon); ?>"></i>
                                        <span class="num"><?php echo e(number_format($avg,1)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="text-center mt-4 mb-3">
              <a href="<?php echo e(route('product.list')); ?>" class="mn-btn-2">
                <span><i class="ri-store-2-line mr-2"></i> Explore More Products</span>
              </a>
            </div>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script src="<?php echo e(asset('js/countdownTimer.js')); ?>"></script>
<script>
$('.mn-hero-slider').owlCarousel({
    margin: 0,
    loop: true,
    dots: true,
    nav: true,
    smartSpeed: 1500,
    autoplay: true,
    items: 1,
    responsiveClass: true,
});

$(".mn-cat").owlCarousel({
    margin: 24,
    loop: true,
    dots: false,
    nav: false,
    smartSpeed: 500,
    autoplayTimeout: 3000,
    items: 3,
    autoHeight: true,
    responsiveClass: true,
    responsive: {
        0: {
            items: 1,
        },
        421: {
            items: 2,
        },
        768: {
            items: 3,
        },
        992: {
            items: 4,
        },
        1200: {
            items: 4,
        },
        1400: {
            items: 4,
        },
        1600: {
            items: 5,
        }
    },
});

$(".mn-product").owlCarousel({
    margin: 24,
    loop: false,
    rewind: true,
    dots: false,
    nav: true,
    smartSpeed: 500,
    autoplay: true,
    autoplayTimeout: 3000,
    items: 1,
    responsiveClass: true,
    responsive: {
        0: {
            items: 1,
        },
        461: {
            items: 1,
        },
        768: {
            items: 2,
        },
        992: {
            items: 3,
        },
        1200: {
            items: 4,
        },
        1400: {
            items: 4,
        },
        1600: {
            items: 5,
        },
    },
});


// Add to Cart functionality
$('.mn-add-cart').on('click', function() {
    var iscartlist = $(this).hasClass("active");
    if (iscartlist) {
        $(this).removeClass("active");
    } else {
        $(this).addClass("active");
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/general/home.blade.php ENDPATH**/ ?>