<?php $__env->startSection("title", "Checkout"); ?>
<?php $__env->startSection("style"); ?>
<style>
.shipping-form {
    padding: 2rem;
    background: #fff;
    border-radius: 10px;
}
.shipping-form .form-group {
    margin-bottom: 1.5rem;
}
.shipping-form label {
    font-weight: 500;
    margin-bottom: 0.5rem;
    color: #333;
}
.shipping-form .optional {
    color: #666;
    font-weight: normal;
    font-size: 0.9rem;
}
/* Cart items styling */
.mn-checkout-pro {
    background: #fff;
    border-radius: 8px;
    overflow: hidden;
}
.mn-checkout-pro .mn-product-inner {
    padding: 10px 0;
    border-bottom: 1px solid #f0f0f0;
    display: flex;
    align-items: flex-start;
}
.mn-checkout-pro .mn-pro-image-outer {
    flex: 0 0 50px;
    margin-right: 10px;
}
.mn-checkout-pro .mn-pro-image img {
    width: 50px;
    height: 50px;
    object-fit: cover;
    border-radius: 4px;
}
.mn-checkout-pro .mn-pro-content {
    flex: 1;
    padding-top: 2px;
}
.mn-checkout-pro .mn-pro-title {
    font-size: 0.85rem;
    margin-bottom: 1px;
    font-weight: 500;
    line-height: 1.2;
}
.mn-checkout-pro .mn-pro-title a {
    color: #333;
    text-decoration: none;
}
.mn-checkout-pro .variant-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 1px;
}
.mn-checkout-pro .variant-info {
    font-size: 0.75rem;
    color: #666;
    display: flex;
    align-items: center;
}
.mn-checkout-pro .variant-info .mn-price {
    font-weight: 500;
    margin-right: 4px;
}
.mn-checkout-pro .variant-info .quantity {
    color: #666;
    display: flex;
    align-items: center;
}
.mn-checkout-pro .variant-info .quantity::before {
    content: "•";
    margin: 0 4px;
    opacity: 0.5;
}
.mn-checkout-pro .variant-total {
    font-size: 0.8rem;
    font-weight: 500;
    color: #333;
}

/* Summary section styling */
.mn-checkout-summary {
    margin-top: 1rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 8px;
}

/* Coupon discount styling */
.mn-checkout-summary .discount-row {
    color: #dc3545;
    font-weight: 500;
}
.mn-checkout-summary .discount-row .text-right {
    color: #dc3545;
}
.mn-checkout-summary > div {
    display: flex;
    justify-content: space-between;
    margin-bottom: 0.5rem;
    padding: 0.5rem 0;
}
.mn-checkout-summary-total {
    border-top: 1px solid #dee2e6;
    margin-top: 0.5rem;
    padding-top: 0.5rem !important;
    font-weight: 600;
    font-size: 1.1em;
}

/* Custom styles for Confirm Order button on checkout page */
.mn-checkout-section .mn-btn-2 {
    padding: 15px 35px;
    font-size: 1.1rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
}

.mn-checkout-section .mn-btn-2:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

/* Loading animation for coupon validation */
@keyframes pulse {
    0% { opacity: 0.6; }
    50% { opacity: 1; }
    100% { opacity: 0.6; }
}

.mn-checkout-summary .validating-coupon {
    color: #666;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.mn-checkout-summary .validating-coupon span {
    animation: pulse 1s infinite;
}

.mn-checkout-summary .validating-coupon i {
    width: 16px;
    height: 16px;
    border: 2px solid #666;
    border-top-color: transparent;
    border-radius: 50%;
    display: inline-block;
    animation: spin 0.75s linear infinite;
    margin-right: 8px;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* Coupon section styling */
.coupon-section {
    background: linear-gradient(145deg, #ffffff 0%, #f8f9ff 100%);
    border-radius: 16px;
    padding: 2.5rem;
    box-shadow: 0 4px 24px rgba(0, 0, 0, 0.03);
    border: 1px solid rgba(0, 0, 0, 0.05);
}

.coupon-wrapper {
    text-align: center;
}

.coupon-header i {
    font-size: 2.5rem;
    color: #4169E1;
    display: inline-block;
    transform: rotate(-15deg);
}

.coupon-header h4 {
    color: #2c3e50;
    font-weight: 600;
    font-size: 1.5rem;
}

.coupon-header p {
    color: #666;
    font-size: 0.95rem;
    margin-bottom: 0;
}

.coupon-form .input-group {
    max-width: 550px;
    margin: 0 auto;
    background: #fff;
    border-radius: 12px;
    padding: 6px;
    box-shadow: 0 2px 12px rgba(0, 0, 0, 0.04);
    border: 1px solid rgba(0, 0, 0, 0.08);
}

.coupon-form .form-control {
    border: none;
    padding: 12px 20px;
    font-size: 1rem;
    background: transparent;
    color: #2c3e50;
    font-weight: 500;
}

.coupon-form .form-control::placeholder {
    color: #94a3b8;
    font-weight: normal;
}

.coupon-form .form-control:focus {
    box-shadow: none;
}

.coupon-form .mn-btn-2 {
    padding: 12px 28px;
    border-radius: 8px;
    font-weight: 600;
    font-size: 0.95rem;
    margin: 0 4px;
    background: #4169E1;
    border: none;
    transition: all 0.3s ease;
}

.coupon-form .mn-btn-2:hover {
    background: #3154b3;
    transform: translateY(-1px);
}

/* Compact Coupon section styling */
.coupon-section {
    background: #fff;
    border-radius: 12px;
    padding: 1.2rem 1.5rem 1rem;
    box-shadow: 0 2px 12px rgba(0, 0, 0, 0.03);
}

.coupon-wrapper {
    text-align: center;
}

.coupon-title {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    color: #2c3e50;
}

.coupon-title i {
    font-size: 1.2rem;
    color: #4169E1;
}

.coupon-title span {
    font-weight: 500;
    font-size: 1rem;
}

.coupon-form .input-group {
    max-width: 450px;
    margin: 0 auto;
    background: #f8f9ff;
    border-radius: 8px;
    padding: 4px;
    border: 1px solid rgba(0, 0, 0, 0.08);
    display: flex;
    align-items: center;
}

.coupon-form .form-control {
    border: none;
    padding: 8px 12px;
    font-size: 0.95rem;
    background: transparent;
    flex: 1;
}

.coupon-form .form-control::placeholder {
    color: #94a3b8;
}

.coupon-form .form-control:focus {
    box-shadow: none;
}

.coupon-form .mn-btn-2 {
    padding: 8px 20px;
    border-radius: 6px;
    font-weight: 500;
    font-size: 0.9rem;
    background: #4169E1;
    border: none;
    transition: all 0.2s ease;
    min-width: 80px;
}

.coupon-form .mn-btn-2:hover {
    background: #3154b3;
}

/* Confirm Order Button styling */
.confirm-order-btn {
    width: 100%;
    padding: 15px 35px;
    font-size: 1.1rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
    margin-top: 1rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.confirm-order-btn span {
    display: inline-block;
}

.confirm-order-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.discount-hint {
    font-size: 0.85rem;
    color: #666;
    margin: 4px 0 0;
}

/* Compact Coupon section styling */
.coupon-section {
    background: #fff;
    border-radius: 12px;
    padding: 1.2rem 1.5rem 1rem;
    box-shadow: 0 2px 12px rgba(0, 0, 0, 0.03);
}

.coupon-wrapper {
    text-align: center;
}

.coupon-title {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    margin-bottom: 12px;
    color: #2c3e50;
}

.coupon-title i {
    font-size: 1.2rem;
    color: #4169E1;
}

.coupon-title span {
    font-weight: 500;
    font-size: 1rem;
}

.coupon-form .input-group {
    max-width: 450px;
    margin: 0 auto;
    background: #f8f9ff;
    border-radius: 8px;
    padding: 4px;
    border: 1px solid rgba(0, 0, 0, 0.08);
    display: flex;
    align-items: center;
}

.coupon-form .form-control {
    border: none;
    padding: 8px 12px;
    font-size: 0.95rem;
    background: transparent;
    flex: 1;
}

.coupon-form .form-control::placeholder {
    color: #94a3b8;
}

.coupon-form .form-control:focus {
    box-shadow: none;
}

.coupon-form .mn-btn-2 {
    padding: 8px 20px;
    border-radius: 6px;
    font-weight: 500;
    font-size: 0.9rem;
    border: none;
    transition: all 0.2s ease;
    min-width: 80px;
}

/* Enhanced Payment Method Styling */
.payment-options {
    display: flex;
    flex-direction: column;
    gap: 12px;
    margin: 20px 0;
}

.mn-pay-option {
    position: relative;
    width: 100%;
}

.mn-pay-option input[type="radio"] {
    position: absolute;
    opacity: 0;
}

.mn-pay-option label {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
    background: #fff;
    margin: 0;
    width: 100%;
}

.mn-pay-option input[type="radio"]:checked + label {
    border-color: #159abe;
    background: #f8f9ff;
}

.mn-pay-option label img {
    height: 24px;
    width: auto;
    object-fit: contain;
}

.mn-pay-option label span {
    font-weight: 500;
    color: #333;
    font-size: 0.95rem;
}

/* Professional Payment Method Styling */
.payment-options {
    display: flex;
    flex-direction: column;
    gap: 8px;
    margin: 15px 0;
}

.mn-pay-option {
    width: 100%;
}

.mn-pay-option input[type="radio"] {
    display: none;
}

.mn-pay-option label {
    position: relative;
    display: flex;
    align-items: center;
    padding: 16px 20px 16px 45px;  /* Increased left padding for radio */
    border: 1px solid #E5E7EB;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s ease;
    background: #fff;
    margin: 0;
    width: 100%;
}

.mn-pay-option input[type="radio"] + label::before {
    content: '';
    position: absolute;
    left: 20px;
    top: 50%;
    transform: translateY(-50%);
    width: 16px;
    height: 16px;
    border: 2px solid #D1D5DB;
    border-radius: 50%;
    transition: all 0.2s ease;
    background: #fff;
}

.mn-pay-option input[type="radio"]:checked + label {
    border: 1px solid #159abe;
}

.mn-pay-option input[type="radio"]:checked + label::before {
    border: 5px solid #159abe;
}

.mn-pay-option label img {
    height: 22px;
    width: auto;
    object-fit: contain;
    margin-right: 10px;
}

.mn-pay-option label span {
    font-weight: 500;
    color: #374151;
    font-size: 0.95rem;
}

/* Payment Method Title */
.payment-method-title {
    color: #374151;
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 5px;
}

.mn-checkout-pay {
    padding-top: 0;  /* Remove top padding */
}

.payment-method-subtitle {
    color: #6B7280;
    font-size: 0.9rem;
    margin: 0 0 20px;  /* Remove top margin, keep bottom margin */
}

/* Bank Details Box */
.bank-details-box {
    background: #F9FAFB;
    border: 1px solid #E5E7EB;
    border-radius: 8px;
    padding: 20px;
    margin-top: 15px;
}

.bank-details-box h5 {
    color: #374151;
    font-size: 0.95rem;
    font-weight: 600;
    margin-bottom: 15px;
}

.bank-details-box p {
    color: #4B5563;
    font-size: 0.9rem;
    margin-bottom: 8px;
    line-height: 1.5;
}

.bank-details-box .section-title {
    color: #374151;
    font-weight: 600;
    margin: 15px 0 8px 0;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="mn-breadcrumb m-b-30">
    <div class="row">
        <div class="col-12">
            <div class="row gi_breadcrumb_inner">
                <div class="col-md-6 col-sm-12">
                    <h2 class="mn-breadcrumb-title">Checkout</h2>
                </div>
                <div class="col-md-6 col-sm-12">
                    <!-- mn-breadcrumb-list start -->
                    <ul class="mn-breadcrumb-list">
                        <li class="mn-breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="mn-breadcrumb-item"><a href="<?php echo e(route('product.cart')); ?>">My Cart</a></li>
                        <li class="mn-breadcrumb-item active">Checkout</li>
                    </ul>
                    <!-- mn-breadcrumb-list end -->
                </div>
            </div>
        </div>
    </div>
</div>
<section class="mn-checkout-section p-b-15">
    <h2 class="d-none">Checkout Page</h2>
    <div class="row">
        <div class="mn-checkout-leftside col-lg-8 col-md-12">
            <!-- checkout content Start -->
            <div class="shipping-form">
                <h3 class="mb-4">Shipping Details</h3>
                <form id="shippingForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Contact Name</label>
                                <input type="text" class="form-control" name="contact_name" required value="<?php echo e(auth()->user()->shipping_addr['contact_name'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Contact Phone</label>
                                <input type="tel" class="form-control" name="contact_phone" required value="<?php echo e(auth()->user()->shipping_addr['contact_phone'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>WhatsApp Number <span class="optional">(optional)</span></label>
                                <input type="tel" class="form-control" name="whatsapp" value="<?php echo e(auth()->user()->shipping_addr['whatsapp'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Email Address <span class="optional">(optional)</span></label>
                                <input type="email" class="form-control" name="contact_email" value="<?php echo e(auth()->user()->shipping_addr['contact_email'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                            <label>Address</label>
                                <textarea class="form-control" name="address" rows="3" required><?php echo e(auth()->user()->shipping_addr['address'] ?? ''); ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>City</label>
                                <input type="text" class="form-control" name="city" required value="<?php echo e(auth()->user()->shipping_addr['city'] ?? ''); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>State</label>
                                <input type="text" class="form-control" name="state" required value="<?php echo e(auth()->user()->shipping_addr['state'] ?? ''); ?>">
                            </div>
                                </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Postal Code</label>
                                <input type="text" class="form-control" name="postal_code" required value="<?php echo e(auth()->user()->shipping_addr['postal_code'] ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Coupon Section -->
            <div class="coupon-section mt-4">
                <div class="row">
                    <div class="col-lg-7 mx-auto">
                        <div class="coupon-wrapper">
                            <div class="coupon-header">
                                <div class="coupon-title">
                                    <i class="ri-coupon-3-line"></i>
                                    Have a Coupon Code?
                                </div>
                                <p class="discount-hint">Use coupon code to get special discounts on your order!</p>
                            </div>
                            <form class="coupon-form mt-2">
                                <div class="input-group">
                                    <input type="text" id="coupon_code" name="coupon_code" class="form-control" placeholder="Enter coupon code" required>
                                    <button type="submit" class="mn-btn-2"><span>Apply</span></button>
                                </div>
                                <input type="hidden" id="applied_coupon_data" name="applied_coupon_data" value="">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!--cart content End -->
        </div>
        <!-- Sidebar Area Start -->
        <div class="mn-checkout-rightside col-lg-4 col-md-12 m-t-991">
            <div class="mn-sidebar-wrap">
                <!-- Sidebar Summary Block -->
                <div class="mn-sidebar-block">
                    <div class="mn-sb-title">
                        <h3 class="mn-sidebar-title">Order Details</h3>
                    </div>
                    <div class="mn-sb-block-content">
                        <div class="mn-checkout-pro">
                            <!-- Cart items will be inserted here -->
                        </div>
                        <div class="mn-checkout-summary mt-4">
                            <div>
                                <span class="text-left">Sub-Total</span>
                                <span class="text-right">৳0</span>
                            </div>
                            <div>
                                <span class="text-left">Delivery Charge</span>
                                <span class="text-right">৳60</span>
                            </div>
                            <div class="discount-row" style="display: none;">
                                <span class="text-left">Coupon Discount</span>
                                <span class="text-right">৳0</span>
                            </div>
                            <div class="validating-coupon" style="display: none;">
                                <span class="text-left"><i></i>Validating coupon...</span>
                                <span class="text-right">...</span>
                            </div>
                            <div class="mn-checkout-summary-total">
                                <span class="text-left">Total Amount</span>
                                <span class="text-right">৳0</span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Sidebar Summary Block -->
            </div>
            <div class="mn-sidebar-wrap mn-checkout-del-wrap">
                <!-- Payment Method Block -->
                <div class="mn-sidebar-block">
                    <div class="mn-sb-title">
                        <h3 class="mn-sidebar-title">Payment Method</h3>
                    </div>
                    <div class="mn-sb-block-content">
                        <div class="mn-checkout-pay">
                            <p class="payment-method-subtitle">Please select the preferred payment method to use on this order.</p>
                            <div class="payment-options">
                                <div class="mn-pay-option">
                                    <input type="radio" id="paySSL" name="payment_method" value="sslcommerz" form="shippingForm" checked>
                                    <label for="paySSL">
                                        <img src="<?php echo e(asset('assets/digital_pay.png')); ?>" alt="Digital Payment" style="width:28px;height:28px;margin-right:10px;border-radius:4px;">
                                        <span>Digital Payment</span>
                                    </label>
                                </div>
                                <div class="mn-pay-option">
                                    <input type="radio" id="payCOD" name="payment_method" value="cod" form="shippingForm">
                                    <label for="payCOD">
                                        <img src="<?php echo e(asset('assets/cod.png')); ?>" alt="Cash On Delivery" style="width:28px;height:28px;margin-right:10px;border-radius:4px;">
                                        <span>Cash On Delivery</span>
                                    </label>
                                </div>
                            </div>
                            <div class="text-center mt-4">
                                <button type="button" class="mn-btn-2 confirm-order-btn" onclick="placeOrder()">
                                    <span>I Confirm My Order</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
// Check if cart is empty and redirect to cart page if it is
document.addEventListener('DOMContentLoaded', function() {
    const cart = JSON.parse(localStorage.getItem('sb_cart') || '[]');
    if (!cart.length) {
        window.location.href = '<?php echo e(route("product.cart")); ?>';
        return;
    }

    let validCouponData = null; // Store complete coupon data
    
    fetch(`${window.location.origin}/cart/items`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(cart)
    })
    .then(response => response.json())
    .then(data => {
        updateCartDisplay(data);
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('Error loading cart items', 'error');
    });

    // Handle coupon form submission
    const couponForm = document.querySelector('.coupon-form');
    if (couponForm) {
        couponForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const codeInput = this.querySelector('input[name="coupon_code"]');
            const code = codeInput.value.trim();
            if (!code) {
                showNotification('Please enter a coupon code', 'error');
                return;
            }

            const subtotal = parseFloat(document.querySelector('.mn-checkout-summary div:first-child .text-right').textContent.replace('৳', ''));

            // Disable the submit button and show loading state
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<span>Apply</span>';

            // Show loading animation
            const discountRow = document.querySelector('.mn-checkout-summary .discount-row');
            const loadingRow = document.querySelector('.mn-checkout-summary .validating-coupon');
            discountRow.style.display = 'none';
            loadingRow.style.display = 'flex';

            // Start time for minimum delay
            const startTime = Date.now();

            fetch('<?php echo e(route("product.validate.coupon")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ code, subtotal })
            })
            .then(response => response.json())
            .then(data => {
                // Calculate remaining time to meet minimum delay
                const elapsedTime = Date.now() - startTime;
                const remainingDelay = Math.max(0, 1000 - elapsedTime);

                // Wait for minimum delay before showing results
                setTimeout(() => {
                    // Hide loading animation
                    loadingRow.style.display = 'none';

                    if (data.valid) {
                        // Store complete coupon data in hidden field
                        document.getElementById('applied_coupon_data').value = JSON.stringify({
                            code: code,
                            type: data.type,
                            value: data.value,
                            discount: data.discount
                        });
                        
                        // Update discount display
                        discountRow.style.display = 'flex';
                        discountRow.querySelector('.text-right').textContent = '-৳' + data.discount;

                        // Update total
                        const subtotal = parseFloat(document.querySelector('.mn-checkout-summary div:first-child .text-right').textContent.replace('৳', ''));
                        const deliveryCharge = 60;
                        const total = subtotal + deliveryCharge - data.discount;
                        document.querySelector('.mn-checkout-summary-total .text-right').textContent = '৳' + total;

                        // Show success message
                        if (data.type === 'percentage') {
                            showNotification(`Congratulations! You got ${data.value}% discount on your order!`, 'success');
                        } else {
                            showNotification(`Congratulations! Coupon applied successfully!`, 'success');
                        }
                    } else {
                        // Clear hidden field if coupon is invalid
                        document.getElementById('applied_coupon_data').value = '';
                        discountRow.style.display = 'none';
                        showNotification(data.message || 'Invalid coupon code', 'error');
                    }
                }, remainingDelay);
            })
            .catch(error => {
                // Calculate remaining time to meet minimum delay
                const elapsedTime = Date.now() - startTime;
                const remainingDelay = Math.max(0, 1000 - elapsedTime);

                setTimeout(() => {
                    // Hide loading animation
                    loadingRow.style.display = 'none';
                    
                    console.error('Error:', error);
                    showNotification('Error validating coupon', 'error');
                    discountRow.style.display = 'none';
                }, remainingDelay);
            })
            .finally(() => {
                // Re-enable the submit button
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalBtnText;
                // Clear the input field
                codeInput.value = '';
            });
        });
    }
});

function updateCartDisplay(data) {
    // Group items by product ID
    const groupedItems = {};
    data.items.forEach(item => {
        if (!groupedItems[item.id]) {
            groupedItems[item.id] = {
                id: item.id,
                title: item.title,
                image: item.image,
                url: item.url,
                variants: []
            };
        }
        groupedItems[item.id].variants.push({
            id: item.variant_id,
            price: item.price,
            quantity: item.quantity,
            unit: item.unit
        });
    });

    // Generate HTML for grouped items
    const cartItemsHtml = Object.values(groupedItems).map(product => `
        <div class="mn-product-inner">
            <div class="mn-pro-image-outer">
                <div class="mn-pro-image">
                    <a href="${product.url}">
                        <img src="${product.image}" alt="${product.title}">
                    </a>
                </div>
            </div>
            <div class="mn-pro-content">
                <h5 class="mn-pro-title">
                    <a href="${product.url}">${product.title}</a>
                </h5>
                ${product.variants.map(variant => `
                    <div class="variant-row">
                        <div class="variant-info">
                            <span class="mn-price">৳${variant.price}</span>
                            <span class="quantity">${variant.quantity} × ${variant.unit}</span>
                        </div>
                        <span class="variant-total">৳${variant.price * variant.quantity}</span>
                    </div>
                `).join('')}
            </div>
        </div>
    `).join('');
    
    document.querySelector('.mn-checkout-pro').innerHTML = cartItemsHtml;

    // Update totals
    document.querySelector('.mn-checkout-summary div:first-child .text-right').textContent = '৳' + data.totals.sub_total;
    const total = data.totals.sub_total + 60; // 60 is delivery charge
    document.querySelector('.mn-checkout-summary-total .text-right').textContent = '৳' + total;
}

function placeOrder() {
    // Get all form data
    const formData = new FormData(document.getElementById('shippingForm'));
    const cartItems = JSON.parse(localStorage.getItem('sb_cart') || '[]');
    
    // Add cart items to form data
    formData.append('cart_items', JSON.stringify(cartItems));
    
    // Add payment method
    const selectedPayment = document.querySelector('input[name="payment_method"]:checked');
    if (!selectedPayment) {
        showNotification('Please select a payment method', 'error');
        return;
    }
    formData.append('payment_method', selectedPayment.value);

    // No extra fields needed for SSLCommerz
    
    // Add coupon data if applied
    const appliedCouponData = document.getElementById('applied_coupon_data').value;
    if (appliedCouponData) {
        formData.append('coupon_code', appliedCouponData);
    }

    // Convert FormData to object for fetch
    const data = {};
    formData.forEach((value, key) => data[key] = value);

    // Submit order
    fetch('<?php echo e(route("product.place.order")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            if (data.redirect_to_gateway) {
                window.location.href = data.redirect_to_gateway;
                return;
            }
            // COD: Clear cart and go to invoice
            localStorage.removeItem('sb_cart');
            document.getElementById('applied_coupon_data').value = '';
            window.location.href = data.redirect_url;
        } else {
            showNotification(data.message || 'Error placing order', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('Error placing order. Please try again.', 'error');
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/product/checkout.blade.php ENDPATH**/ ?>