<?php $__env->startSection("title", "Shipping Details"); ?>
<?php $__env->startSection("style"); ?>
<?php echo $__env->make('partial.user_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
<div class="container account-wrapper">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            <?php echo $__env->make('partial.user_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <h5 class="mb-4">Shipping Details</h5>
                <form action="<?php echo e(route('shipping.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contact_name">Contact Name</label>
                                <input type="text" class="form-control" id="contact_name" name="contact_name" 
                                    value="<?php echo e(old('contact_name', auth()->user()->shipping_addr['contact_name'] ?? '')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contact_phone">Contact Phone</label>
                                <input type="tel" class="form-control" id="contact_phone" name="contact_phone" 
                                    value="<?php echo e(old('contact_phone', auth()->user()->shipping_addr['contact_phone'] ?? '')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="whatsapp">WhatsApp Number <span class="text-muted small">(optional)</span></label>
                                <input type="tel" class="form-control" id="whatsapp" name="whatsapp" 
                                    value="<?php echo e(old('whatsapp', auth()->user()->shipping_addr['whatsapp'] ?? '')); ?>">
                                <small class="text-muted fs-12">Leave empty if same as contact phone</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contact_email">Email Address <span class="text-muted small">(optional)</span></label>
                                <input type="email" class="form-control" id="contact_email" name="contact_email" 
                                    value="<?php echo e(old('contact_email', auth()->user()->shipping_addr['contact_email'] ?? '')); ?>">
                                <small class="text-muted fs-12">Alternative email for shipping updates</small>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="address">Address</label>
                                <textarea class="form-control" id="address" name="address" rows="3" required><?php echo e(old('address', auth()->user()->shipping_addr['address'] ?? '')); ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="city">City</label>
                                <input type="text" class="form-control" id="city" name="city" 
                                    value="<?php echo e(old('city', auth()->user()->shipping_addr['city'] ?? '')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="state">State</label>
                                <input type="text" class="form-control" id="state" name="state" 
                                    value="<?php echo e(old('state', auth()->user()->shipping_addr['state'] ?? '')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="postal_code">Postal Code</label>
                                <input type="text" class="form-control" id="postal_code" name="postal_code" 
                                    value="<?php echo e(old('postal_code', auth()->user()->shipping_addr['postal_code'] ?? '')); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="mn-btn-2">
                            <span><i class="ri-save-line me-1"></i> Save Address</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/user/shipping.blade.php ENDPATH**/ ?>