<?php $__env->startSection("title", $product->meta_title); ?>
<?php $__env->startSection("meta"); ?>
    <meta property="og:title" content="<?php echo e($product->title); ?>">
    <meta property="og:description" content="<?php echo e(strip_tags($product->description)); ?>">
    <meta property="og:image" content="<?php echo e($product->primary_image->url); ?>">
    <meta property="og:url" content="<?php echo e(route('product.view', ['slug' => $product->slug])); ?>">
    <meta property="og:type" content="product">
    <meta property="product:price:amount" content="<?php echo e($product->variations->where('default', true)->first()->price); ?>">
    <meta property="product:price:currency" content="BDT">
    <!-- Twitter Card tags -->
    <meta name="twitter:card" content="product">
    <meta name="twitter:title" content="<?php echo e($product->title); ?>">
    <meta name="twitter:description" content="<?php echo e(strip_tags($product->description)); ?>">
    <meta name="twitter:image" content="<?php echo e($product->primary_image->url); ?>">
    <!-- Schema.org markup for rich snippets -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org/",
        "@type": "Product",
        "name": "<?php echo e($product->title); ?>",
        "description": "<?php echo e(strip_tags($product->description)); ?>",
        "image": "<?php echo e($product->primary_image->url); ?>",
        "offers": {
            "@type": "Offer",
            "priceCurrency": "BDT",
            "price": "<?php echo e($product->variations->where('default', true)->first()->price); ?>",
            "availability": "<?php echo e($product->variations->where('default', true)->first()->in_stock > 0 ? 'https://schema.org/InStock' : 'https://schema.org/OutOfStock'); ?>"
        }
    }
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
.mn-breadcrumb .gi_breadcrumb_inner .mn-breadcrumb-list{
    text-align: unset !important;
}

/* Quantity Controls */
.qty-plus-minus {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background: #fff;
    padding: 4px 8px;
    border: 1px solid #dee2e6;
    border-radius: 4px;
}

.qty-plus-minus .qty-minus,
.qty-plus-minus .qty-plus {
    cursor: pointer;
    user-select: none;
    color: #666;
}

.qty-plus-minus .qty-input {
    width: 24px;
    border: none;
    text-align: center;
    background: transparent;
}

/* Stock Status Styles */
.mn-stock-status {
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 14px;
    margin-top: 10px;
    margin-bottom: 20px;
}

.status-indicator {
    display: flex;
    align-items: center;
    gap: 6px;
    color: #0d8a1f;
    font-weight: 500;
}

.status-indicator.out-of-stock {
    color: #c62828;
}

/* Stock Level Indicator */
.stock-bar-container {
    width: 8px;
    height: 20px;
    background: #e0e0e0;
    border-radius: 4px;
    position: relative;
    overflow: hidden;
    margin-left: 4px;
}

.stock-bar {
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    background-color: #0d8a1f; /* Default green color */
    transition: height 0.3s ease, background-color 0.3s ease;
    border-radius: 4px;
}

/* Stock bar states */
.stock-bar.high {
    height: 100%;
    background-color: #0d8a1f; /* Green */
}

.stock-bar.medium {
    height: 60%;
    background-color: #ffa000; /* Orange/Yellow */
}

.stock-bar.low {
    height: 30%;
    background-color: #c62828; /* Red */
}

.stock-bar.out {
    height: 0%;
    background-color: #c62828; /* Red */
}

/* Add to CSS section */
.mn-social-share {
    margin: 30px 0;
    padding: 20px 0;
    border-top: 1px solid #eee;
}

.mn-social-share span {
    display: block;
    margin-bottom: 12px;
    font-size: 14px;
    color: #666;
}

.mn-social-share ul {
    display: flex;
    gap: 12px;
    list-style: none;
    padding: 0;
    margin: 0;
}

.mn-social-share li a {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    border-radius: 4px;
    color: #fff;
    font-size: 14px;
    transition: opacity 0.2s;
}

.mn-social-share li a:hover {
    opacity: 0.9;
}

.mn-social-share .facebook {
    background: #3b5998;
}

.mn-social-share .twitter {
    background: #14171A;
}

.mn-social-share .whatsapp {
    background: #25d366;
}

.mn-social-share .telegram {
    background: #0088cc;
}

.mn-social-share .pinterest {
    background: #e60023;
}

.mn-product-features {
    margin-top: 5px;
    margin-bottom: 30px;
}

.mn-product-features ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.mn-product-features li {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 6px 0;
    color: #444;
    font-size: 14px;
}

.mn-product-features li i {
    font-size: 6px;
    color: #444;
}

/* Reviews section width tuning */
.sb-reviews-container {
    max-width: 980px;
    margin: 0;
}
.sb-progress-wrap {
    width: 82%;
}
.sb-reviews-head h5 {
    font-weight: 600;
    margin-bottom: 0;
}
.sb-reviews-container .row > [class^='col-'] { padding-top: 4px; padding-bottom: 4px; }
.sb-row-count { margin-bottom: 6px !important; }
.mn-ratting-content { margin-top: 8px; }
.sb-rating-score {
    font-size: 80px;
    font-weight: 500;
    line-height: 1;
}
.sb-rating-divider {
    color: #6c757d;
    font-size: 50px;
}
.sb-rating-light {
    color: #6c757d;
}
.sb-row-count a { color: inherit; text-decoration: none; }
.sb-row-count a:hover { text-decoration: underline; }
.sb-rating-stars { display: flex; justify-content: center; gap: 4px; }
.mn-t-review-rating.mn-pro-rating {
    cursor: pointer;
}
.mn-t-review-rating.mn-pro-rating i {
    font-size: 50px !important;
}
.mn-product-card .mn-product-detail .cat a { text-transform: none !important; }
.mn-card-meta { display:flex; align-items:center; justify-content:space-between; margin:-4px 0 6px 0; }
.mn-card-rating { display:inline-flex; align-items:center; gap:4px; font-size:14px; }
.mn-card-rating .num { color:#666; }

/* Main product image gallery styles */
.single-product-cover {
    width: 100%;
    position: relative;
    overflow: hidden;
    background: #fff;
    border-radius: 12px;
}

.single-product-cover .single-slide {
    display: flex !important;
    align-items: center;
    justify-content: center;
    height: 500px;
    overflow: hidden;
}

.single-product-cover .single-slide img {
    width: 100%;
    height: 100%;
    object-fit: contain;
    object-position: center;
}

/* Thumbnail navigation */
.single-nav-thumb {
    margin-top: 15px;
}

.single-nav-thumb .single-slide {
    height: 90px;
    width: 90px;
    border-radius: 8px;
    overflow: hidden;
    margin: 0 5px;
    cursor: pointer;
    border: 1px solid #eee;
    background: #fff;
    display: flex !important;
    align-items: center;
    justify-content: center;
}

.single-nav-thumb .single-slide img {
    width: 100%;
    height: 100%;
    object-fit: contain;
    object-position: center;
}

/* Responsive adjustments */
@media (max-width: 991px) {
    .single-product-cover .single-slide {
        height: 400px;
    }
}

@media (max-width: 767px) {
    .single-product-cover .single-slide {
        height: 350px;
    }
    .single-nav-thumb .single-slide {
        height: 70px;
        width: 70px;
    }
}

@media (max-width: 480px) {
    .single-product-cover .single-slide {
        height: 300px;
    }
    .single-nav-thumb .single-slide {
        height: 60px;
        width: 60px;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="mn-breadcrumb m-b-30">
    <div class="row">
        <div class="col-12">
            <div class="row gi_breadcrumb_inner">
                <div></div>
                <div class="col-12">
                    <!-- mn-breadcrumb-list start -->
                    <ul class="mn-breadcrumb-list">
                        <li class="mn-breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="mn-breadcrumb-item"><a href="<?php echo e(route('product.list')); ?>">Products</a></li>
                        <?php if($product->category->parent): ?>
                            <li class="mn-breadcrumb-item">
                                <a href="<?php echo e(route('product.list', ['category' => $product->category->parent->slug])); ?>">
                                    <?php echo e($product->category->parent->name); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="mn-breadcrumb-item">
                            <a href="<?php echo e(route('product.list', ['category' => $product->category->slug])); ?>">
                                <?php echo e($product->category->name); ?>

                            </a>
                        </li>
                        <li class="mn-breadcrumb-item active"><?php echo e($product->title); ?></li>
                    </ul>
                    <!-- mn-breadcrumb-list end -->
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-xxl-12">
        <section class="mn-single-product">
            <div class="row">
                <div class="mn-pro-rightside mn-common-rightside col-lg-12 col-md-12 m-b-15">
                    <!-- Single product content Start -->
                    <div class="single-pro-block">
                        <div class="single-pro-inner">
                            <div class="row">
                                <div class="single-pro-img single-pro-img-no-sidebar">
                                    <div class="single-product-scroll">
                                        <div class="single-product-cover">
                                            <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="single-slide zoom-image-hover">
                                                    <img class="img-responsive" src="<?php echo e($image->url); ?>"
                                                        alt="<?php echo e($image->alt_text ?? $product->title); ?>">
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <div class="single-nav-thumb">
                                            <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="single-slide">
                                                    <img class="img-responsive" src="<?php echo e($image->url); ?>"
                                                        alt="<?php echo e($image->alt_text ?? $product->title); ?>">
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="single-pro-desc single-pro-desc-no-sidebar m-t-991">
                                    <div class="single-pro-content">
                                        <h5 class="mn-single-title"><?php echo e($product->title); ?></h5>
                                        
                                        <?php
                                            $defaultVariation = $product->variations->where('default', true)->first();
                                        ?>

                                        <div class="mn-single-rating-wrap" data-product-id="<?php echo e($product->id); ?>">
                                            <div class="mn-single-rating mn-pro-rating">
                                                <?php 
                                                    $avgRating = $product->average_rating ?? ($product->averageRating ?? 0);
                                                    $fullStars = floor($avgRating);
                                                    $halfStar = ($avgRating - $fullStars) >= 0.5;
                                                    $emptyStars = 5 - $fullStars - ($halfStar ? 1 : 0);
                                                ?>
                                                
                                                <?php for($i = 0; $i < $fullStars; $i++): ?>
                                                    <i class="ri-star-fill"></i>
                                                <?php endfor; ?>
                                                
                                                <?php if($halfStar): ?>
                                                    <i class="ri-star-half-s-fill"></i>
                                                <?php endif; ?>
                                                
                                                <?php for($i = 0; $i < $emptyStars; $i++): ?>
                                                    <i class="ri-star-fill grey"></i>
                                                <?php endfor; ?>
                                            </div>
                                            <span class="mn-read-review">
                                                |&nbsp;&nbsp;<a href="#mn-spt-nav-review"><?php echo e($totalRatings); ?> Ratings</a>
                                                <?php if($avgRating > 0): ?>
                                                    <span class="ms-2">(<?php echo e(number_format($avgRating, 1)); ?>)</span>
                                                <?php endif; ?>
                                            </span>
                                        </div>

                                        <div class="mn-single-price-stoke">
                                            <div class="mn-single-price">
                                                <?php if($defaultVariation): ?>
                                                    <div class="final-price">৳<?php echo e(number_format($defaultVariation->sale_price)); ?>

                                                        <?php if($defaultVariation->regular_price > $defaultVariation->sale_price): ?>
                                                            <span class="price-des">
                                                                -<?php echo e(round((($defaultVariation->regular_price - $defaultVariation->sale_price) / $defaultVariation->regular_price) * 100)); ?>%
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php if($defaultVariation->regular_price > $defaultVariation->sale_price): ?>
                                                        <div class="mrp">Regular Price: <span>৳<?php echo e(number_format($defaultVariation->regular_price)); ?></span></div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <?php if($product->features): ?>
                                            <div class="mn-product-features">
                                                <ul>
                                                    <?php $__currentLoopData = $product->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><i class="ri-checkbox-blank-circle-fill"></i> <?php echo e($feature); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>

                                        <?php if($defaultVariation): ?>
                                            <div class="mn-stock-status">
                                                <div class="stock-bar-container">
                                                    <div class="stock-bar <?php echo e($defaultVariation->is_out_of_stock() ? 'out' : ($defaultVariation->is_critical_stock() ? 'low' : 'high')); ?>"></div>
                                                </div>
                                                <div class="status-indicator <?php echo e($defaultVariation->is_out_of_stock() ? 'out-of-stock' : 'in-stock'); ?>">
                                                    <span><?php echo e($defaultVariation->stock_status()); ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="mn-pro-variation">
                                            <div class="mn-pro-variation-inner mn-pro-variation-size m-b-24">
                                                <span>VARIATION</span>
                                                <div class="mn-pro-variation-content">
                                                    <ul>
                                                        <?php $__currentLoopData = $product->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="<?php echo e($variation->default ? 'active' : ''); ?>" 
                                                                data-variation-id="<?php echo e($variation->id); ?>"
                                                                data-in-stock="<?php echo e($variation->in_stock); ?>"
                                                                data-sale-price="<?php echo e($variation->sale_price); ?>"
                                                                data-regular-price="<?php echo e($variation->regular_price); ?>">
                                                                <span><?php echo e($variation->unit_value); ?></span>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mn-single-qty">
                                            <div class="qty-plus-minus">
                                                <span class="qty-minus">-</span>
                                                <input class="qty-input" type="text" value="1" readonly>
                                                <span class="qty-plus">+</span>
                                            </div>
                                            <div class="mn-btns">
                                                <div class="mn-single-cart">
                                                    <button class="btn btn-primary mn-btn-2 mn-add-cart main-product-cart" 
                                                            data-product-id="<?php echo e($product->id); ?>"
                                                            <?php echo e(!$defaultVariation || $defaultVariation->is_out_of_stock() ? 'disabled' : ''); ?>>
                                                        <span><i class="ri-shopping-cart-line me-1"></i>Add to Cart</span>
                                                    </button>
                                                </div>
                                                <div class="mn-single-wishlist">
                                                    <a href="javascript:void(0)" 
                                                       class="mn-btn-group wishlist mn-wishlist" 
                                                       data-product-id="<?php echo e($product->id); ?>" 
                                                       title="Wishlist">
                                                        <i class="ri-heart-line"></i>
                                                    </a>
                                                </div>
                                                <div class="mn-single-wishlist">
                                                    <a href="javascript:void(0)" 
                                                       class="mn-btn-group mn-compare" 
                                                       data-product-id="<?php echo e($product->id); ?>" 
                                                       title="Compare">
                                                        <i class="ri-repeat-line"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Social Share Buttons -->
                                        <div class="mn-social-share">
                                            <span>Share this product</span>
                                            <ul>
                                                <li>
                                                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(request()->url())); ?>" 
                                                       target="_blank" 
                                                       class="facebook">
                                                        <i class="ri-facebook-fill"></i>
                                                        Facebook
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="https://twitter.com/intent/tweet?url=<?php echo e(urlencode(request()->url())); ?>&text=<?php echo e(urlencode($product->title)); ?>" 
                                                       target="_blank" 
                                                       class="twitter">
                                                        <i class="ri-twitter-x-fill"></i>
                                                        Twitter
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="https://wa.me/?text=<?php echo e(urlencode($product->title . ': ' . request()->url())); ?>" 
                                                       target="_blank" 
                                                       class="whatsapp">
                                                        <i class="ri-whatsapp-fill"></i>
                                                        WhatsApp
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="https://t.me/share/url?url=<?php echo e(urlencode(request()->url())); ?>&text=<?php echo e(urlencode($product->title)); ?>" 
                                                       target="_blank" 
                                                       class="telegram">
                                                        <i class="ri-telegram-fill"></i>
                                                        Telegram
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="https://pinterest.com/pin/create/button/?url=<?php echo e(urlencode(request()->url())); ?>&description=<?php echo e(urlencode($product->title)); ?>" 
                                                       target="_blank" 
                                                       class="pinterest">
                                                        <i class="ri-pinterest-fill"></i>
                                                        Pinterest
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Single product content End -->
                    <!-- Single product tab start -->
                    <div class="mn-single-pro-tab">
                        <div class="mn-single-pro-tab-wrapper">
                            <div class="mn-single-pro-tab-nav">
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="details-tab"
                                            data-bs-toggle="tab" data-bs-target="#mn-spt-nav-details"
                                            type="button" role="tab" aria-controls="mn-spt-nav-details"
                                            aria-selected="true">Detail</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="info-tab" data-bs-toggle="tab"
                                            data-bs-target="#mn-spt-nav-info" type="button" role="tab"
                                            aria-controls="mn-spt-nav-info"
                                            aria-selected="false">Specifications</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="review-tab" data-bs-toggle="tab"
                                            data-bs-target="#mn-spt-nav-review" type="button" role="tab"
                                            aria-controls="mn-spt-nav-review"
                                            aria-selected="false">Reviews</button>
                                    </li>
                                </ul>
                            </div>
                            <div class="tab-content mn-single-pro-tab-content">
                                <div id="mn-spt-nav-details" class="tab-pane fade show active">
                                    <div class="mn-single-pro-tab-desc">
                                        <?php echo $product->description; ?>

                                    </div>
                                </div>
                                <div id="mn-spt-nav-info" class="tab-pane fade">
                                    <div class="mn-single-pro-tab-moreinfo">
                                        <?php if($product->specification && is_array($product->specification)): ?>
                                            <ul>
                                                <?php $__currentLoopData = $product->specification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <span><?php echo e($spec['key']); ?></span>
                                                        <?php echo e($spec['value']); ?>

                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php else: ?>
                                            <p>No specifications available.</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div id="mn-spt-nav-review" class="tab-pane fade sb-reviews-container" style="max-width: 980px;">
                                    <div id="reviews-root" data-product-id="<?php echo e($product->id); ?>">
                                        <?php echo $__env->make('partial.reviews', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Related Section -->
                    <?php if($relatedProducts->isNotEmpty()): ?>
                    <section class="mn-related-product my-5">
                        <div class="mn-title">
                            <h2>Related <span>Products</span></h2>
                        </div>
                        <div class="mn-related owl-carousel">
                            <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mn-product-card" 
                                    data-product-id="<?php echo e($relatedProduct->id); ?>"
                                    data-default-variant-id="<?php echo e($relatedProduct->variations->where('default', true)->first()->id); ?>">
                                    <div class="mn-product-img">
                                        <div class="mn-img">
                                            <a href="<?php echo e(route('product.view', ['slug' => $relatedProduct->slug])); ?>" class="image">
                                                <img class="main-img" 
                                                    src="<?php echo e($relatedProduct->primary_image->url); ?>" 
                                                    alt="<?php echo e($relatedProduct->title); ?>">
                                            </a>
                                            <div class="mn-pro-loader"></div>
                                            <div class="mn-options mn-options-always-visible">
                                                <ul>
                                                    <li>
                                                        <a href="javascript:void(0)" 
                                                           data-tooltip 
                                                           title="Wishlist" 
                                                           class="mn-wishlist"
                                                           data-product-id="<?php echo e($relatedProduct->id); ?>">
                                                            <i class="ri-heart-line"></i>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:void(0)" 
                                                           data-tooltip 
                                                           title="Compare" 
                                                           class="mn-compare" 
                                                           data-product-id="<?php echo e($relatedProduct->id); ?>">
                                                            <i class="ri-repeat-line"></i>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <?php
                                                            $defaultInStock = ($relatedProduct->relationLoaded('variations')
                                                                 ? (int)optional($relatedProduct->variations->first())->in_stock > 0
                                                                 : (int)($relatedProduct->variations()->where('default', true)->value('in_stock') ?? 0) > 0);
                                                             $variantsCount = $relatedProduct->variants_count ?? $relatedProduct->variations()->count();
                                                             $allOut = ($relatedProduct->in_stock_variants_count ?? $relatedProduct->variations()->where('in_stock', '>', 0)->count()) === 0;
                                                             $defaultOut = !$defaultInStock;
                                                        ?>
                                                        <?php if($variantsCount > 1 && $defaultOut && !$allOut): ?>
                                                            <a href="<?php echo e(route('product.view', ['slug' => $relatedProduct->slug])); ?>" data-tooltip title="Open" class="mn-add-cart open-link">
                                                                <i class="ri-eye-line"></i>
                                                                Open
                                                            </a>
                                                        <?php elseif(($variantsCount === 1 && $defaultOut) || ($variantsCount > 1 && $allOut)): ?>
                                                            <a href="javascript:void(0)" class="mn-add-cart out-stock disabled" style="pointer-events: none; opacity: .85; background: #dc3545; border-color: #dc3545; color: #fff;">
                                                                <i class="ri-close-line"></i>
                                                                Out of stock
                                                            </a>
                                                        <?php else: ?>
                                                            <a href="javascript:void(0)" data-tooltip title="Add To Cart" class="mn-add-cart">
                                                                <i class="ri-shopping-cart-line"></i>
                                                                Add to Cart
                                                            </a>
                                                        <?php endif; ?>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mn-product-detail">
                                        <div class="cat" style="display:flex; align-items:center; justify-content:space-between; gap:10px;">
                                            <a href="<?php echo e(route('product.list', ['category' => $relatedProduct->category->slug])); ?>">
                                                <?php echo e($relatedProduct->category->name); ?>

                                            </a>
                                            <?php if($relatedProduct->brand): ?>
                                                <a href="<?php echo e(route('product.list', ['brand' => Str::slug($relatedProduct->brand->title)])); ?>">
                                                    <?php echo e($relatedProduct->brand->title); ?>

                                                </a>
                                            <?php endif; ?>
                                        </div>
                                        <h5>
                                            <a href="<?php echo e(route('product.view', ['slug' => $relatedProduct->slug])); ?>">
                                                <?php echo e($relatedProduct->title); ?>

                                            </a>
                                        </h5>
                                        <?php $avg = $relatedProduct->average_rating ?? ($relatedProduct->averageRating ?? 0); ?>
                                        <div class="mn-card-meta">
                                            <div class="mn-price" style="margin:0;">
                                            <?php
                                                $defaultVariation = $relatedProduct->variations->where('default', true)->first();
                                            ?>
                                            <?php if($defaultVariation): ?>
                                                <div class="mn-price-new">৳<?php echo e(number_format($defaultVariation->sale_price)); ?></div>
                                                <?php if($defaultVariation->regular_price > $defaultVariation->sale_price): ?>
                                                    <div class="mn-price-old">৳<?php echo e(number_format($defaultVariation->regular_price)); ?></div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            </div>
                                            <div class="mn-card-rating">
                                                <?php
                                                    $icon = 'ri-star-line';
                                                    if ($avg >= 0.75) { $icon = 'ri-star-fill'; }
                                                    elseif ($avg >= 0.25) { $icon = 'ri-star-half-s-fill'; }
                                                ?>
                                                <i class="<?php echo e($icon); ?>"></i>
                                                <span class="num"><?php echo e(number_format($avg,1)); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </section>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
// Store all variations data
const variations = <?php echo json_encode($product->variations, 15, 512) ?>;
const stockThresholds = <?php echo json_encode($stockThresholds, 15, 512) ?>;

// Initialize owl carousel for related products
$(".mn-related").owlCarousel({
    margin: 24,
    loop: false,
    rewind: true,
    dots: true,
    nav: false,
    smartSpeed: 500,
    autoplayTimeout: 3000,
    items: 1,
    responsiveClass: true,
    responsive: {
        0: {
            items: 1,
            dots: false,
        },
        461: {
            items: 1,
        },
        768: {
            items: 2,
        },
        992: {
            items: 3,
        },
        1200: {
            items: 3,
        },
        1400: {
            items: 4,
        },
        1600: {
            items: 5,
        },
    },
});
document.addEventListener('DOMContentLoaded', function() {
  var stars = document.querySelectorAll('#ratingStars i');
  var input = document.getElementById('ratingInput');
  if (stars.length && input) {
    stars.forEach(function(star) {
      star.addEventListener('click', function() {
        var value = parseInt(this.getAttribute('data-value'));
        input.value = value;
        stars.forEach(function(s, idx){
          if (idx < value) s.classList.remove('grey'); else s.classList.add('grey');
        });
      });
    });
  }
});
// AJAX Reviews loader
(function(){
  const root = document.getElementById('reviews-root');
  if(!root) return;
  const productId = root.getAttribute('data-product-id');

  function loadReviews(params){
    const search = new URLSearchParams(params || {}).toString();
    fetch(`${window.location.origin}${`/product/` + productId + `/reviews`}?${search}`, { headers: { 'X-Requested-With': 'XMLHttpRequest' } })
      .then(r=>r.text())
      .then(html=>{ root.innerHTML = html; bind(); })
      .catch(()=>{});
  }

  function submitReview(form){

    const url = form.getAttribute('action');
    const formData = new FormData(form);
    fetch(url, {
      method: 'POST',
      headers: { 'X-Requested-With': 'XMLHttpRequest', 'X-CSRF-TOKEN': form.querySelector('input[name=_token]').value },
      body: formData
    }).then(r=>r.json())
      .then(res=>{
        if(res.success){
          root.innerHTML = res.html; bind();
          if(window.showNotification){ try{ showNotification('Review submitted successfully'); }catch(e){} }
        }
      }).catch(()=>{ if(window.showNotification){ try{ showNotification('Failed to submit review'); }catch(e){} } });
  }

  function bind(){
    const sort = root.querySelector('.js-review-sort');
    const star = root.querySelector('.js-review-star');
    if(sort) sort.addEventListener('change', ()=>loadReviews({ sort: sort.value, star: star ? star.value : 0 }));
    if(star) star.addEventListener('change', ()=>loadReviews({ sort: sort ? sort.value : 'latest', star: star.value }));

    // delete
    const delBtn = root.querySelector('.js-delete-rating');
    if(delBtn){
      delBtn.addEventListener('click', function(){
        const url = delBtn.getAttribute('data-url');
        fetch(url, { method: 'DELETE', headers: { 'X-Requested-With': 'XMLHttpRequest', 'X-CSRF-TOKEN': document.querySelector('meta[name=csrf-token]')?.getAttribute('content') || '' } })
          .then(r=>r.json())
          .then(res=>{ if(res.success){ root.innerHTML = res.html; bind(); if(window.showNotification){ try{ showNotification('Review deleted'); }catch(e){} } } });
      });
    }

    // pagination
    root.querySelectorAll('.js-review-pagination a').forEach(a=>{
      a.addEventListener('click', (e)=>{
        e.preventDefault();
        const url = new URL(a.href);
        const params = Object.fromEntries(url.searchParams.entries());
        loadReviews(params);
      });
    });

    // review form
    const form = root.querySelector('.js-review-form');
    if(form){
      form.addEventListener('submit', function(e){ e.preventDefault(); submitReview(form); });
      const stars = form.querySelectorAll('#ratingStars i');
      const input = form.querySelector('#ratingInput');
      stars.forEach((s, idx)=>{
        s.addEventListener('click', ()=>{
          const value = parseInt(s.getAttribute('data-value'));
          input.value = value;
          stars.forEach((x,i)=>{ if(i < value) x.classList.remove('grey'); else x.classList.add('grey'); });
        });
      });
    }
  }

  bind();
})();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/product/view.blade.php ENDPATH**/ ?>