
<?php $__env->startSection('title', 'Blogs'); ?>
<?php $__env->startSection('style'); ?>
<style>
.mn-blog-header {
    text-align: center;
    margin-bottom: 40px;
}
.mn-blog-header h1 {
    font-size: 2.5rem;
    color: #333;
    margin-bottom: 10px;
}
.mn-blog-header p {
    color: #666;
    font-size: 1.1rem;
}
.mn-blog-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 30px;
}
.mn-blog-card {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 2px 15px rgba(0,0,0,0.05);
    transition: transform 0.2s;
    height: 100%;
    display: flex;
    flex-direction: column;
}
.mn-blog-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
}
.mn-blog-image {
    position: relative;
    padding-top: 56.25%; /* 16:9 Aspect Ratio */
}
.mn-blog-image img {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.mn-blog-content {
    padding: 25px;
    flex-grow: 1;
    display: flex;
    flex-direction: column;
}
.mn-blog-meta {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 15px;
    color: #666;
    font-size: 0.9rem;
}
.mn-blog-date {
    display: flex;
    align-items: center;
    gap: 5px;
}
.mn-blog-stats {
    display: flex;
    gap: 15px;
}
.mn-blog-stat {
    display: flex;
    align-items: center;
    gap: 4px;
}
.mn-blog-stat .emoji {
    font-size: 1.1rem;
    line-height: 1;
}
.mn-blog-stat .count {
    font-size: 0.9rem;
    color: #666;
    min-width: 8px;
    text-align: center;
}
.mn-blog-stat.comments {
    color: #0ea5e9; /* blue */
}
.mn-blog-stat.likes {
    color: #22c55e; /* green */
}
.mn-blog-stat.dislikes {
    color: #ef4444; /* red */
}
.mn-blog-title {
    font-size: 1.4rem;
    margin-bottom: 12px;
    line-height: 1.4;
}
.mn-blog-title a {
    color: #333;
    text-decoration: none;
}
.mn-blog-title a:hover {
    color: var(--primary);
}
.mn-blog-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    margin-top: auto;
    padding-top: 15px;
}
.mn-blog-tag {
    padding: 5px 12px;
    background: #f8f9fa;
    border-radius: 20px;
    color: #666;
    font-size: 0.85rem;
    transition: all 0.2s;
}
.mn-blog-tag:hover {
    background: var(--primary);
    color: white;
}
.mn-blog-empty {
    text-align: center;
    padding: 50px 20px;
    background: white;
    border-radius: 15px;
    box-shadow: 0 2px 15px rgba(0,0,0,0.05);
    grid-column: 1 / -1;
}
.mn-blog-empty i {
    font-size: 3rem;
    color: #ddd;
    margin-bottom: 20px;
}
.mn-blog-empty h3 {
    color: #333;
    margin-bottom: 10px;
}
.mn-blog-empty p {
    color: #666;
}
.mn-blog-pagination {
    grid-column: 1 / -1;
    margin-top: 20px;
}
.mn-blog-reactions-summary {
    display: flex;
    align-items: center;
    gap: 8px;
}
.reactions-display {
    display: flex;
    align-items: center;
    gap: 4px;
    background: #f8f9fa;
    padding: 4px 8px;
    border-radius: 20px;
    border: 1px solid #e0e0e0;
    min-width: 45px;
    justify-content: center;
}
.reactions-display:hover {
    background: #f0f2f5;
}
.top-reactions {
    display: flex;
    align-items: center;
}
.top-reactions .emoji {
    font-size: 1rem;
    line-height: 1;
    margin-right: -2px;
}
.reactions-display .count {
    font-size: 0.85rem;
    color: #666;
    font-weight: 500;
    margin-left: 2px;
}
.reactions-display i {
    font-size: 1rem;
    color: #666;
    line-height: 1;
}
@media (max-width: 991px) {
    .mn-blog-grid {
        grid-template-columns: 1fr;
    }
    .mn-blog-header h1 {
        font-size: 2rem;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="mn-blog-header">
        <h1>Latest Stories</h1>
        <p>Discover our latest articles and updates</p>
    </div>

    <div class="mn-blog-grid">
        <?php if($blogs->isEmpty()): ?>
        <div class="mn-blog-empty">
            <i class="ri-newspaper-line"></i>
            <h3>No Stories Yet</h3>
            <p>Check back soon for new articles</p>
        </div>
        <?php else: ?>
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mn-blog-card">
                <div class="mn-blog-image">
                    <a href="<?php echo e(route('blog.show', $blog->slug)); ?>">
                        <img src="<?php echo e(asset('storage/' . $blog->thumbnail)); ?>" alt="<?php echo e($blog->title); ?>">
                    </a>
                </div>
                <div class="mn-blog-content">
                    <div class="mn-blog-meta">
                        <div class="mn-blog-date">
                            <i class="ri-calendar-line"></i>
                            <?php echo e($blog->created_at->format('M d, Y')); ?>

                        </div>
                        <div class="mn-blog-stats">
                            <div class="mn-blog-reactions-summary">
                                <?php
                                    $totalReactions = collect(App\Models\BlogReaction::REACTIONS)
                                        ->map(function($reaction, $type) use ($blog) {
                                            return $blog->reactions()->where('reaction_type', $type)->count();
                                        })->sum();
                                ?>
                                
                                <div class="reactions-display">
                                    <span class="emoji">👍</span>
                                    <span class="count"><?php echo e($totalReactions); ?></span>
                                </div>

                                <div class="reactions-display">
                                    <span class="emoji"><i class="ri-message-2-line"></i></span>
                                    <span class="count"><?php echo e($blog->comments->count()); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3 class="mn-blog-title">
                        <a href="<?php echo e(route('blog.show', $blog->slug)); ?>"><?php echo e($blog->title); ?></a>
                    </h3>
                    <?php if($blog->tags): ?>
                    <div class="mn-blog-tags">
                        <?php $__currentLoopData = array_slice($blog->tags, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="mn-blog-tag">#<?php echo e($tag); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(count($blog->tags) > 3): ?>
                            <span class="mn-blog-tag">+<?php echo e(count($blog->tags) - 3); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($blogs->hasPages()): ?>
            <div class="mn-blog-pagination">
                <div class="d-flex justify-content-center">
                    <?php echo e($blogs->links('partial.pagination')); ?>

                </div>
            </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('general_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/blog/list.blade.php ENDPATH**/ ?>