<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="product-card">
        <div class="product-image">
            <?php if($product->primary_image): ?>
                <img src="<?php echo e(asset('storage/' . $product->primary_image->path)); ?>" 
                     alt="<?php echo e($product->title); ?>">
            <?php else: ?>
                <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                    <i class="fas fa-image text-muted fa-2x"></i>
                </div>
            <?php endif; ?>
            <div class="product-badges">
                <?php $__currentLoopData = $product->variations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($variant->default): ?>
                        <?php if($variant->is_out_of_stock()): ?>
                            <span class="badge-item bg-danger">Out of Stock</span>
                        <?php elseif($variant->is_critical_stock()): ?>
                            <span class="badge-item" style="background-color: #dc3545">Critical Stock</span>
                        <?php elseif($variant->is_low_stock()): ?>
                            <span class="badge-item" style="background-color: #ffc107">Low Stock</span>
                        <?php endif; ?>
                        <?php break; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        
        <div class="product-content">
            <h3 class="product-title"><?php echo e($product->title); ?></h3>
            <div class="product-category"><?php echo e($product->category->full_path); ?></div>
            
            <?php if($product->tags && count($product->tags) > 0): ?>
                <div class="product-tags">
                    <?php $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($index < 3): ?>
                            <span class="tag"><?php echo e($tag); ?></span>
                        <?php elseif($index === 3): ?>
                            <span class="tag tag-more" 
                                  onclick="toggleTags(this)" 
                                  data-tags='<?php echo json_encode(array_slice($product->tags, 3), 512) ?>'>
                                +<?php echo e(count($product->tags) - 3); ?> more
                            </span>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
            
            <div class="variants-section">
                <?php $__currentLoopData = $product->variations->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="variant-item">
                        <div class="variant-info">
                            <div class="variant-name">
                                <?php echo e($variant->unit_type); ?>: <?php echo e($variant->unit_value); ?>

                                <?php if($variant->default): ?>
                                    <span class="badge bg-primary" style="font-size: 0.7rem;">Default</span>
                                <?php endif; ?>
                            </div>
                            <div class="variant-price">
                                <span class="sale-price">৳<?php echo e(number_format($variant->sale_price)); ?></span>
                                <?php if($variant->regular_price > $variant->sale_price): ?>
                                    <span class="regular-price">৳<?php echo e(number_format($variant->regular_price)); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div>
                            <?php if($variant->is_out_of_stock()): ?>
                                <span class="stock-badge out-of-stock">Out</span>
                            <?php elseif($variant->is_critical_stock()): ?>
                                <span class="stock-badge critical-stock"><?php echo e($variant->in_stock); ?></span>
                            <?php elseif($variant->is_low_stock()): ?>
                                <span class="stock-badge low-stock"><?php echo e($variant->in_stock); ?></span>
                            <?php else: ?>
                                <span class="stock-badge in-stock"><?php echo e($variant->in_stock); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($product->variations->count() > 3): ?>
                    <div class="variant-more">
                        +<?php echo e($product->variations->count() - 3); ?> more variants
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card-actions">
            <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" 
               class="btn btn-sm btn-outline-primary">
                <i class="fas fa-edit"></i> Edit
            </a>
            <button type="button" 
                    class="btn btn-sm btn-outline-danger"
                    onclick="deleteProduct(<?php echo e($product->id); ?>)">
                <i class="fas fa-trash"></i> Delete
            </button>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php /**PATH /home/techmind/public_html/resources/views/admin/products/_product_cards.blade.php ENDPATH**/ ?>