<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice #<?php echo e($order->order_number); ?></title>
    <style>
        @media print {
            @page {
                margin: 0;
                size: A4;
            }
            body {
                margin: 1.6cm;
            }
        }
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 40px;
        }
        .invoice-title {
            margin: 0;
            font-size: 28px;
            font-weight: bold;
        }
        .order-number {
            color: #333333;
            margin-top: 5px;
            font-size: 17px;
            font-weight: 600;
        }
        .logo img {
            max-height: 50px;
        }
        .info-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        .shipping-info {
            flex: 7;
        }
        .order-info {
            flex: 3;
            text-align: right;
        }
        .order-info .info-row {
            white-space: nowrap;
        }
        .section-title {
            font-size: 16px;
            color: #333;
            margin-bottom: 10px;
            font-weight: 600;
        }
        .info-row {
            margin: 3px 0;
            display: flex;
            align-items: flex-start;
        }
        .info-label {
            color: #666;
            flex: 0 0 80px;
            margin-right: 5px;
        }
        .info-value {
            flex: 1;
        }
        .order-info .info-row {
            display: block;
            text-align: right;
        }
        .order-info .info-label {
            display: inline;
            flex: none;
            margin-right: 5px;
        }
        .order-info .info-value {
            display: inline;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            font-size: 13px;
            margin-bottom: 20px;
        }
        .items-table th,
        .items-table td {
            border: 1px solid #ddd;
            padding: 6px 8px;
        }
        .items-table th {
            background: #f8f9fa;
            font-weight: 600;
            white-space: nowrap;
        }
        .items-table .item-name {
            width: 40%;
            text-align: left;
        }
        .items-table .quantity {
            width: 15%;
        }
        .items-table .price {
            width: 20%;
            text-align: center;
        }
        .items-table .total {
            width: 25%;
            text-align: right;
        }
        .variant {
            font-size: 11px;
            color: #666;
            margin-top: 2px;
        }
        .summary-table {
            width: 300px;
            margin-left: auto;
            border-collapse: collapse;
        }
        .summary-table td {
            padding: 5px 0;
        }
        .summary-table .amount {
            text-align: right;
        }
        .total-row {
            font-weight: bold;
            border-top: 1px solid #ddd;
            padding-top: 5px;
        }
        .footer {
            margin-top: 10px;
            padding-top: 5px;
            border-top: 1px solid #eee;
            display: flex;
            justify-content: space-between;
            font-size: 13px;
        }
        .footer .thank-you {
            color: #555;
        }

        /* Add new styles for payment info */
        .payment-info {
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .payment-info .section-title {
            margin-bottom: 15px;
            padding-bottom: 8px;
            border-bottom: 1px solid #ddd;
        }
        .payment-status {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 3px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            margin-left: 5px;
        }
        .payment-status.pending {
            background: #fff3cd;
            color: #856404;
        }
        .payment-status.verified {
            background: #d4edda;
            color: #155724;
        }
        .payment-status.rejected {
            background: #f8d7da;
            color: #721c24;
        }
        .payment-details {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            margin-top: 10px;
        }
        .payment-row {
            display: flex;
            align-items: center;
        }
        .payment-label {
            color: #666;
            font-size: 13px;
            margin-right: 10px;
            min-width: 100px;
        }
        .payment-value {
            font-size: 13px;
            color: #333;
            font-weight: 500;
        }
        .payment-note {
            font-size: 12px;
            color: #666;
            text-align: right;
            margin-top: 2px;
            font-style: italic;
            display: block;
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        .cod-text {
            font-weight: 600;
            color: #333;
            text-align: right;
            display: block;
        }
    </style>
    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div>
                <h2 class="invoice-title">INVOICE</h2>
                <div class="order-number">#<?php echo e($order->order_number); ?></div>
            </div>
            <div class="logo">
                <img src="<?php echo e(Storage::url($appSettings->admin_logo_path)); ?>" alt="Company Logo">
            </div>
        </div>

        <!-- Info Section -->
        <div class="info-section">
            <div class="shipping-info">
                <div class="section-title">Customer Information:</div>
                <?php if($order->contact_name): ?>
                <div class="info-row">
                    <span class="info-label">Name:</span>
                    <span class="info-value"><?php echo e($order->contact_name); ?></span>
                </div>
                <?php endif; ?>
                <?php if($order->contact_phone): ?>
                <div class="info-row">
                    <span class="info-label">Phone:</span>
                    <span class="info-value"><?php echo e($order->contact_phone); ?></span>
                </div>
                <?php endif; ?>
                <?php if($order->whatsapp): ?>
                <div class="info-row">
                    <span class="info-label">WhatsApp:</span>
                    <span class="info-value"><?php echo e($order->whatsapp); ?></span>
                </div>
                <?php endif; ?>
                <?php if($order->contact_email): ?>
                <div class="info-row">
                    <span class="info-label">Email:</span>
                    <span class="info-value"><?php echo e($order->contact_email); ?></span>
                </div>
                <?php endif; ?>
                <?php if($order->address): ?>
                <div class="info-row">
                    <span class="info-label">Address:</span>
                    <span class="info-value"><?php echo e($order->address); ?>, <?php echo e($order->city); ?>, <?php echo e($order->state); ?> <?php echo e($order->postal_code); ?></span>
                </div>
                <?php endif; ?>
            </div>
            <div class="order-info">
                <div class="section-title">Order Details:</div>
                <div class="info-row">
                    <span class="info-label">Date:</span>
                    <span class="info-value"><?php echo e($order->created_at->format('d M, Y h:i A')); ?></span>
                </div>
                <?php if($order->payment_method === 'cod'): ?>
                <div class="info-row">
                    <span class="info-value">
                        <span class="cod-text">Cash on Delivery</span>
                        <div class="payment-note">(Payment due upon delivery)</div>
                    </span>
                </div>
                <?php else: ?>
                <div class="info-row">
                    <span class="info-label">Pay with:</span>
                    <span class="info-value"><?php echo e($order->payment_method === 'cod' ? 'Cash on Delivery' : 'SSLCommerz'); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th class="item-name">Item</th>
                    <th class="quantity">Quantity</th>
                    <th class="price">Unit Price</th>
                    <th class="total">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <?php echo e($item->product->title); ?>

                        <div class="variant"><?php echo e($item->variation->unit_value); ?><?php echo e($item->variation->unit_type); ?></div>
                    </td>
                    <td class="quantity"><?php echo e($item->quantity); ?></td>
                    <td class="price">৳<?php echo e(number_format($item->variation->sale_price)); ?></td>
                    <td class="total">৳<?php echo e(number_format($item->variation->sale_price * $item->quantity)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Summary -->
        <table class="summary-table">
            <tr>
                <td>Subtotal:</td>
                <td class="amount">৳<?php echo e(number_format($order->subtotal)); ?></td>
            </tr>
            <?php if($order->discount > 0 && $order->coupon_code): ?>
            <tr>
                <td>Discount (<?php echo e($order->coupon_code); ?>):</td>
                <td class="amount">-৳<?php echo e(number_format($order->discount)); ?></td>
            </tr>
            <?php endif; ?>
            <tr>
                <td>Delivery Charge:</td>
                <td class="amount">৳<?php echo e(number_format($order->delivery_charge)); ?></td>
            </tr>
            <tr class="total-row">
                <td>Total:</td>
                <td class="amount">৳<?php echo e(number_format($order->total)); ?></td>
            </tr>
        </table>

        <!-- Footer -->
        <div class="footer">
            <div class="thank-you">Thank you for shopping with <?php echo e(config('app.name')); ?>. We look forward to serving you again.</div>
        </div>
    </div>
</body>
</html> <?php /**PATH /home/techmind/public_html/resources/views/admin/orders/invoice.blade.php ENDPATH**/ ?>