<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;

Route::middleware(['auth', 'verified', 'active'])->group(function () {
    // Security Routes
    Route::get('/security', [UserController::class, 'security'])->name('security');
    Route::put('/security/password', [UserController::class, 'updatePassword'])->name('security.password');
    Route::post('/security/2fa/enable', [UserController::class, 'enable2FA'])->name('security.2fa.enable');
    Route::post('/security/2fa/confirm', [UserController::class, 'confirm2FA'])->name('security.2fa.confirm');
    Route::delete('/security/2fa/cancel', [UserController::class, 'cancel2FA'])->name('security.2fa.cancel');
    Route::post('/security/2fa/disable', [UserController::class, 'disable2FA'])->name('security.2fa.disable');
    Route::post('/security/2fa/regenerate-codes', [UserController::class, 'regenerateRecoveryCodes'])->name('security.2fa.regenerate-codes');
    Route::get('/security/2fa/verify', [UserController::class, 'show2FAVerify'])->name('security.2fa.verify');
    Route::post('/security/2fa/verify', [UserController::class, 'verify2FA'])->name('security.2fa.verify.post');
    Route::delete('/security/account', [UserController::class, 'deleteAccount'])->name('security.account.delete');

    // Routes protected by 2FA when enabled
    Route::middleware(['2fa'])->group(function () {
    // Account Routes
    Route::get('/account', [UserController::class, 'account'])->name('account');
    Route::put('/account/update', [UserController::class, 'updateProfile'])->name('profile.update');
    
    // Shipping Routes
    Route::get('/shipping', [UserController::class, 'shipping'])->name('shipping');
    Route::put('/shipping', [UserController::class, 'updateShipping'])->name('shipping.update');
    
    // Wishlist Routes
    Route::get('/wishlist', [UserController::class, 'wishlist'])->name('wishlist');
    Route::delete('/wishlist/{product}', [UserController::class, 'removeFromWishlist'])->name('wishlist.remove');
    
    // Orders Routes
    Route::get('/orders', [UserController::class, 'orders'])->name('user.orders');
    });
});