<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Generals;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\ProductsController;
use App\Http\Controllers\Admin\CategoriesController;
use App\Http\Controllers\Admin\CouponsController;
use App\Http\Controllers\Admin\BlogsController;
use App\Http\Controllers\Admin\PagesController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\OrdersController;
use App\Http\Controllers\Admin\BestDealsController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\CustomizeController;
use App\Http\Controllers\Admin\PaymentController;
use App\Http\Controllers\Admin\ProductAnalyticsController;
use App\Http\Controllers\Admin\BrandsController;

Route::middleware('auth', 'verified', 'active', 'admin')->prefix('admin')->group(function () {
    // General Routes
    Route::get('/dashboard', [Generals::class, 'dashboard'])->name('admin.dashboard');
    
    // User Management Routes
    Route::get('/users', [UsersController::class, 'index'])->name('admin.users');
    Route::get('/users/create', [UsersController::class, 'create'])->name('admin.users.create');
    Route::post('/users', [UsersController::class, 'store'])->name('admin.users.store');
    Route::get('/users/{user}/edit', [UsersController::class, 'edit'])->name('admin.users.edit');
    Route::put('/users/{user}', [UsersController::class, 'update'])->name('admin.users.update');
    Route::delete('/users/{user}', [UsersController::class, 'destroy'])->name('admin.users.destroy');

    // Product Management Routes
    Route::get('/products', [ProductsController::class, 'index'])->name('admin.products');
    Route::get('/products/create', [ProductsController::class, 'create'])->name('admin.products.create');
    Route::post('/products', [ProductsController::class, 'store'])->name('admin.products.store');
    Route::get('/products/{product}/edit', [ProductsController::class, 'edit'])->name('admin.products.edit');
    Route::put('/products/{product}', [ProductsController::class, 'update'])->name('admin.products.update');
    Route::delete('/products/{product}', [ProductsController::class, 'destroy'])->name('admin.products.destroy');

    // Product Reviews (Admin)
    Route::get('/products/reviews', [ProductsController::class, 'reviews'])->name('admin.products.reviews');
    Route::delete('/products/reviews/{rating}', [ProductsController::class, 'destroyReview'])->name('admin.products.reviews.delete');

    // Category Routes
    Route::get('/categories', [CategoriesController::class, 'index'])->name('admin.categories');
    Route::post('/categories', [CategoriesController::class, 'store'])->name('admin.categories.store');
    Route::put('/categories/{category}', [CategoriesController::class, 'update'])->name('admin.categories.update');
    Route::delete('/categories/{category}', [CategoriesController::class, 'destroy'])->name('admin.categories.destroy');

    // Coupon Routes
    Route::get('/coupons', [CouponsController::class, 'index'])->name('admin.coupons');
    Route::post('/coupons', [CouponsController::class, 'store'])->name('admin.coupons.store');
    Route::put('/coupons/{coupon}', [CouponsController::class, 'update'])->name('admin.coupons.update');
    Route::delete('/coupons/{coupon}', [CouponsController::class, 'destroy'])->name('admin.coupons.destroy');

    // Blog Management Routes
    Route::get('/blogs', [BlogsController::class, 'index'])->name('admin.blogs');
    Route::get('/blogs/create', [BlogsController::class, 'create'])->name('admin.blogs.create');
    Route::post('/blogs', [BlogsController::class, 'store'])->name('admin.blogs.store');
    Route::get('/blogs/{blog}/edit', [BlogsController::class, 'edit'])->name('admin.blogs.edit');
    Route::put('/blogs/{blog}', [BlogsController::class, 'update'])->name('admin.blogs.update');
    Route::delete('/blogs/{blog}', [BlogsController::class, 'destroy'])->name('admin.blogs.destroy');
        
    // Comments management
    Route::get('/blogs/comments', [BlogsController::class, 'comments'])->name('admin.blogs.comments');
    Route::delete('/blogs/comments/{comment}', [BlogsController::class, 'deleteComment'])->name('admin.blogs.comments.delete');

    // Pages Routes
    Route::get('/pages', [PagesController::class, 'index'])->name('admin.pages');
    Route::get('/pages/create', [PagesController::class, 'create'])->name('admin.pages.create');
    Route::post('/pages/store', [PagesController::class, 'store'])->name('admin.pages.store');
    Route::get('/pages/{page}/edit', [PagesController::class, 'edit'])->name('admin.pages.edit');
    Route::put('/pages/{page}/update', [PagesController::class, 'update'])->name('admin.pages.update');
    Route::delete('/pages/{page}/delete', [PagesController::class, 'destroy'])->name('admin.pages.delete');

    // FAQ Routes
    Route::get('/faqs', [FaqController::class, 'index'])->name('admin.faqs');
    Route::post('/faqs/store', [FaqController::class, 'store'])->name('admin.faqs.store');
    Route::put('/faqs/{faq}/update', [FaqController::class, 'update'])->name('admin.faqs.update');
    Route::delete('/faqs/{faq}/delete', [FaqController::class, 'destroy'])->name('admin.faqs.delete');

    // Wholesaler feature removed

    // Order Routes
    Route::get('/orders', [OrdersController::class, 'index'])->name('admin.orders');
    Route::get('/orders/export', [OrdersController::class, 'export'])->name('admin.orders.export');
    Route::get('/orders/{order}', [OrdersController::class, 'show'])->name('admin.orders.show');
    Route::get('/orders/{order}/invoice', [OrdersController::class, 'generateInvoice'])->name('admin.orders.invoice');
    Route::put('/orders/{order}/status', [OrdersController::class, 'updateStatus'])->name('admin.orders.status');
    // Legacy manual payment status routes removed

    // Best Deals Routes
    Route::get('/deals', [BestDealsController::class, 'index'])->name('admin.deals');
    Route::get('/deals/create', [BestDealsController::class, 'create'])->name('admin.deals.create');
    Route::post('/deals', [BestDealsController::class, 'store'])->name('admin.deals.store');
    Route::get('/deals/{deal}/edit', [BestDealsController::class, 'edit'])->name('admin.deals.edit');
    Route::put('/deals/{deal}', [BestDealsController::class, 'update'])->name('admin.deals.update');
    Route::delete('/deals/{deal}', [BestDealsController::class, 'destroy'])->name('admin.deals.destroy');

    // Settings Routes
    Route::get('/settings', [SettingsController::class, 'index'])->name('admin.settings');
    Route::post('/settings', [SettingsController::class, 'update'])->name('admin.settings.update');

    // Customize Routes
    Route::get('/customize/home', [CustomizeController::class, 'home'])->name('admin.customize.home');
    Route::post('/customize/home', [CustomizeController::class, 'homeUpdate'])->name('admin.customize.home.update');
    

    // Customize Contact Page
    Route::get('/customize/contact', [CustomizeController::class, 'contact'])->name('admin.customize.contact');
    Route::put('/customize/contact', [CustomizeController::class, 'contactUpdate'])->name('admin.customize.contact.update');

    // Payment Routes - show history from orders (SSLCommerz)
    Route::get('/payments', [PaymentController::class, 'index'])->name('admin.payments');

    // Product Analytics
    Route::get('/products/{product}/analytics', [ProductAnalyticsController::class, 'show'])->name('admin.products.analytics');
    Route::delete('/products/reviews/{id}', [ProductAnalyticsController::class, 'deleteReview'])->name('admin.products.analytics.reviews.delete');

    // Brands
    Route::get('/brands', [BrandsController::class, 'index'])->name('admin.brands');
    Route::post('/brands', [BrandsController::class, 'store'])->name('admin.brands.store');
    Route::put('/brands/{brand}', [BrandsController::class, 'update'])->name('admin.brands.update');
    Route::delete('/brands/{brand}', [BrandsController::class, 'destroy'])->name('admin.brands.destroy');
});