<!DOCTYPE html>
<html>
<head>
    <title>Order Status Update - {{ $order->order_number }}</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0;">
    <div style="max-width: 800px; margin: 0 auto; padding: 20px;">
        <h2>Order Status Update</h2>
        
        <div style="background-color: #f9f9f9; padding: 20px; border-radius: 4px; margin: 20px 0;">
            <p>Dear {{ $order->contact_name }},</p>
            
            <p>Your order status has been updated to: <strong>{{ ucfirst($newStatus) }}</strong></p>
            
            <div style="background-color: white; padding: 15px; border-radius: 4px; margin: 15px 0;">
                <p style="margin: 0;"><strong>Order ID:</strong> {{ $order->order_number }}</p>
                <p style="margin: 5px 0;"><strong>Order Date:</strong> {{ $order->created_at->format('M d, Y') }}</p>
                <p style="margin: 5px 0;"><strong>Total Amount:</strong> ৳{{ number_format($order->total) }}</p>
            </div>

            <div style="margin-top: 20px;">
                <p>Track your order or view the invoice:</p>
                <p>
                    <a href="{{ url(route('product.order.track', ['order_id' => $order->order_number, 'email' => $order->contact_email])) }}" style="display: inline-block; padding: 10px 20px; background-color: #4CAF50; color: white; text-decoration: none; border-radius: 4px; margin-right: 10px;">Track Order</a>
                    <a href="{{ url(route('product.order.invoice', $order->order_number)) }}" style="display: inline-block; padding: 10px 20px; background-color: #2196F3; color: white; text-decoration: none; border-radius: 4px;">View Invoice</a>
                </p>
            </div>
        </div>
        
        <p style="color: #666; font-size: 14px;">Thank you for shopping with {{ config('app.name') }}</p>
    </div>
</body>
</html> 