@extends('admin_base')

@section('title', 'Products')

@section('style')
<style>
.search-section {
    background: white;
    padding: 20px;
    border-radius: 10px;
    margin-bottom: 25px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
}

.search-box {
    position: relative;
    margin-bottom: 20px;
}

.search-box input {
    width: 100%;
    padding: 12px 20px 12px 45px;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    font-size: 1rem;
    transition: all 0.3s;
}

.search-box input:focus {
    border-color: #159abe;
    box-shadow: 0 0 0 0.2rem rgba(58, 78, 229, 0.25);
}

.search-box i {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: #6c757d;
    font-size: 1.1rem;
}

.filter-tags {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.filter-tag {
    padding: 8px 16px;
    border-radius: 20px;
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    color: #495057;
    cursor: pointer;
    transition: all 0.2s;
    font-size: 0.9rem;
}

.filter-tag:hover, .filter-tag.active {
    background: #159abe;
    border-color: #159abe;
    color: white;
}

.products-table {
    background: white;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
}

.table {
    margin-bottom: 0;
}

.table th {
    background: #f8f9fa;
    font-weight: 600;
    padding: 15px;
    border-bottom: 2px solid #dee2e6;
}

.table td {
    padding: 15px;
    vertical-align: middle;
}

.product-cell {
    display: flex;
    align-items: center;
    gap: 15px;
}

.product-image {
    width: 60px;
    height: 60px;
    border-radius: 8px;
    object-fit: cover;
}

.product-info {
    flex: 1;
}

.product-title {
    font-weight: 500;
    color: #333;
    margin-bottom: 4px;
}

.product-category {
    color: #6c757d;
    font-size: 0.75rem;
}

.tags-cell {
    max-width: 200px;
}

.tag {
    display: inline-block;
    padding: 2px 8px;
    margin: 2px;
    border-radius: 12px;
    background: #f8f9fa;
    color: #6c757d;
    font-size: 0.75rem;
}

/* Rating styles */
.rating-cell {
    white-space: nowrap;
}

.rating-stars {
    color: #ffc107;
    font-size: 0.9rem;
}

.rating-count {
    color: #6c757d;
    font-size: 0.8rem;
    margin-left: 5px;
}

.empty-rating {
    color: #dee2e6;
    font-style: italic;
    font-size: 0.8rem;
}

.filter-tag {
    padding: 8px 16px;
    border-radius: 20px;
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    color: #495057;
    cursor: pointer;
    transition: all 0.2s;
    font-size: 0.9rem;
}

.filter-tag:hover, .filter-tag.active {
    background: #159abe;
    border-color: #159abe;
    color: white;
}

.products-table {
    background: white;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
}

.table {
    margin-bottom: 0;
}

.table th {
    background: #f8f9fa;
    font-weight: 600;
    padding: 15px;
    border-bottom: 2px solid #dee2e6;
}

.table td {
    padding: 15px;
    vertical-align: middle;
}

.product-cell {
    display: flex;
    align-items: center;
    gap: 15px;
}

.product-image {
    width: 60px;
    height: 60px;
    border-radius: 8px;
    object-fit: cover;
}

.product-info {
    flex: 1;
}

.product-title {
    font-weight: 500;
    color: #333;
    margin-bottom: 4px;
}

.product-category {
    color: #6c757d;
    font-size: 0.75rem;
}

.tags-cell {
    max-width: 200px;
}

.tag {
    display: inline-block;
    padding: 2px 8px;
    margin: 2px;
    border-radius: 12px;
    background: #f8f9fa;
    color: #6c757d;
    font-size: 0.75rem;
}

/* Rating styles */
.rating-cell {
    white-space: nowrap;
}

.rating-stars {
    color: #ffc107;
    font-size: 0.9rem;
}

.rating-count {
    color: #6c757d;
    font-size: 0.8rem;
    margin-left: 5px;
}

.empty-rating {
    color: #dee2e6;
    font-style: italic;
    font-size: 0.8rem;
}

.variants-cell {
    min-width: 200px;
}

.variant-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 4px 0;
}

.variant-item:not(:last-child) {
    border-bottom: 1px dashed #dee2e6;
}

.variant-info {
    font-size: 0.9rem;
}

.variant-name {
    color: #495057;
}

.variant-price {
    display: flex;
    gap: 8px;
    align-items: center;
}

.sale-price {
    color: #dc3545;
    font-weight: 600;
}

.regular-price {
    text-decoration: line-through;
    color: #6c757d;
    font-size: 0.85rem;
}

.stock-badge {
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
    white-space: nowrap;
}

.stock-badge.in-stock {
    background-color: #d1e7dd;
    color: #0f5132;
}

.stock-badge.low-stock {
    background-color: #fff3cd;
    color: #664d03;
}

.stock-badge.critical-stock {
    background-color: #f8d7da;
    color: #842029;
}

.stock-badge.out-of-stock {
    background-color: #dc3545;
    color: white;
}

.stock-number {
    display: inline-block;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.85rem;
    font-weight: 500;
    white-space: nowrap;
}

.actions-cell {
    white-space: nowrap;
    text-align: right;
}

.actions-cell .btn {
    padding: 6px 12px;
    margin-left: 5px;
}

tr.hiding {
    opacity: 0;
    transform: translateX(-10px);
}

tr.showing {
    opacity: 1;
    transform: translateX(0);
    transition: all 0.3s ease;
}

/* Pagination Styles */
.pagination {
    margin: 0;
}

.page-link {
    padding: 0.5rem 0.75rem;
    color: #159abe;
    background-color: #fff;
    border: 1px solid #dee2e6;
    font-size: 0.9rem;
}

.page-item.active .page-link {
    background-color: #159abe;
    border-color: #159abe;
}

.page-item.disabled .page-link {
    color: #6c757d;
    pointer-events: none;
    background-color: #fff;
    border-color: #dee2e6;
}

.page-link:hover {
    color: #2b3ab8;
    text-decoration: none;
    background-color: #e9ecef;
    border-color: #dee2e6;
}

.page-link:focus {
    z-index: 3;
    outline: 0;
    box-shadow: 0 0 0 0.2rem rgba(58, 78, 229, 0.25);
}
</style>
@endsection

@section('content')
<div class="search-section">
    <div class="search-box">
        <i class="fas fa-search"></i>
        <input type="text" id="productSearch" placeholder="Search products by name, category, or tags...">
    </div>
    <div class="filter-tags">
        <div class="filter-tag active" data-filter="all">All Products</div>
        <div class="filter-tag" data-filter="low-stock">Low Stock</div>
        <div class="filter-tag" data-filter="critical-stock">Critical Stock</div>
        <div class="filter-tag" data-filter="out-of-stock">Out of Stock</div>
    </div>
        </div>

@if($products->isEmpty())
    <div class="empty-state">
        <i class="fas fa-box-open"></i>
        <h3>No Products Found</h3>
        <p>Start by adding your first product to the inventory</p>
        <a href="{{ route('admin.products.create') }}" class="sb_btn">
            <i class="fas fa-plus"></i> Add First Product
        </a>
    </div>
@else
    <div class="products-table">
        <table class="table">
                <thead>
                    <tr>
                        <th>Product</th>
                        <th>Tags</th>
                        <th>Rating</th>
                        <th>Variants</th>
                        <th style="width: 100px">Actions</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($products as $product)
                    @php
                        $defaultVariant = $product->variations->where('default', true)->first();
                        $hasOutOfStock = $product->variations->contains(function($variant) {
                            return $variant->is_out_of_stock();
                        });
                        $hasCriticalStock = !$hasOutOfStock && $product->variations->contains(function($variant) {
                            return $variant->is_critical_stock();
                        });
                        $hasLowStock = !$hasOutOfStock && !$hasCriticalStock && $product->variations->contains(function($variant) {
                            return $variant->is_low_stock();
                        });
                    @endphp
                    <tr class="product-row showing">
                            <td>
                            <div class="product-cell">
                                @if($product->primary_image)
                                    <img src="{{ asset('storage/' . $product->primary_image->path) }}" 
                                         alt="{{ $product->title }}" 
                                         class="product-image">
                                @else
                                    <div class="product-image bg-light d-flex align-items-center justify-content-center">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                @endif
                                <div class="product-info">
                                    <div class="product-title">
                                        {{ $product->title }}
                                        @if($hasOutOfStock)
                                            <span class="stock-badge out-of-stock" style="font-size: 0.7rem; margin-left: 8px;">Out of Stock</span>
                                        @elseif($hasCriticalStock)
                                            <span class="stock-badge critical-stock" style="font-size: 0.7rem; margin-left: 8px;">Critical Stock</span>
                                        @elseif($hasLowStock)
                                            <span class="stock-badge low-stock" style="font-size: 0.7rem; margin-left: 8px;">Low Stock</span>
                                        @endif
                                    </div>
                                    <div class="product-category">
                                        {{ $product->category->parent ? $product->category->parent->name . ' > ' . $product->category->name : $product->category->name }}
                                    </div>
                                </div>
                            </div>
                            </td>
                        <td class="tags-cell">
                                @if($product->tags)
                                @foreach($product->tags as $tag)
                                            <span class="tag">{{ $tag }}</span>
                                        @endforeach
                                @endif
                            </td>
                        <td class="rating-cell">
                            @if($product->ratings_count > 0)
                                <div class="rating-stars">
                                    @for($i = 1; $i <= 5; $i++)
                                        @if($i <= round($product->average_rating))
                                            <i class="fas fa-star"></i>
                                        @else
                                            <i class="far fa-star"></i>
                                        @endif
                                    @endfor
                                    <span class="rating-count">({{ $product->ratings_count }})</span>
                                </div>
                            @else
                                <span class="empty-rating">No ratings yet</span>
                                @endif
                            </td>
                        <td class="variants-cell">
                            @if($defaultVariant)
                                <div class="variant-item">
                                        <div class="variant-info">
                                        <div class="variant-name">
                                            {{ $defaultVariant->unit_type }}: {{ $defaultVariant->unit_value }}
                                        </div>
                                        <div class="variant-price">
                                            <span class="sale-price">৳{{ number_format($defaultVariant->sale_price) }}</span>
                                            @if($defaultVariant->regular_price > $defaultVariant->sale_price)
                                                <span class="regular-price">৳{{ number_format($defaultVariant->regular_price) }}</span>
                                            @endif
                                            @php
                                                $additionalVariants = $product->variations->where('default', false)->count();
                                            @endphp
                                            @if($additionalVariants > 0)
                                                <span class="badge bg-secondary" style="font-size: 0.7rem;">
                                                    +{{ $additionalVariants }}
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                        @endif
                            </td>
                        <td class="actions-cell">
                            <a href="{{ route('admin.products.analytics', $product->id) }}" 
                               class="btn btn-sm btn-outline-info" 
                               title="View Analytics">
                                <i class="fas fa-chart-line"></i>
                            </a>
                                    <a href="{{ route('admin.products.edit', $product->id) }}" 
                                       class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" 
                                            class="btn btn-sm btn-outline-danger"
                                            onclick="deleteProduct({{ $product->id }})">
                                        <i class="fas fa-trash"></i>
                                    </button>
                            </td>
                        </tr>
                @endforeach
                </tbody>
            </table>
        </div>

    @if($products->hasPages())
        <div class="d-flex justify-content-end mt-3 mb-4">
            {{ $products->links('pagination::bootstrap-4') }}
        </div>
    @else
        <div class="mb-4"></div>
    @endif
@endif
@endsection

@section('script')
<script>
// Check for flash message in sessionStorage
document.addEventListener('DOMContentLoaded', function() {
    const flashMessage = sessionStorage.getItem('flash_message');
    const flashType = sessionStorage.getItem('flash_type');
    
    if (flashMessage) {
        // Show toast notification
        const toast = document.createElement('div');
        toast.className = `toast toast-${flashType}`;
        toast.innerHTML = `
            <div class="toast-header">
                <i class="fas ${flashType === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-2"></i>
                <strong class="mr-auto">${flashType === 'success' ? 'Success' : 'Error'}</strong>
                <button type="button" class="ml-2 mb-1 close" onclick="this.closest('.toast').remove()">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="toast-body">
                ${flashMessage}
            </div>
        `;
        
        document.querySelector('.toast-container').appendChild(toast);
        
        // Remove the message from sessionStorage
        sessionStorage.removeItem('flash_message');
        sessionStorage.removeItem('flash_type');
        
        // Auto hide after 3 seconds
        setTimeout(() => {
            toast.remove();
        }, 3000);
    }
});

// Filter functionality
document.querySelectorAll('.filter-tag').forEach(tag => {
    tag.addEventListener('click', function() {
        document.querySelectorAll('.filter-tag').forEach(t => t.classList.remove('active'));
        this.classList.add('active');
        filterProducts(this.dataset.filter);
    });
});

// Search functionality with debounce
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

function filterProducts(filter) {
    const rows = document.querySelectorAll('.product-row');
    
    document.querySelectorAll('.filter-tag').forEach(btn => {
        btn.classList.remove('active');
        if (btn.dataset.filter === filter) {
            btn.classList.add('active');
        }
    });
    
    rows.forEach(row => {
        const badges = row.querySelectorAll('.stock-badge');
        let shouldShow = filter === 'all';
        
        badges.forEach(badge => {
            if (filter === 'out-of-stock' && badge.classList.contains('out-of-stock')) shouldShow = true;
            if (filter === 'low-stock' && badge.classList.contains('low-stock')) shouldShow = true;
            if (filter === 'critical-stock' && badge.classList.contains('critical-stock')) shouldShow = true;
        });
        
        if (shouldShow) {
            row.style.display = '';
            setTimeout(() => {
                row.classList.remove('hiding');
                row.classList.add('showing');
            }, 50);
        } else {
            row.classList.add('hiding');
            row.classList.remove('showing');
            setTimeout(() => {
                row.style.display = 'none';
            }, 300);
        }
    });
}

const searchProducts = debounce(function(value) {
    const rows = document.querySelectorAll('.product-row');
    const searchText = value.toLowerCase();

    rows.forEach(row => {
        const title = row.querySelector('.product-title').textContent.toLowerCase();
        const category = row.querySelector('.product-category').textContent.toLowerCase();
        const tags = Array.from(row.querySelectorAll('.tag')).map(tag => tag.textContent.toLowerCase());
        
        if (title.includes(searchText) || 
            category.includes(searchText) || 
            tags.some(tag => tag.includes(searchText))) {
            row.style.display = '';
            setTimeout(() => {
                row.classList.remove('hiding');
                row.classList.add('showing');
            }, 50);
        } else {
            row.classList.add('hiding');
            row.classList.remove('showing');
            setTimeout(() => {
                row.style.display = 'none';
            }, 300);
        }
    });
}, 300);

document.getElementById('productSearch').addEventListener('input', function(e) {
    searchProducts(e.target.value);
});

function deleteProduct(id) {
    if (confirm('Are you sure you want to delete this product?')) {
        fetch(`/admin/products/${id}`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                window.location.reload();
            } else {
                alert(data.message || 'Error deleting product');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error deleting product');
        });
    }
}

function toggleTags(element) {
    const tags = JSON.parse(element.dataset.tags);
    const tagsContainer = element.closest('.product-tags');
    
    if (!element.classList.contains('expanded')) {
        // Show more tags
        tags.forEach(tag => {
            const tagElement = document.createElement('span');
            tagElement.className = 'tag extra-tag fade-in';
            tagElement.textContent = tag;
            tagsContainer.insertBefore(tagElement, element);
        });
        element.style.display = 'none';
    }
}
</script>
@endsection 