@extends('admin_base')

@section('title', 'Pages')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Pages</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="pagesTable" class="table table-bordered table-striped">
                        <thead class="bg_sb_primary">
                            <tr>
                                <th width="5%">SL</th>
                                <th>Name</th>
                                <th width="15%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($pages as $key => $page)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $page->name }}</td>
                                <td>
                                    <a href="{{ route('admin.pages.edit', $page->id) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger" onclick="deletePage({{ $page->id }})">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                    <form id="delete-form-{{ $page->id }}" action="{{ route('admin.pages.delete', $page->id) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
$(document).ready(function() {
    $('#pagesTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "order": [[0, 'asc']]
    });
});

function deletePage(id) {
    if(confirm('Are you sure you want to delete this page?')) {
        document.getElementById('delete-form-' + id).submit();
    }
}
</script>
@endsection 