@extends('admin_base')
@section('title', 'Brands')
@section('style')
<style>
.brand-logo{width:auto;max-width:80px;height:30px;object-fit:contain;border-radius:6px;background:#fff}
.table-actions{display:flex;gap:8px;justify-content:center}
.add-btn{margin-bottom:20px}
</style>
@endsection
@section('content')
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Brands</h3>
  </div>
  <div class="card-body">
    <button class="sb_btn add-btn" onclick="showAddBrand()">
      <i class="fas fa-plus"></i> Add Brand
    </button>
    <div class="table-responsive">
      <table class="table table-bordered" id="brandsTable">
        <thead class="bg_sb_primary">
          <tr>
            <th class="text-center" style="width:60px">#</th>
            <th class="text-center" style="width:100px">Logo</th>
            <th>Title</th>
            <th class="text-center" style="width:140px">Products</th>
            <th class="text-center" style="width:160px">Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($brands as $brand)
          <tr>
            <td class="text-center"></td>
            <td class="text-center">
              @if($brand->logo)
                <img src="{{ asset('storage/'.$brand->logo) }}" class="brand-logo" alt="{{ $brand->title }}">
              @else
                <div class="brand-logo d-inline-flex align-items-center justify-content-center">
                  <i class="fas fa-image text-muted"></i>
                </div>
              @endif
            </td>
            <td>{{ $brand->title }}</td>
            <td class="text-center">{{ $brand->products_count }}</td>
            <td class="text-center">
              <div class="table-actions">
                <button class="btn btn-sm btn-outline-primary" onclick="editBrand({{ $brand->id }}, '{{ addslashes($brand->title) }}')"><i class="fas fa-edit"></i></button>
                <button class="btn btn-sm btn-outline-danger" onclick="deleteBrand({{ $brand->id }})"><i class="fas fa-trash"></i></button>
              </div>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="brandModal" tabindex="-1" role="dialog" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header bg_sb_primary">
        <h5 class="modal-title" id="brandModalTitle">Add Brand</h5>
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <form id="brandForm" enctype="multipart/form-data">
        <div class="modal-body">
          <input type="hidden" id="brandId">
          <div class="form-group">
            <label class="required">Title</label>
            <input type="text" class="form-control" id="brandTitle" required>
          </div>
          <div class="form-group">
            <label>Logo</label>
            <input type="file" class="form-control" id="brandLogo" accept="image/jpeg,image/png,image/jpg,image/svg+xml,image/webp">
            <small class="text-muted">Recommended small square image</small>
          </div>
        </div>
        <div class="modal-footer d-flex justify-content-between p-1">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="sb_btn" id="brandSaveBtn"><i class="fas fa-save"></i> Save</button>
        </div>
      </form>
    </div>
  </div>
  </div>
@endsection
@section('script')
<script>
$(document).ready(function(){
  // Initialize DataTable similar to categories
  $('#brandsTable').DataTable({
    responsive: true,
    dom: '<"top"f>rt<"bottom"ip>',
    order: [[1,'asc']],
    columnDefs: [
      {
        targets: 0,
        orderable: false,
        render: function (data, type, row, meta) {
          return meta.row + meta.settings._iDisplayStart + 1;
        }
      },
      { targets: [3,4], orderable: false }
    ],
    language: {
      search: "Search:",
      zeroRecords: "No matching records found",
      info: "Showing _START_ to _END_ of _TOTAL_ entries",
      infoEmpty: "Showing 0 to 0 of 0 entries",
      infoFiltered: "(filtered from _MAX_ total entries)"
    }
  });
});

function showAddBrand(){
  $('#brandId').val('');
  $('#brandTitle').val('');
  $('#brandLogo').val('');
  $('#brandModalTitle').text('Add Brand');
  $('#brandSaveBtn').text('Save');
  $('#brandModal').modal('show');
}

function editBrand(id, title){
  $('#brandId').val(id);
  $('#brandTitle').val(title);
  $('#brandLogo').val('');
  $('#brandModalTitle').text('Edit Brand');
  $('#brandSaveBtn').text('Update');
  $('#brandModal').modal('show');
}

$('#brandForm').on('submit', function(e){
  e.preventDefault();
  const id = $('#brandId').val();
  const formData = new FormData();
  formData.append('title', $('#brandTitle').val());
  if($('#brandLogo')[0].files[0]) formData.append('logo', $('#brandLogo')[0].files[0]);
  if(id){ formData.append('_method','PUT'); }

  fetch(id ? `/admin/brands/${id}` : '/admin/brands', {
    method: 'POST',
    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept':'application/json' },
    body: formData
  }).then(r=>r.json()).then(res=>{ 
      if(res.success){ 
          window.location.href = "{{ route('admin.brands') }}?success=" + encodeURIComponent(res.message || 'Brand saved successfully');
      } else { 
          window.location.href = "{{ route('admin.brands') }}?error=" + encodeURIComponent(res.message || 'Error saving brand');
      }
  }).catch(()=>{
      window.location.href = "{{ route('admin.brands') }}?error=Error%20saving%20brand";
  });
});

function deleteBrand(id){
  if(!confirm('Delete this brand?')) return;
  fetch(`/admin/brands/${id}`, { method:'DELETE', headers:{'X-CSRF-TOKEN':'{{ csrf_token() }}','Accept':'application/json'} })
    .then(r=>r.json()).then(res=>{ 
        if(res.success){ 
            window.location.href = "{{ route('admin.brands') }}?success=" + encodeURIComponent('Brand deleted successfully'); 
        } else { 
            window.location.href = "{{ route('admin.brands') }}?error=Error%20deleting%20brand"; 
        }
    }).catch(()=>{
        window.location.href = "{{ route('admin.brands') }}?error=Error%20deleting%20brand";
    });
}
</script>
@endsection


