(function ($) {
    "use strict";

    /*== Loader ==*/
    $(window).on("load", function () {
        $("#mn-overlay").fadeOut("fast");
        // Ensure mobile starts closed
        if (window.matchMedia('(max-width: 991px)').matches) {
            $('.mn-sidebar').removeClass('sidebar-hide');
            $('.mn-sidebar-overlay').hide();
            $('.mn-toggle-sidebar').removeClass('active-toggle');
        }
    });

    /*== Sidebar ==*/
    $('.mn-toggle-sidebar').on("click", function () {
        var isMobile = window.matchMedia('(max-width: 991px)').matches;
        var $sidebar = $('.mn-sidebar');
        if (isMobile) {
            // Off-canvas drawer behavior on mobile
            if ($sidebar.hasClass('sidebar-hide')) {
                // Currently OPEN (old convention) -> close
                $('.mn-sidebar-overlay').fadeOut();
                $sidebar.removeClass('sidebar-hide');
                $('.mn-toggle-sidebar').removeClass('active-toggle');
                $('body').removeClass('no-scroll');
            } else {
                // Currently CLOSED -> open
                $('.mn-sidebar-overlay').fadeIn();
                $sidebar.addClass('sidebar-hide');
                $('.mn-toggle-sidebar').addClass('active-toggle');
                $('body').addClass('no-scroll');
            }
        } else {
            // Desktop: overlay drawer like WoodMart
            if ($sidebar.hasClass('sb-overlay-open')) {
                // close
                $('.mn-sidebar-overlay').fadeOut();
                $sidebar.removeClass('sb-overlay-open').addClass('sidebar-hide');
                $('.mn-toggle-sidebar').removeClass('active-toggle');
                $('body').removeClass('no-scroll');
                $sidebar.data('pinned', false);
            } else {
                // open
                $('.mn-sidebar-overlay').fadeIn();
                $sidebar.removeClass('sidebar-hide').addClass('sb-overlay-open');
                $('.mn-toggle-sidebar').addClass('active-toggle');
                $('body').addClass('no-scroll');
                $sidebar.data('pinned', true); // opened by click
            }
        }
    });
    $(".mn-sidebar-overlay, .side-close").on('click', function (e) {
        // Close for both mobile and desktop with correct state per viewport
        var isMobile = window.matchMedia('(max-width: 991px)').matches;
        var $sidebar = $('.mn-sidebar');
        $('.mn-sidebar-overlay').fadeOut();
        if (isMobile) {
            // Mobile OPEN state uses .sidebar-hide -> remove to close
            $sidebar.removeClass('sidebar-hide');
        } else {
            // Desktop overlay -> remove overlay class and return to rail
            $sidebar.removeClass('sb-overlay-open').addClass('sidebar-hide');
        }
        $('.mn-toggle-sidebar').removeClass('active-toggle');
        $('body').removeClass('no-scroll');
        $sidebar.data('pinned', false);
    });
    function bindSidebarAccordion() {
        if (window.matchMedia('(max-width: 991px)').matches) {
            // Helper: hard-close mobile sidebar + overlay
            var closeMobileSidebar = function(){
                var $overlay = $('.mn-sidebar-overlay');
                var $sb = $('.mn-sidebar');
                // remove body lock FIRST so CSS !important no longer forces overlay visible
                $('body').removeClass('no-scroll');
                $sb.removeClass('sidebar-hide sb-overlay-open');
                $('.mn-toggle-sidebar').removeClass('active-toggle');
                // now hide overlay and clear any helper/state
                $overlay.removeClass('mn-sidebar-overlay-hide').stop(true, true).css({opacity:0}).hide();
                // Hide any other overlays just in case
                $('.mn-mobile-menu-overlay, .mn-side-cart-overlay, .mn-side-search-overlay').stop(true,true).hide().removeClass('mn-cart-overlay-active');
                // safety: ensure overlay is hidden even if other animations race
                setTimeout(function(){
                    $('.mn-sidebar-overlay').stop(true, true).hide().css({opacity:0});
                    $('body').removeClass('no-scroll');
                }, 120);
            };
            // mobile/tablet: accordion by click
            $('.mn-drop-toggle').off('mouseenter mouseleave');
            $('.mn-drop-toggle').off('click').on('click', function () {
                if ($(this).hasClass('active-nav')) {
                    $(this).removeClass('active-nav');
                    $(this).siblings('.mn-sb-drop').slideUp(150);
                } else {
                    $('.mn-drop-toggle').removeClass('active-nav');
                    $('.mn-sb-drop').slideUp(150);
                    $(this).addClass('active-nav');
                    $(this).siblings('.mn-sb-drop').slideDown(150);
                }
            });
            // Mobile: close drawer when tapping the All Categories pill in header
            $(document)
                .off('click.mobileClose touchstart.mobileClose', '.mn-sidebar-header .all-categories-btn, .mn-sidebar-header #allCategoriesBtn')
                .on('click.mobileClose touchstart.mobileClose', '.mn-sidebar-header .all-categories-btn, .mn-sidebar-header #allCategoriesBtn', function(e){
                    e.preventDefault();
                    e.stopPropagation();
                    closeMobileSidebar();
                    // ensure any overlay listeners run
                    $('.mn-sidebar-overlay').trigger('click');
                });

            // Mobile: also close when tapping anywhere in the header area (safety net if pill markup differs)
            $(document)
                .off('click.mobileHdrAny touchstart.mobileHdrAny', '.mn-sidebar .mn-sidebar-header')
                .on('click.mobileHdrAny touchstart.mobileHdrAny', '.mn-sidebar .mn-sidebar-header', function(e){
                    // If click is specifically on a menu item toggle, let it pass
                    if ($(e.target).closest('.mn-toggle-sidebar').length) return;
                    e.preventDefault();
                    e.stopPropagation();
                    closeMobileSidebar();
                    $('.mn-sidebar-overlay').trigger('click');
                });

            // Mobile: tap/click anywhere outside the sidebar to close (robust even if overlay missing)
            $(document)
                .off('click.mobileOutside touchstart.mobileOutside pointerdown.mobileOutside')
                .on('click.mobileOutside touchstart.mobileOutside pointerdown.mobileOutside', function(e){
                    // Only act when drawer is open
                    if (!$('.mn-sidebar').hasClass('sidebar-hide')) return;
                    // Ignore clicks inside sidebar or on toggler button
                    if ($(e.target).closest('.mn-sidebar, .mn-toggle-sidebar, .all-categories-btn, #allCategoriesBtn').length) return;
                    closeMobileSidebar();
                });

            // Ensure clicks inside the sidebar never bubble to outside-close
            $('.mn-sidebar').off('click.stopInside touchstart.stopInside').on('click.stopInside touchstart.stopInside', function(e){
                e.stopPropagation();
            });
        } else {
            // desktop
            $('.mn-drop-toggle').off('click');
            var $items = $('.mn-sb-item');
            $items.off('mouseenter mouseleave');
            // compute top offset equal to header/button height
            var sidebarTop = ($('.mn-sidebar .mn-sidebar-header').outerHeight() || 56);
            $('.mn-sidebar').css('--sb-flyout-top', sidebarTop + 'px');
            $(window).off('resize.sbtop').on('resize.sbtop', function(){
                var t = ($('.mn-sidebar .mn-sidebar-header').outerHeight() || 56);
                $('.mn-sidebar').css('--sb-flyout-top', t + 'px');
            });
            // Hover logic: when collapsed, keep rail narrow and only show flyout
            $items.on('mouseenter', function(){
                var $sidebar = $('.mn-sidebar');
                var $drop = $(this).children('.mn-sb-drop');
                $('.mn-sb-drop').css({opacity:0,visibility:'hidden'});
                if ($drop.length) {
                    // ensure correct left based on collapsed/expanded
                    if ($sidebar.hasClass('sidebar-hide')) {
                        $drop.css({left:'64px'});
                    } else {
                        $drop.css({left:'280px'});
                    }
                    $drop.css({opacity:1,visibility:'visible',transform:'translateX(0)'});
                }
            });
            // keep open while hovering the flyout
            $('.mn-sb-drop').on('mouseenter', function(){
                $(this).css({opacity:1,visibility:'visible'});
            }).on('mouseleave', function(){
                $(this).css({opacity:0,visibility:'hidden'});
            });
            $('.mn-sidebar').on('mouseleave', function(){
                $('.mn-sb-drop').css({opacity:0,visibility:'hidden'});
                // nothing else to do
            });
            // trigger button toggles collapsed rail (icons-only) and cancels overlay state
            $('.sb-rail-trigger').off('click').on('click', function(e){
                e.preventDefault();
                var $sidebar = $('.mn-sidebar');
                // close overlay if open
                $sidebar.removeClass('sb-overlay-open');
                $('.mn-sidebar-overlay').fadeOut(0);
                $('body').removeClass('no-scroll');
                // toggle rail
                $sidebar.toggleClass('sidebar-hide');
            });
            
            // Desktop hover open/close for overlay
            var isHoverDesktop = window.matchMedia('(min-width: 992px) and (hover: hover) and (pointer: fine)').matches;
            if (isHoverDesktop) {
                $('.mn-sidebar').off('mouseenter.sidebarHover mouseleave.sidebarHover');
                $('.mn-sidebar').on('mouseenter.sidebarHover', function(){
                    var $sb = $(this);
                    if (!$sb.hasClass('sb-overlay-open')) {
                        $('.mn-sidebar-overlay').stop(true, true).fadeIn(120);
                        $sb.removeClass('sidebar-hide').addClass('sb-overlay-open');
                        // do not change body scroll on hover
                        $sb.data('pinned', false);
                    }
                }).on('mouseleave.sidebarHover', function(){
                    var $sb = $(this);
                    // auto-close only if not pinned via click
                    if ($sb.hasClass('sb-overlay-open') && !$sb.data('pinned')) {
                        $('.mn-sidebar-overlay').stop(true, true).fadeOut(120);
                        $sb.removeClass('sb-overlay-open').addClass('sidebar-hide');
                    }
                });
            } else {
                // Touch view: detach hover handlers and ensure overlay is hidden
                $('.mn-sidebar').off('mouseenter.sidebarHover mouseleave.sidebarHover');
                $('.mn-sidebar-overlay').fadeOut(0);
                $('body').removeClass('no-scroll');
            }

            // Remove mobile outside-close listener when not in mobile view
            if (!window.matchMedia('(max-width: 991px)').matches) {
                $(document).off('click.mobileOutside touchstart.mobileOutside');
            }
            
            // Track if sidebar was opened by click
            $('.mn-sidebar').on('click', function(){
                $(this).data('clicked', true);
            });
        }
    }
    bindSidebarAccordion();
    $(window).on('resize', function(){ bindSidebarAccordion(); });
    // Ensure overlay is hidden when switching to desktop
    $(window).on('resize', function(){
        if (!window.matchMedia('(max-width: 991px)').matches) {
            $('.mn-sidebar-overlay').fadeOut(0);
        } else {
            // On switching to mobile, default to closed state
            $('.mn-sidebar').removeClass('sidebar-hide');
            $('.mn-toggle-sidebar').removeClass('active-toggle');
        }
    });

    // Safety observer: hide overlay if sidebar is not open (mobile)
    (function(){
        var $sb = $('.mn-sidebar');
        if (!$sb.length || typeof MutationObserver === 'undefined') return;
        var observer = new MutationObserver(function(){
            var isMobile = window.matchMedia('(max-width: 991px)').matches;
            if (!isMobile) return;
            var openMobile = $sb.hasClass('sidebar-hide'); // in this codebase, sidebar-hide = open on mobile
            if (!openMobile) {
                $('.mn-sidebar-overlay').stop(true, true).hide().css({opacity:0});
                $('body').removeClass('no-scroll');
            }
        });
        observer.observe($sb.get(0), { attributes: true, attributeFilter: ['class'] });
    })();

    /*  Mobile menu sidebar JS  */
    $(".mn-toggle-menu").on("click", function () {
        $(".mn-mobile-menu-overlay").fadeIn();
        $(".mn-mobile-menu").addClass("mn-menu-open");
    });

    $(".mn-mobile-menu-overlay, .mn-close-menu").on("click", function () {
        $(".mn-mobile-menu-overlay").fadeOut();
        $(".mn-mobile-menu").removeClass("mn-menu-open");
    });
    function ResponsiveMobilemsMenu() {
        var $msNav = $(".mn-menu-content, .overlay-menu"),
            $msNavSubMenu = $msNav.find(".sub-menu");
        $msNavSubMenu.parent().prepend('<span class="menu-toggle"></span>');

        $msNav.on("click", "li a, .menu-toggle", function (e) {
            var $this = $(this);
            if ($this.attr("href") === "#" || $this.hasClass("menu-toggle")) {
                e.preventDefault();
                if ($this.siblings("ul:visible").length) {
                    $this.parent("li").removeClass("active");
                    $this.siblings("ul").slideUp();
                    $this.parent("li").find("li").removeClass("active");
                    $this.parent("li").find("ul:visible").slideUp();
                } else {
                    $this.parent("li").addClass("active");
                    $this
                        .closest("li")
                        .siblings("li")
                        .removeClass("active")
                        .find("li")
                        .removeClass("active");
                    $this.closest("li").siblings("li").find("ul:visible").slideUp();
                    $this.siblings("ul").slideDown();
                }
            }
        });
    }

    ResponsiveMobilemsMenu();

    /*== Cart sidebar JS ==*/
    $('.mn-cart-toggle').on("click", function (e) {
        e.preventDefault();
        $(".mn-side-cart-overlay").fadeIn();
        $('.mn-side-cart').addClass("mn-open-cart");
    });
    $('.mn-side-cart-overlay, .mn-cart-close').on("click", function (e) {
        e.preventDefault();
        $(".mn-side-cart-overlay").fadeOut();
        $('.mn-side-cart').removeClass("mn-open-cart");
    });
    $(".cart-remove-item").on("click", function (e) {
        $(this).parents(".cart-sidebar-list").remove();
        var cart_product_count = $(".cart-sidebar-list").length;
        if (cart_product_count == 0) {
            $('.mn-cart-pro-items').html('<p class="mn-cart-msg">Your Cart is empty!</p>');
        }
    });

    /*== Remove Product (Cart page) ==*/
    $('.mn-cart-pro-remove a').on("click", function () {
        $(this).parents(".mn-cart-product").remove();
        var cart_page_count = $(".mn-cart-product").length;
        if (cart_page_count == 0) {
            $('.cart_list').html('<p class="mn-cart-page-msg">Your Cart is empty!</p>');
        }
    });

    /*== Add to cart button js ==*/
    $('.mn-add-cart').on("click", function () {
        var iscartlist = $(this).hasClass("active");
        if (iscartlist) {
            $(this).removeClass("active");
        } else {
            $(this).addClass("active");
        }
    });

    /*== Search sidebar JS ==*/
    $('.mn-search-toggle').on("click", function (e) {
        e.preventDefault();
        $(".mn-side-search-overlay").fadeIn();
        $('.mn-side-search').addClass("mn-open-search");
    });
    $('.mn-side-search-overlay, .mn-search-close').on("click", function (e) {
        e.preventDefault();
        $(".mn-side-search-overlay").fadeOut();
        $('.mn-side-search').removeClass("mn-open-search");
    });
    $(".search-remove-item").on("click", function (e) {
        $(this).parents(".search-sidebar-list").remove();
        var search_product_count = $(".search-sidebar-list").length;
        if (search_product_count == 0) {
            $('.mn-search-pro-items').html('<p class="mn-search-msg">Please try to search other products!</p>');
        }
    });

    /*== Filter Icon OnClick Open filter Sidebar on shop page ==*/
    $(".filter-toggle-icon").on("click", function () {
        $(".filter-sidebar-overlay").fadeIn();
        $(".mn-filter-sidebar").addClass("filter-sidebar-open");
    });

    $(".filter-close, .filter-sidebar-overlay").on("click", function () {
        $(".mn-filter-sidebar").removeClass("filter-sidebar-open");
        $(".filter-sidebar-overlay").fadeOut();
    });

    /*== Product Image Zoom ==*/
    $('.zoom-image-hover').zoom();

    /*== single product Slider ==*/
    $('.single-product-cover').slick({
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        fade: false,
        asNavFor: '.single-nav-thumb',
        adaptiveHeight: true
    });

    $('.single-nav-thumb').slick({
        slidesToShow: 4,
        slidesToScroll: 1,
        asNavFor: '.single-product-cover',
        dots: false,
        arrows: true,
        focusOnSelect: true
    });

    $(window).on('load resize', function () {
        $('.single-product-cover').slick('setPosition');
    });

    /*== Add More Product slider section (Single Product Page) ==*/
    $('.mn-add-more-slider').owlCarousel({
        margin: 24,
        loop: true,
        dots: false,
        nav: false,
        smartSpeed: 1500,
        autoplay: false,
        items: 3,
        responsiveClass: true,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 2
            },
            768: {
                items: 2
            },
            992: {
                items: 2
            },
            1200: {
                items: 3
            },
            1400: {
                items: 3
            }
        }
    });

    /*== Price Range slider ( Shop page ) == */
    const slider = document.getElementById('mn-sliderPrice');
    if (slider) {
        const rangeMin = parseInt(slider.dataset.min);
        const rangeMax = parseInt(slider.dataset.max);
        const step = parseInt(slider.dataset.step);
        const filterInputs = document.querySelectorAll('input.filter__input');

        noUiSlider.create(slider, {
            start: [rangeMin, rangeMax],
            connect: true,
            step: step,
            range: {
                'min': rangeMin,
                'max': rangeMax
            },

            // make numbers whole
            format: {
                to: value => value,
                from: value => value
            }
        });

        // bind inputs with noUiSlider 
        slider.noUiSlider.on('update', (values, handle) => {
            filterInputs[handle].value = values[handle];
        });

        filterInputs.forEach((input, indexInput) => {
            input.addEventListener('change', () => {
                slider.noUiSlider.setHandle(indexInput, input.value);
            })
        });
    }


    /*== Tooltips ==*/
    $(".mn-modern-banner").owlCarousel({
        loop: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        smartSpeed: 2000,
        autoplay: false,
        autoplayTimeout: 10000,
        margin: 24,
        nav: false,
        dots: false,
        responsive: {
            0: {
                items: 1,
                scroll: 1,
            },
        },
    });

    /*== Cart page Apply Coupan Toggle ==*/
    $(document).ready(function () {
        $(".mn-cart-coupan").on("click", function () {
            $('.mn-cart-coupan-content').slideToggle('slow');
        });
        $(".mn-checkout-coupan").on("click", function () {
            $('.mn-checkout-coupan-content').slideToggle('slow');
        });
    });

    

    /*== Accordians toggle (faq page) ==*/
    $('.mn-accordion-header').on("click", function () {
        $(this).parent().siblings().children(".mn-accordion-body").slideUp();
        $(this).parent().find(".mn-accordion-body").slideToggle();
    });


    /*== Tooltips ==*/
    $('[data-tooltip]').on('mouseenter', function () {
        const $el = $(this);
        const title = $el.attr('title');

        if (title) {
            // Remove native tooltip temporarily
            $el.data('tooltip-title', title).removeAttr('title');

            // Create tooltip and append
            const $tooltip = $('<span class="custom-tooltip"></span>').text(title);
            $el.append($tooltip);
            $tooltip.fadeIn(200);
        }
    });

    $('[data-tooltip]').on('mouseleave', function () {
        const $el = $(this);
        const title = $el.data('tooltip-title');

        // Restore title attribute
        if (title) $el.attr('title', title);

        // Remove tooltip
        $el.find('.custom-tooltip').remove();
    });
    $('[data-tooltip-bottom]').on('mouseenter', function () {
        const $el = $(this);
        const title = $el.attr('title');

        if (title) {
            // Remove native tooltip temporarily
            $el.data('tooltip-title', title).removeAttr('title');

            // Create tooltip and append
            const $tooltip = $('<span class="custom-tooltip-bottom"></span>').text(title);
            $el.append($tooltip);
            $tooltip.fadeIn(200);
        }
    });

    $('[data-tooltip-bottom]').on('mouseleave', function () {
        const $el = $(this);
        const title = $el.data('tooltip-title');

        // Restore title attribute
        if (title) $el.attr('title', title);

        // Remove tooltip
        $el.find('.custom-tooltip-bottom').remove();
    });

    /*----------------------------- List Grid View -------------------------------- */
    $('.mn-gl-btn').on('click', 'button', function () {
        var $this = $(this);
        $this.addClass('active').siblings().removeClass('active');
    });

    // for 100% width list view
    function listView(e) {
        var $gridCont = $('.shop-pro-inner');
        var $listView = $('.pro-gl-content');
        e.preventDefault();
        $gridCont.addClass('list-view');
        $listView.addClass('width-100');
    }

    function gridView(e) {
        var $gridCont = $('.shop-pro-inner');
        var $gridView = $('.pro-gl-content');
        e.preventDefault();
        $gridCont.removeClass('list-view');
        $gridView.removeClass('width-100');
    }

    $(document).on('click', '.btn-grid', gridView);
    $(document).on('click', '.btn-list', listView);

    // for 50% width list view
    function listView50(e) {
        var $gridCont = $('.shop-pro-inner');
        var $listView = $('.pro-gl-content');
        e.preventDefault();
        $gridCont.addClass('list-view-50');
        $listView.addClass('width-50');
    }

    function gridView50(e) {
        var $gridCont = $('.shop-pro-inner');
        var $gridView = $('.pro-gl-content');
        e.preventDefault();
        $gridCont.removeClass('list-view-50');
        $gridView.removeClass('width-50');
    }

    $(document).on('click', '.btn-grid-50', gridView50);
    $(document).on('click', '.btn-list-50', listView50);

    /*== Product & shop page category Toggle == */
    $(document).ready(function () {
        $(".mn-sidebar-block.drop .mn-sb-block-content ul li ul").addClass("mn-cat-sub-dropdown");

        $(".mn-sidebar-block.drop .mn-sidebar-block-item").on("click", function () {
            var $this = $(this).closest('.mn-sb-block-content').find('.mn-cat-sub-dropdown');
            $this.slideToggle('slow');
            $('.mn-cat-sub-dropdown').not($this).slideUp('slow');
        });
    });

    /*== Remove filter selection == */
    $(".mn-select-cancel").on("click", function () {
        $(this).parent(".mn-select-btn").remove();
    });
    $(".mn-select-btn-clear").on("click", function () {
        $(this).parent(".mn-select-bar").remove();
    });

    /*  Product Weight & Size select JS  */
    $(".mn-pro-variation-inner.mn-pro-variation-size ul li").on("click", function (e) {
        $(".mn-pro-variation-inner.mn-pro-variation-size ul li").removeClass("active");
        // $(".mn-pro-variation ul li").removeClass("active");
        $(this).addClass("active");
    });
    $(".mn-pro-variation-inner.mn-pro-variation-color ul li").on("click", function (e) {
        $(".mn-pro-variation-inner.mn-pro-variation-color ul li").removeClass("active");
        $(this).addClass("active");
    });

    /*  Footer Toggle  */
    $(document).ready(function () {
        $(".mn-footer-links").addClass("mn-footer-dropdown");

        $(".mn-footer-heading").append(
            "<div class='mn-heading-res'><i class='ri-add-line'></i></div>"
        );

        $(".mn-footer-heading .mn-heading-res").on("click", function () {
            $(this).children("i").remove();
            var $this = $(this).closest(".footer-top .col-sm-12").find(".mn-footer-dropdown");
            if ($(this).hasClass("mn-active")) {
                $this.slideUp("slow");
                $(this).removeClass("mn-active");
                $(this).children("i").remove();
                $(this).append(
                    "<i class='ri-add-line'></i>"
                );
            } else {
                $(".mn-heading-res").removeClass("mn-active");
                $(this).addClass("mn-active");
                $this.slideDown("slow");
                $(".mn-footer-dropdown").not($this).slideUp("slow");
                $(".mn-heading-res").children("i").remove();
                $(".mn-heading-res").append(
                    "<i class='ri-add-line'></i>"
                );
                $(this).children("i.ri-add-line").remove();
                $(this).append(
                    "<i class='ri-subtract-line'></i>"
                );
            }
        });

    });

})(jQuery);