<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Drop legacy manual payment tables if they exist
        if (Schema::hasTable('order_payments')) {
            Schema::drop('order_payments');
        }
        if (Schema::hasTable('payment_methods')) {
            Schema::drop('payment_methods');
        }

        // Add SSLCommerz friendly columns on orders
        Schema::table('orders', function (Blueprint $table) {
            if (!Schema::hasColumn('orders', 'payment_status')) {
                $table->string('payment_status')->default('unpaid')->after('payment_method');
            }
            if (!Schema::hasColumn('orders', 'payment_trxid')) {
                $table->string('payment_trxid')->nullable()->after('payment_status');
            }
        });
    }

    public function down(): void
    {
        // Remove added columns
        Schema::table('orders', function (Blueprint $table) {
            if (Schema::hasColumn('orders', 'payment_trxid')) {
                $table->dropColumn('payment_trxid');
            }
            if (Schema::hasColumn('orders', 'payment_status')) {
                $table->dropColumn('payment_status');
            }
        });

        // Optionally recreate minimal legacy tables so rollback works
        if (!Schema::hasTable('payment_methods')) {
            Schema::create('payment_methods', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('code')->unique();
                $table->text('instructions')->nullable();
                $table->string('logo_path')->nullable();
                $table->boolean('is_active')->default(true);
                $table->integer('sort_order')->default(0);
            });
        }

        if (!Schema::hasTable('order_payments')) {
            Schema::create('order_payments', function (Blueprint $table) {
                $table->id();
                $table->foreignId('order_id')->constrained()->onDelete('cascade');
                $table->foreignId('payment_method_id')->nullable();
                $table->string('sender_number')->nullable();
                $table->string('transaction_id')->nullable();
                $table->unsignedInteger('amount')->default(0);
                $table->string('status')->default('pending');
                $table->text('admin_note')->nullable();
                $table->timestamps();
            });
        }
    }
};



