<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = [
        'favicon_path',
        'site_logo_path',
        'admin_logo_path',
        'footer_copyright',
        'google_analytics_id',
        'meta_keywords',
        'meta_description',
        'loader_image_path',
        'pixel_code',
        'contact_address',
        'contact_phone',
        'contact_email',
        'social_media',
        'footer_description',
        'api_key',
        'api_data_toggles',
        'api_enabled'
    ];

    public $timestamps = false;

    protected $casts = [
        'social_media' => 'array',
        'api_data_toggles' => 'array',
        'api_enabled' => 'boolean'
    ];

    public static function singleton(): self
    {
        return static::query()->firstOrCreate([], []);
    }
} 