<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customization extends Model
{
    use HasFactory;

    protected $fillable = [
        'home',
        'contact',
    ];

    public $timestamps = false;

    protected $casts = [
        'home' => 'array',
        'contact' => 'array',
    ];

    public static function singleton(): self
    {
        /** @var self|null $instance */
        $instance = self::query()->first();
        if (!$instance) {
            $instance = self::create([
                'home' => [
                    'sliders' => [],
                    'services' => [],
                    'featured' => [],
                    'hero_boxes' => [],
                ],
            ]);
        }
        return $instance;
    }
} 