<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PaymentStatus extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $order;
    public $status;
    public $adminNote;

    public function __construct(Order $order, string $status, ?string $adminNote = null)
    {
        $this->order = $order;
        $this->status = $status;
        $this->adminNote = $adminNote;
    }

    public function envelope(): Envelope
    {
        $subject = $this->status === 'verified' 
            ? 'Payment Confirmed - Order ' . $this->order->order_number
            : 'Payment Rejected - Order ' . $this->order->order_number;
            
        return new Envelope(
            subject: $subject,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.payment-status',
        );
    }
} 