<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ContactFormSubmission extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $data;
    public $isUserCopy;

    public function __construct($data, $isUserCopy = false)
    {
        $this->data = $data;
        $this->isUserCopy = $isUserCopy;
    }

    public function envelope(): Envelope
    {
        $subject = $this->isUserCopy 
            ? 'Thank you for contacting ' . config('app.name')
            : 'New Contact Form Submission - ' . ucfirst($this->data['type']);
            
        return new Envelope(
            subject: $subject,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.contact-form',
        );
    }

    public function build()
    {
        $adminMail = env('ADMIN_NOTIFIER_MAIL');
        $userMail = $this->data['email'];

        if ($this->isUserCopy) {
            $this->to($userMail);
        } else {
            $this->to($adminMail)
                 ->replyTo($userMail, $this->data['name']);
        }

        return $this;
    }
} 