<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;

class CompareController extends Controller
{
    public function index()
    {
        // Comparison attributes for tech products
        $compareAttributes = [
            'brand' => 'Brand',
            'processor' => 'Processor/CPU',
            'graphics' => 'Graphics/GPU',
            // CPU details
            'cpu_model' => 'CPU Model',
            'cpu_generation' => 'CPU Generation',
            'cpu_cores' => 'CPU Cores',
            'cpu_threads' => 'CPU Threads',
            'cpu_base_clock' => 'CPU Base Clock',
            'cpu_boost_clock' => 'CPU Boost Clock',
            // GPU details
            'gpu_model' => 'GPU Model',
            'gpu_vram' => 'GPU VRAM',
            // Motherboard / Platform
            'motherboard' => 'Motherboard',
            'chipset' => 'Chipset',
            // Memory/RAM
            'memory' => 'Memory/RAM',
            'ram_type' => 'RAM Type',
            'ram_speed' => 'RAM Speed',
            'ram_slots' => 'Total RAM Slots',
            'ram_max' => 'Max RAM Capacity',
            'storage' => 'Storage',
            'storage_ssd' => 'SSD',
            'storage_hdd' => 'HDD',
            'storage_m2_slots' => 'M.2 Slots',
            'storage_sata_slots' => 'SATA Slots',
            'display' => 'Display',
            'display_size' => 'Display Size',
            'display_resolution' => 'Resolution',
            'display_refresh_rate' => 'Refresh Rate',
            'display_panel' => 'Panel Type',
            'display_brightness' => 'Brightness (nits)',
            'power_supply' => 'Power Supply',
            'connectivity' => 'Connectivity',
            'wifi' => 'Wi‑Fi',
            'bluetooth' => 'Bluetooth',
            'ethernet' => 'Ethernet/LAN',
            'ports' => 'Ports',
            'tpm' => 'TPM',
            'operating_system' => 'Operating System',
            'battery_capacity' => 'Battery Capacity',
            'charger_wattage' => 'Charger Wattage',
            'webcam' => 'Webcam',
            'keyboard_backlight' => 'Keyboard Backlight',
            'dimensions' => 'Dimensions',
            'weight' => 'Weight',
            'warranty' => 'Warranty'
        ];
        
        // We'll load products via AJAX
        return view('general.compare', compact('compareAttributes'));
    }
    
    public function getProducts(Request $request)
    {
        $productIds = $request->input('product_ids', []);
        
        if (empty($productIds)) {
            return response()->json(['products' => []]);
        }
        
        $products = Product::with(['category', 'brand', 'variations' => function($q) {
            $q->where('default', true);
        }, 'images' => function($q) {
            $q->where('is_primary', true);
        }])->whereIn('id', $productIds)->get();
        
        $formattedProducts = $products->map(function($product) {
            $defaultVariation = $product->variations->first();
            $inStock = $defaultVariation ? $defaultVariation->in_stock > 0 : false;
            
            // Extract specifications from product
            $specs = $product->specification ?? [];
            
            return [
                'id' => $product->id,
                'title' => $product->title,
                'slug' => $product->slug,
                'category' => $product->category ? $product->category->name : '',
                'brand' => $product->brand ? $product->brand->title : '',
                'image' => $product->images->first() ? $product->images->first()->url : asset('assets/default_img.png'),
                'rating' => $product->average_rating ?? 0,
                'ratings_count' => $product->ratings_count ?? 0,
                'in_stock' => $inStock,
                'price' => $defaultVariation ? $defaultVariation->sale_price : 0,
                'regular_price' => $defaultVariation ? $defaultVariation->regular_price : 0,
                'description' => $product->description,
                'processor' => $specs['processor'] ?? '',
                'graphics' => $specs['graphics'] ?? '',
                // CPU
                'cpu_model' => $specs['cpu_model'] ?? ($specs['processor_model'] ?? ''),
                'cpu_generation' => $specs['cpu_generation'] ?? '',
                'cpu_cores' => $specs['cpu_cores'] ?? '',
                'cpu_threads' => $specs['cpu_threads'] ?? '',
                'cpu_base_clock' => $specs['cpu_base_clock'] ?? ($specs['base_clock'] ?? ''),
                'cpu_boost_clock' => $specs['cpu_boost_clock'] ?? ($specs['boost_clock'] ?? ''),
                // GPU
                'gpu_model' => $specs['gpu_model'] ?? ($specs['graphics_model'] ?? ''),
                'gpu_vram' => $specs['gpu_vram'] ?? ($specs['graphics_vram'] ?? ''),
                // Motherboard / Platform
                'motherboard' => $specs['motherboard'] ?? ($specs['motherboard_model'] ?? ($specs['mainboard'] ?? '')),
                'chipset' => $specs['chipset'] ?? ($specs['motherboard_chipset'] ?? ''),
                'memory' => $specs['memory'] ?? '',
                'ram_type' => $specs['ram_type'] ?? '',
                'ram_speed' => $specs['ram_speed'] ?? '',
                'ram_slots' => $specs['ram_slots'] ?? '',
                'ram_max' => $specs['ram_max'] ?? ($specs['max_ram'] ?? ''),
                'storage' => $specs['storage'] ?? '',
                'storage_ssd' => $specs['storage_ssd'] ?? ($specs['ssd'] ?? ''),
                'storage_hdd' => $specs['storage_hdd'] ?? ($specs['hdd'] ?? ''),
                'storage_m2_slots' => $specs['storage_m2_slots'] ?? ($specs['m2_slots'] ?? ''),
                'storage_sata_slots' => $specs['storage_sata_slots'] ?? ($specs['sata_slots'] ?? ''),
                'display' => $specs['display'] ?? '',
                'display_size' => $specs['display_size'] ?? '',
                'display_resolution' => $specs['display_resolution'] ?? ($specs['resolution'] ?? ''),
                'display_refresh_rate' => $specs['display_refresh_rate'] ?? ($specs['refresh_rate'] ?? ''),
                'display_panel' => $specs['display_panel'] ?? ($specs['panel_type'] ?? ''),
                'display_brightness' => $specs['display_brightness'] ?? ($specs['brightness'] ?? ''),
                'power_supply' => $specs['power_supply'] ?? '',
                'connectivity' => $specs['connectivity'] ?? '',
                'wifi' => $specs['wifi'] ?? ($specs['wi_fi'] ?? ''),
                'bluetooth' => $specs['bluetooth'] ?? '',
                'ethernet' => $specs['ethernet'] ?? ($specs['lan'] ?? ''),
                'ports' => $specs['ports'] ?? '',
                'tpm' => $specs['tpm'] ?? ($specs['tpm_version'] ?? ''),
                'operating_system' => $specs['operating_system'] ?? '',
                'battery_capacity' => $specs['battery_capacity'] ?? '',
                'charger_wattage' => $specs['charger_wattage'] ?? ($specs['adapter_wattage'] ?? ''),
                'webcam' => $specs['webcam'] ?? '',
                'keyboard_backlight' => $specs['keyboard_backlight'] ?? '',
                'dimensions' => $specs['dimensions'] ?? '',
                'weight' => $specs['weight'] ?? '',
                'warranty' => $specs['warranty'] ?? '',
            ];
        });
        
        return response()->json(['products' => $formattedProducts]);
    }
}
