<div class="d-flex justify-content-between align-items-center mb-2 sb-reviews-head" style="max-width: 980px;">
    <h5 class="mb-0">Product Reviews</h5>
    <div class="d-flex gap-2">
        <form method="GET" class="d-flex gap-2" onsubmit="return false;">
            <div class="input-group input-group-sm" style="width:auto;">
                <span class="input-group-text">Sort</span>
                <select name="sort" class="form-select form-select-sm js-review-sort">
                    <option value="latest" <?php echo e($sort==='latest' ? 'selected' : ''); ?>>Relevance</option>
                    <option value="highest" <?php echo e($sort==='highest' ? 'selected' : ''); ?>>Highest</option>
                    <option value="lowest" <?php echo e($sort==='lowest' ? 'selected' : ''); ?>>Lowest</option>
                    <option value="oldest" <?php echo e($sort==='oldest' ? 'selected' : ''); ?>>Oldest</option>
                </select>
            </div>
            <div class="input-group input-group-sm" style="width:auto;">
                <span class="input-group-text">Filter</span>
                <select name="star" class="form-select form-select-sm js-review-star">
                    <option value="0" <?php echo e($star===0 ? 'selected' : ''); ?>>All star</option>
                    <?php for($i=5;$i>=1;$i--): ?>
                        <option value="<?php echo e($i); ?>" <?php echo e($star===$i ? 'selected' : ''); ?>><?php echo e($i); ?> star</option>
                    <?php endfor; ?>
                </select>
            </div>
        </form>
    </div>
</div>
<div class="row">
    <div class="col-md-4">
        <div class="p-3 mb-3 text-center">
            <div class="d-flex justify-content-center">
                <div class="sb-rating-score"><?php echo e(number_format($averageRating, 1)); ?></div>
                <div class="ms-2 sb-rating-divider">/5</div>
            </div>
            <div class="mn-pro-rating my-2 sb-rating-stars">
                <?php for($i=1; $i<=5; $i++): ?>
                    <i class="ri-star-fill <?php echo e($i <= round($averageRating) ? '' : 'grey'); ?>"></i>
                <?php endfor; ?>
            </div>
            <div class="sb-rating-light d-block"><?php echo e($totalRatings); ?> Ratings</div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="p-3 mb-3">
            <?php for($s=5; $s>=1; $s--): ?>
                <?php $count = $distribution[$s] ?? 0; $percent = $totalRatings ? round(($count / $totalRatings) * 100) : 0; ?>
                <div class="d-flex align-items-center mb-2 sb-row-count">
                    <div class="mn-pro-rating me-2" style="min-width: 110px;">
                        <?php for($i=1; $i<=5; $i++): ?>
                            <i class="ri-star-fill <?php echo e($i <= $s ? '' : 'grey'); ?>" style="font-size:16px"></i>
                        <?php endfor; ?>
                    </div>
                    <div class="flex-grow-1 me-2 sb-progress-wrap">
                        <div class="progress" style="height:8px;">
                            <div class="progress-bar bg-warning" role="progressbar" style="width: <?php echo e($percent); ?>%"></div>
                        </div>
                    </div>
                    <div style="min-width: 24px;" class="text-end"><?php echo e($count); ?></div>
                </div>
            <?php endfor; ?>
        </div>
    </div>
</div>

<?php if($canReview): ?>
<div class="mn-ratting-content">
    <h3>Add a Review</h3>
    <div class="mn-ratting-form">
        <form action="<?php echo e(route('product.rating.store', ['product' => $product->id])); ?>" method="POST" class="js-review-form">
            <?php echo csrf_field(); ?>
            <div class="mn-ratting-star mb-2">
                <input type="hidden" name="rating" id="ratingInput" value="5">
                <div class="mn-t-review-rating mn-pro-rating" id="ratingStars">
                    <?php for($i=1; $i<=5; $i++): ?>
                        <i data-value="<?php echo e($i); ?>" class="ri-star-fill"></i>
                    <?php endfor; ?>
                </div>
            </div>
            <div class="mn-ratting-input form-submit">
                <textarea name="comment" placeholder="Write your review here (optional)"></textarea>
                <button type="submit" class="mn-btn-2 px-4"><span>Submit</span></button>
            </div>
        </form>
    </div>
</div>
<?php elseif(auth()->check()): ?>
    <p class="text-muted">You have already reviewed this product or you are not eligible to review.</p>
<?php else: ?>
    <p class="text-muted">Please login to add a review.</p>
<?php endif; ?>

<hr>
<div class="mt-3">
    <?php $__empty_1 = true; $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="d-flex mb-3">
            <div class="me-3" style="width:40px;height:40px;border-radius:50%;background:#f1f1f1;display:flex;align-items:center;justify-content:center;">
                <span class="ri-user-line"></span>
            </div>
            <div class="flex-grow-1">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <strong><?php echo e($review->user->name ?? 'User'); ?></strong><?php if(auth()->id() === ($review->user->id ?? null)): ?> <button type="button" class="btn btn-link p-0 ms-2 text-danger js-delete-rating" data-url="<?php echo e(route('product.rating.delete', ['product' => $product->id])); ?>" title="Delete your rating"><i class="ri-delete-bin-line"></i></button><?php endif; ?>
                    </div>
                    <small class="text-muted"><?php echo e($review->created_at->format('d M Y')); ?></small>
                </div>
                <div class="mn-pro-rating mt-1 mb-1" style="font-size:14px;">
                    <?php for($i=1; $i<=5; $i++): ?>
                        <i class="ri-star-fill <?php echo e($i <= $review->rating ? '' : 'grey'); ?>"></i>
                    <?php endfor; ?>
                </div>
                <?php if($review->comment): ?>
                    <p class="mb-0 mt-1"><?php echo e($review->comment); ?></p>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-muted">No reviews yet.</p>
    <?php endif; ?>

    <?php if($reviews->hasPages()): ?>
        <div class="mt-4 js-review-pagination d-flex justify-content-end">
            <?php echo e($reviews->onEachSide(1)->links('pagination::bootstrap-4')); ?>

        </div>
    <?php endif; ?>
</div> <?php /**PATH /home/axesba/public_html/edemo/resources/views/partial/reviews.blade.php ENDPATH**/ ?>