

<?php $__env->startSection('title', 'Add New Post'); ?>

<?php $__env->startSection('style'); ?>
<style>
.form-label {
    font-weight: 600;
}
.required:after {
    content: ' *';
    color: red;
}
.thumbnail-preview {
    width: 100%;
    max-width: 300px;
    height: 180px;
    border: 2px dashed #ddd;
    border-radius: 8px;
    margin-bottom: 15px;
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
}
.thumbnail-preview:hover {
    border-color: #159abe;
    background-color: rgba(58, 78, 229, 0.05);
}
.thumbnail-preview img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.thumbnail-preview .upload-prompt {
    text-align: center;
    color: #6c757d;
}
.thumbnail-preview .upload-prompt i {
    font-size: 2rem;
    margin-bottom: 10px;
}
.tag-input {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    row-gap: 6px;
    padding: 8px;
    border: 1px solid #ced4da;
    border-radius: 4px;
    min-height: 45px;
    background: #fff;
}
.tag {
    background-color: #e9ecef;
    border: 1px solid #dee2e6;
    border-radius: 20px;
    padding: 4px 12px;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-size: 0.9rem;
    margin-bottom: 6px;
}
.tag .remove-tag {
    color: #dc3545;
    cursor: pointer;
    font-size: 1.1rem;
    line-height: 1;
    padding: 2px;
}
.tag .remove-tag:hover {
    color: #bb2d3b;
}
.tag-input input {
    border: none;
    outline: none;
    padding: 4px;
    flex-grow: 1;
    min-width: 120px;
    font-size: 0.9rem;
}
.section-card {
    background-color: #ffffff;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    margin-bottom: 20px;
}
.section-card .card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #e0e0e0;
    padding: 15px 20px;
}
.section-card .card-body {
    padding: 20px;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <form id="blogForm" onsubmit="saveBlog(event)">
        <div class="row">
            <div class="col-md-8">
                <!-- Main Content -->
                <div class="section-card">
                    <div class="card-header">
                        <h5 class="mb-0">Post Content</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group mb-3">
                            <label for="title" class="form-label required">Title</label>
                            <input type="text" class="form-control" id="title" name="title" required>
                        </div>

                        <div class="form-group mb-3">
                            <label for="content" class="form-label required">Content</label>
                            <textarea class="form-control" id="content" name="content" rows="12" required></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- Thumbnail -->
                <div class="section-card">
                    <div class="card-header">
                        <h5 class="mb-0">Thumbnail</h5>
                    </div>
                    <div class="card-body">
                        <div class="thumbnail-preview" id="thumbnailClickArea">
                            <div class="upload-prompt">
                                <i class="fas fa-cloud-upload-alt"></i>
                                <div>Click to upload thumbnail</div>
                                <small class="text-muted">Maximum size: 2MB</small>
                            </div>
                            <img id="thumbnailPreview" style="display: none;">
                        </div>
                        <input type="file" id="thumbnail" accept="image/*" style="display: none;" required>
                    </div>
                </div>

                <!-- Tags -->
                <div class="section-card">
                    <div class="card-header">
                        <h5 class="mb-0">Tags</h5>
                    </div>
                    <div class="card-body">
                        <div class="tag-input" onclick="document.getElementById('tagInput').focus()">
                            <div id="tagContainer"></div>
                            <input type="text" id="tagInput" placeholder="Type and press Enter to add tags...">
                        </div>
                        <small class="text-muted">Press Enter or comma to add a tag</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4 mb-5">
            <div class="col-12 text-center">
                <button type="submit" class="sb_btn">
                    <i class="fas fa-save"></i> Publish Post
                </button>
                <a href="<?php echo e(route('admin.blogs')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<!-- Summernote CSS/JS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs4.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs4.min.js"></script>
<script>
let tags = [];
let thumbnailFile = null;

// Initialize Summernote
$(function() {
    $('#content').summernote({
        height: 350,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'italic', 'underline', 'clear']],
            ['fontname', ['fontname']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'video']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });
});

// Thumbnail Preview
document.getElementById('thumbnailClickArea').addEventListener('click', function(e) {
    document.getElementById('thumbnail').click();
});
document.getElementById('thumbnail').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        if (file.size > 2 * 1024 * 1024) {
            alert('Image size should not exceed 2MB');
            this.value = '';
            return;
        }
        thumbnailFile = file;
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById('thumbnailPreview');
            preview.src = e.target.result;
            preview.style.display = 'block';
            document.querySelector('.upload-prompt').style.display = 'none';
        }
        reader.readAsDataURL(file);
    }
});

// Tags Management
const tagInput = document.getElementById('tagInput');

tagInput.addEventListener('keydown', function(e) {
    if ((e.key === 'Enter' || e.key === ',') && !e.shiftKey) {
        e.preventDefault();
        const tag = this.value.trim().toLowerCase();
        addTag(tag);
    }
});

function addTag(tag) {
    tag = tag.trim().toLowerCase();
    if (tag && !tags.includes(tag)) {
        tags.push(tag);
        renderTags();
        tagInput.value = '';
    }
}

function removeTag(index) {
    tags.splice(index, 1);
    renderTags();
}

function renderTags() {
    const container = document.getElementById('tagContainer');
    container.innerHTML = tags.map((tag, index) => `
        <div class="tag">
            ${tag}
            <span class="remove-tag" onclick="removeTag(${index})">&times;</span>
        </div>
    `).join('');
}

// Form Submission
function saveBlog(event) {
    event.preventDefault();
    
    const formData = new FormData();
    formData.append('title', document.getElementById('title').value);
    formData.append('content', $('#content').summernote('code'));
    formData.append('thumbnail', thumbnailFile);
    // Send tags as array
    tags.forEach(tag => formData.append('tags[]', tag));

    // Show loading state
    const submitBtn = event.target.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Publishing...';
    submitBtn.disabled = true;

    fetch('/admin/blogs', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.href = "<?php echo e(route('admin.blogs')); ?>?success=Blog post published successfully";
        } else {
            alert(data.message || 'Error creating blog post');
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error creating blog post');
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/blogs/create.blade.php ENDPATH**/ ?>