<?php $__env->startSection("title", "My Account"); ?>
<?php $__env->startSection("style"); ?>
<?php echo $__env->make('partial.user_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.profile-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #f5f5f5;
}
.profile-avatar {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    background: #f5f5f5;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 40px;
    color: #313b50;
    margin-right: 20px;
}
.profile-info h4 {
    margin: 0;
    color: #313b50;
    font-size: 24px;
}
.profile-info p {
    margin: 5px 0 0;
    color: #666;
}
.verification-badge {
    display: inline-flex;
    align-items: center;
    padding: 3px 10px;
    border-radius: 15px;
    font-size: 12px;
    margin-left: 10px;
}
.verification-badge.verified {
    background: #e8f5e9;
    color: #2e7d32;
}
.verification-badge.unverified {
    background: #ffebee;
    color: #c62828;
}
.verification-badge i {
    margin-right: 5px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="container account-wrapper">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            <?php echo $__env->make('partial.user_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <!-- Profile Header -->
                <div class="profile-header">
                    <div class="profile-avatar">
                        <i class="ri-user-smile-line"></i>
                    </div>
                    <div class="profile-info">
                        <h4><?php echo e(auth()->user()->first_name); ?> <?php echo e(auth()->user()->last_name); ?></h4>
                        <p><?php echo e(auth()->user()->email); ?>

                            <?php if(auth()->user()->email_verified_at): ?>
                                <span class="verification-badge verified">
                                    <i class="ri-checkbox-circle-line"></i> Verified
                                </span>
                            <?php else: ?>
                                <span class="verification-badge unverified">
                                    <i class="ri-error-warning-line"></i> Unverified
                                </span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>

                <!-- Profile Form -->
                <form action="<?php echo e(route('profile.update')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="first_name">First Name</label>
                                <input type="text" class="form-control" id="first_name" name="first_name" 
                                    value="<?php echo e(old('first_name', auth()->user()->first_name)); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="last_name">Last Name</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" 
                                    value="<?php echo e(old('last_name', auth()->user()->last_name)); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">Email Address</label>
                                <input type="email" class="form-control" id="email" name="email" 
                                    value="<?php echo e(old('email', auth()->user()->email)); ?>" required>
                                <?php if(!auth()->user()->email_verified_at): ?>
                                    <small class="text-danger">
                                        Your email is not verified. 
                                        <a href="<?php echo e(route('verification.notice')); ?>">Click here to verify</a>
                                    </small>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="phone">Phone Number</label>
                                <input type="tel" class="form-control" id="phone" name="phone" 
                                    value="<?php echo e(old('phone', auth()->user()->phone)); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="mn-btn-2">
                            <span><i class="ri-save-line me-1"></i> Save Changes</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/user/account.blade.php ENDPATH**/ ?>