<?php $__env->startSection('title', 'Blog Comments'); ?>

<?php $__env->startSection('style'); ?>
<style>
.comment-content {
    white-space: pre-line;
    color: #2c3e50;
    font-size: 14px;
    line-height: 1.5;
}
.comment-meta {
    font-size: 0.85rem;
    color: #6c757d;
}
.blog-title {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 5px;
    text-decoration: none;
}
.blog-title:hover {
    color: #159abe;
    text-decoration: underline;
}
.reply-count {
    font-size: 0.7rem;
    color: #6c757d;
    margin-top: 6px;
    padding: 2px 6px;
    background-color: #e3f2fd;
    border-radius: 8px;
    display: inline-block;
    line-height: 1.2;
}
.reply-count i {
    color: #1976d2;
    margin-right: 3px;
    font-size: 0.7rem;
}
.table td {
    vertical-align: middle;
    padding: 12px 8px;
}
.table th {
    background: #667eea !important;
    color: white !important;
    font-weight: 600;
    border: none;
    padding: 15px 8px;
}
.user-info {
    display: flex;
    align-items: center;
    gap: 12px;
}
.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
.user-name {
    font-weight: 600;
    color: #2c3e50;
    font-size: 14px;
}
.comment-row {
    background-color: #ffffff;
    border-left: 4px solid #4CAF50;
    transition: all 0.2s ease;
}
.comment-row:hover {
    background-color: #f8f9fa;
    transform: translateX(2px);
}
.reply-row {
    background: linear-gradient(90deg, #f8f9fa 0%, #e3f2fd 100%) !important;
    border-left: 4px solid #2196F3;
    transition: all 0.2s ease;
    height: auto !important;
    min-height: 40px !important;
}
.reply-row:hover {
    background: linear-gradient(90deg, #e3f2fd 0%, #bbdefb 100%) !important;
    transform: translateX(2px);
}
.reply-row .comment-content {
    padding-left: 18px;
    color: #1976d2;
    font-weight: 500;
    font-size: 12px;
    line-height: 1.3;
}
.reply-row .user-avatar {
    background: linear-gradient(135deg, #2196F3 0%, #1976d2 100%);
    width: 28px;
    height: 28px;
}
.reply-row .user-name {
    color: #1976d2;
    font-weight: 600;
    font-size: 12px;
}
.reply-row .comment-meta {
    color: #42a5f5;
    font-size: 11px;
}
.reply-row td {
    padding: 6px 8px !important;
    font-size: 12px !important;
    line-height: 1.2 !important;
}
.reply-row .btn-sm {
    padding: 2px 4px !important;
    font-size: 10px !important;
    width: 22px !important;
    height: 22px !important;
    min-width: 22px !important;
}
.reply-row .btn-sm i {
    font-size: 9px !important;
}
.reply-row .user-info {
    gap: 8px !important;
}
.reply-row .comment-content {
    font-size: 11px !important;
    line-height: 1.2 !important;
    padding: 2px 0 !important;
}
.reply-row .user-name {
    font-size: 11px !important;
    line-height: 1.2 !important;
}
.reply-row .comment-meta {
    font-size: 10px !important;
    line-height: 1.1 !important;
}
.table {
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}
.table tbody tr {
    border-bottom: 1px solid #e9ecef;
}
.table tbody tr:last-child {
    border-bottom: none;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Blog Comments</h1>
    </div>

    <!-- Content Card -->
    <div class="card">
        <div class="card-body">
            <?php if($paginatedComments->isEmpty()): ?>
                <div class="text-center py-5">
                    <i class="fas fa-comments fa-3x text-muted mb-3"></i>
                    <p class="mb-0">No comments found.</p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-bordered mb-0">
                        <thead class="bg_sb_primary">
                            <tr>
                                <th style="width: 200px">User</th>
                                <th>Comment</th>
                                <th style="width: 200px">Post</th>
                                <th style="width: 150px">Date</th>
                                <th style="width: 100px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $paginatedComments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item['type'] === 'comment'): ?>
                                    <?php
                                        $comment = $item['data']['comment'];
                                        $replies = $item['data']['replies'];
                                    ?>
                                    
                                    <!-- Main Comment -->
                                    <tr class="comment-row">
                                        <td>
                                            <div class="user-info">
                                                <div class="user-avatar">
                                                    <i class="fas fa-user"></i>
                                                </div>
                                                <div>
                                                    <div class="user-name">
                                                        <a href="<?php echo e(route('admin.users.edit', $comment->user->id)); ?>" class="text-decoration-none">
                                                            <?php echo e($comment->user->name); ?>

                                                        </a>
                                                    </div>
                                                    <div class="comment-meta">
                                                        <?php echo e($comment->user->email); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="comment-content"><?php echo e($comment->comment); ?></div>
                                            <?php if($replies->count() > 0): ?>
                                                <div class="reply-count mt-2">
                                                    <i class="fas fa-reply"></i>
                                                    <strong><?php echo e($replies->count()); ?> <?php echo e(Str::plural('reply', $replies->count())); ?></strong>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.blogs.edit', $item['blog'])); ?>" class="blog-title">
                                                <?php echo e($item['blog']->title); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <div title="<?php echo e($comment->created_at); ?>">
                                                <?php echo e($comment->created_at->format('d M, Y h:i A')); ?>

                                            </div>
                                            <small class="text-muted">
                                                <?php echo e($comment->created_at->format('h:i A')); ?>

                                            </small>
                                        </td>
                                        <td>
                                            <button type="button" 
                                                    class="btn btn-sm btn-danger"
                                                    onclick="deleteComment(<?php echo e($comment->id); ?>)"
                                                    title="Delete">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php
                                        $reply = $item['reply'];
                                        $comment = $item['data']['comment'];
                                    ?>
                                    
                                    <!-- Reply Row -->
                                    <tr class="reply-row">
                                        <td>
                                            <div class="user-info" style="padding-left: 20px;">
                                                <div class="user-avatar" style="background-color: #e3f2fd; width: 30px; height: 30px;">
                                                    <i class="fas fa-reply text-primary" style="font-size: 12px;"></i>
                                                </div>
                                                <div>
                                                    <div class="user-name">
                                                        <a href="<?php echo e(route('admin.users.edit', $reply->user->id)); ?>" class="text-decoration-none">
                                                            <?php echo e($reply->user->name); ?>

                                                        </a>
                                                    </div>
                                                    <div class="comment-meta">
                                                        <?php echo e($reply->user->email); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="comment-content" style="padding-left: 15px; border-left: 3px solid #2196F3;">
                                                <?php echo e($reply->comment); ?>

                                            </div>
                                        </td>
                                        <td>
                                            <small class="text-muted" style="font-size: 10px;">
                                                <i class="fas fa-reply"></i> Reply
                                            </small>
                                        </td>
                                        <td>
                                            <div title="<?php echo e($reply->created_at); ?>">
                                                <?php echo e($reply->created_at->format('d M, Y h:i A')); ?>

                                            </div>
                                            <small class="text-muted">
                                                <?php echo e($reply->created_at->format('h:i A')); ?>

                                            </small>
                                        </td>
                                        <td>
                                            <button type="button" 
                                                    class="btn btn-sm btn-danger"
                                                    onclick="deleteComment(<?php echo e($reply->id); ?>)"
                                                    title="Delete">
                                                <i class="fas fa-minus"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if($paginatedComments->hasPages()): ?>
                    <div class="mt-4">
                        <?php echo e($paginatedComments->links('pagination::bootstrap-4')); ?>

                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
function deleteComment(id) {
    if (!confirm('Are you sure you want to delete this comment? This will also delete all replies.')) {
        return;
    }

    fetch(`/admin/blogs/comments/${id}`, {
        method: 'DELETE',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.reload();
        } else {
            alert(data.message || 'Error deleting comment');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error deleting comment');
    });
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/blogs/comments.blade.php ENDPATH**/ ?>