<?php $__env->startSection("title", "Security"); ?>
<?php $__env->startSection("style"); ?>
<?php echo $__env->make('partial.user_styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
.security-section {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #f5f5f5;
}
.security-section:last-child {
    margin-bottom: 0;
    padding-bottom: 0;
    border-bottom: none;
}
.security-section h5 {
    color: #313b50;
    margin-bottom: 20px;
}
.security-info {
    color: #666;
    margin-bottom: 0;
}

/* QR Code Styles */
.qr-code-wrapper {
    background: #fff;
    padding: 20px;
    border-radius: 10px;
    display: inline-block;
    margin-bottom: 20px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.qr-code-wrapper svg {
    display: block;
}
.secret-code {
    background: #f8f9fa;
    padding: 12px;
    border-radius: 6px;
    font-family: monospace;
    font-size: 16px;
    color: #495057;
    text-align: center;
    letter-spacing: 2px;
}

/* Button Styles */
.mn-btn-2.btn-danger {
    background: #dc3545;
    color: #fff;
}
.mn-btn-2.btn-danger:hover {
    background: #bb2d3b;
    color: #000;
}

.btn-danger {
    background: #dc3545;
    color: #fff;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    position: relative;
    overflow: hidden;
    z-index: 1;
}
.btn-danger::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #ffe3a3;
    transform: translateX(-100%);
    transition: transform 0.3s ease;
    z-index: -1;
}
.btn-danger:hover {
    color: #000;
}
.btn-danger:hover::before {
    transform: translateX(0);
}
.btn-danger i {
    margin-right: 6px;
    font-size: 16px;
}

.recovery-codes {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
    margin: 15px 0;
}
.recovery-code {
    background: #fff;
    padding: 12px 15px;
    border-radius: 6px;
    font-family: monospace;
    font-size: 16px;
    color: #495057;
    letter-spacing: 1px;
    margin: 8px 0;
    text-align: center;
    border: 1px solid #e9ecef;
}
.recovery-code:not(:last-child) {
    border-bottom: 1px solid #e9ecef;
}

.recovery-section {
    margin-top: 20px;
    padding-top: 20px;
    border-top: 1px solid #e5e5e5;
}
.recovery-section .section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}
.recovery-section .section-header h6 {
    margin: 0;
    font-size: 15px;
    color: #313b50;
}
.recovery-section .section-content {
    display: none;
}
.recovery-section .section-content.show {
    display: block;
}

.modal-body.text-center {
    padding: 15px 20px;
}
.modal-body p.text-muted {
    margin-bottom: 10px;
    font-size: 14px;
}
.modal-header {
    padding: 10px;
}
.modal-body h5 {
    margin-bottom: 10px;
    font-size: 16px;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
<div class="container account-wrapper" data-has-qr="<?php echo e(session()->has('qrCode') ? 'true' : 'false'); ?>">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            <?php echo $__env->make('partial.user_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <!-- Password Change Section -->
                <div class="security-section">
                    <h5>Change Password</h5>
                    <form action="<?php echo e(route('security.password')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Current Password</label>
                                    <input type="password" class="form-control" name="current_password" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>New Password</label>
                                    <input type="password" class="form-control" name="password" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Confirm New Password</label>
                                    <input type="password" class="form-control" name="password_confirmation" required>
                                </div>
                            </div>
                        </div>
                        <div class="text-end">
                            <button type="submit" class="mn-btn-2">
                                <span><i class="ri-lock-password-line me-1"></i> Update Password</span>
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Two-Factor Authentication Section -->
                <div class="security-section">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-2">Two-Factor Authentication</h5>
                            <p class="security-info">Add an extra layer of security to your account</p>
                        </div>
                        <?php if(!$has2faEnabled && !auth()->user()->two_factor_secret): ?>
                            <form action="<?php echo e(route('security.2fa.enable')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="mn-btn-2">
                                    <span><i class="ri-shield-keyhole-line me-1"></i> Enable 2FA</span>
                                </button>
                            </form>
                        <?php elseif(!$has2faEnabled && auth()->user()->two_factor_secret): ?>
                            <form action="<?php echo e(route('security.2fa.cancel')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn-danger">
                                    <i class="ri-close-line me-1"></i> Cancel 2FA Setup
                                </button>
                            </form>
                        <?php else: ?>
                            <button type="button" class="btn-danger" data-bs-toggle="modal" data-bs-target="#disable2faModal">
                                <i class="ri-shield-off-line"></i> Disable 2FA
                            </button>
                        <?php endif; ?>
                    </div>

                    <?php if(!$has2faEnabled && auth()->user()->two_factor_secret): ?>
                        <div class="setup-2fa-section mt-4 p-4 bg-light rounded">
                            <h6 class="mb-3">Setup Two-Factor Authentication</h6>
                            <p class="text-muted mb-4">1. Scan this QR code with your authenticator app</p>
                            <div class="qr-code-wrapper d-inline-block bg-white p-3 rounded mb-4">
                                <?php echo $qrCode; ?>

                            </div>
                            <p class="mb-2">Or manually enter this code:</p>
                            <div class="secret-code d-inline-block bg-white px-3 py-2 rounded mb-4 font-monospace"><?php echo e($secret); ?></div>
                            
                            <form action="<?php echo e(route('security.2fa.confirm')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label class="mb-2">2. Enter the 6-digit code from your app to verify</label>
                                    <input type="text" class="form-control text-center" name="code" 
                                           required maxlength="6" style="letter-spacing: 0.5em; max-width: 200px;"
                                           id="otpInput" autofocus>
                                </div>
                                <button type="submit" class="mn-btn-2 mt-3">
                                    <span><i class="ri-shield-check-line me-1"></i> Verify & Enable 2FA</span>
                                </button>
                            </form>
                        </div>
                    <?php endif; ?>

                    <?php if($has2faEnabled): ?>
                        <div class="recovery-section" 
                            data-has-recovery-codes="<?php echo e(session()->has('showRecoveryCodes') && session()->has('recoveryCodes')); ?>"
                            data-has-new-codes="<?php echo e(session()->has('newRecoveryCodes')); ?>">
                            <div class="section-header">
                                <h6>Recovery Codes</h6>
                                <div class="d-flex gap-2">
                                    <button type="button" class="mn-btn-2" data-bs-toggle="modal" data-bs-target="#recoveryCodes2faModal" title="View Recovery Codes">
                                        <i class="ri-eye-line"></i>
                                    </button>
                                    <button type="button" class="mn-btn-2" data-bs-toggle="modal" data-bs-target="#regenerateCodesModal" title="Generate New Codes">
                                        <i class="ri-refresh-line"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Delete Account Section -->
                <div class="security-section">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-2">Delete Your Account</h5>
                            <p class="security-info">Once you delete your account, there is no going back</p>
                        </div>
                        <button type="button" class="mn-btn-2 btn-danger" data-bs-toggle="modal" data-bs-target="#deleteAccountModal">
                            <span><i class="ri-delete-bin-line me-1"></i> Delete Account</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Disable 2FA Modal -->
<div class="modal fade" id="disable2faModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center px-4 pb-5">
                <h5 class="mb-4">Disable Two-Factor Authentication</h5>
                <p class="text-muted mb-4">Are you sure you want to disable 2FA? This will make your account less secure.</p>
                <form action="<?php echo e(route('security.2fa.disable')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group mb-4">
                        <label>Enter your password to confirm</label>
                        <input type="password" class="form-control" name="password" required>
                    </div>
                    <button type="submit" class="btn-danger">
                        <i class="ri-shield-off-line"></i> Disable 2FA
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Delete Account Modal -->
<div class="modal fade" id="deleteAccountModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center px-4 pb-5">
                <h5 class="mb-4">Delete Account</h5>
                <p class="text-muted mb-4">Are you sure you want to delete your account? This action cannot be undone.</p>
                <form action="<?php echo e(route('security.account.delete')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <div class="form-group">
                        <label>Enter your password to confirm</label>
                        <input type="password" class="form-control" name="password" required>
                    </div>
                    <button type="submit" class="mn-btn-2 btn-danger">
                        <span><i class="ri-delete-bin-line me-1"></i> Delete Account</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Recovery Codes Modal -->
<div class="modal fade" id="recoveryCodes2faModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center px-4 pb-4">
                <h5 class="mb-2">Save Your Recovery Codes</h5>
                <p class="text-muted mb-3">Keep these recovery codes in a safe place. You can use them to regain access to your account if you lose your 2FA device.</p>
                
                <div class="recovery-codes">
                    <?php if(session()->has('recoveryCodes')): ?>
                        <?php $__currentLoopData = session('recoveryCodes'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="recovery-code"><?php echo e($code); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php elseif($has2faEnabled && auth()->user()->two_factor_recovery_codes): ?>
                        <?php $__currentLoopData = json_decode(auth()->user()->two_factor_recovery_codes); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="recovery-code"><?php echo e($code); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Regenerate Recovery Codes Modal -->
<div class="modal fade" id="regenerateCodesModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center px-4 pb-5">
                <h5 class="mb-4">Generate New Recovery Codes</h5>
                <p class="text-muted mb-4">Are you sure? Your old recovery codes will no longer work.</p>
                
                <form action="<?php echo e(route('security.2fa.regenerate-codes')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="mn-btn-2">
                        <span><i class="ri-refresh-line me-1"></i> Generate New Codes</span>
                    </button>
                    <button type="button" class="mn-btn-2 ms-2" data-bs-dismiss="modal">
                        <span><i class="ri-close-line me-1"></i> Cancel</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto focus OTP input if it exists
        const otpInput = document.getElementById('otpInput');
        if (otpInput) {
            otpInput.focus();
            otpInput.addEventListener('input', function() {
                this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6);
            });
        }

        // Handle recovery codes modal
        const section = document.querySelector('.recovery-section');
        if (!section) return;

        const hasNewCodes = section.dataset.hasNewCodes === 'true';
        const hasRecoveryCodes = section.dataset.hasRecoveryCodes === 'true';
        
        if (hasNewCodes || hasRecoveryCodes) {
            const recoveryCodes2faModal = document.getElementById('recoveryCodes2faModal');
            if (recoveryCodes2faModal) {
                const modal = new bootstrap.Modal(recoveryCodes2faModal);
                modal.show();
            }
        }
    });
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/user/security.blade.php ENDPATH**/ ?>