<?php $__env->startSection('title', 'Compare Products'); ?>
<?php $__env->startSection('style'); ?>
<style>
.mn-compare-box {
    width: 100%;
    display: flex;
    overflow-x: auto;
    overflow-y: hidden;
    border: 1px solid #eee;
}
.mn-compare-box::-webkit-scrollbar {
    height: 10px;
}
.mn-compare-box::-webkit-scrollbar-track {
    background: #f0f2f5;
    border-radius: 10px;
}
.mn-compare-box::-webkit-scrollbar-thumb {
    background: #c4c9d4;
    border-radius: 10px;
}
.mn-compare-box::-webkit-scrollbar-thumb:hover {
    background: #aab1bf;
}
.mn-compare-col {
    min-width: 250px;
    border-right: 1px solid #eee;
}
.mn-compare-col:last-child {
    border-right: none;
}
.title-col {
    min-width: 200px;
    background-color: #f8f9fa;
}
.mn-compare-cell {
    padding: 15px;
    min-height: 60px;
    border-bottom: 1px solid #eee;
    display: flex;
    align-items: center;
}
.mn-compare-cell:last-child {
    border-bottom: none;
}
.mn-compare-cell h5 {
    margin: 0;
    font-size: 14px;
    font-weight: 600;
}
.mn-compare-cell p {
    margin: 0;
}
.mn-compare-cell .list {
    position: relative;
    text-align: center;
}
.mn-compare-cell .list img {
    max-width: 150px;
    max-height: 150px;
    object-fit: contain;
}
.mn-compare-cell .mn-action {
    margin-top: 10px;
}
.mn-compare-cell .mn-action ul {
    display: flex;
    justify-content: center;
    gap: 10px;
}
.mn-compare-cell .desc {
    max-height: 100px;
    overflow-y: auto;
}
.product-col {
    position: relative;
}
.remove-compare-product {
    position: absolute;
    top: 5px;
    right: 5px;
    width: 24px;
    height: 24px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 0, 0, 0.1);
    color: #ff0000;
    border-radius: 50%;
    z-index: 5;
}
.mn-pro-rating {
    display: flex;
    gap: 2px;
}
.mn-pro-rating i {
    color: #ffc107;
}
.mn-pro-rating i.grey {
    color: #ccc;
}
.rating-info {
    font-size: 12px;
    color: #666;
    margin-top: 5px;
}
.i-stock {
    color: #28a745;
    font-weight: 600;
}
.o-stock {
    color: #dc3545;
    font-weight: 600;
}
.no-products {
    padding: 50px 0;
    text-align: center;
}
.no-products h3 {
    margin-bottom: 20px;
}
.no-products p {
    margin-bottom: 30px;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="mn-breadcrumb m-b-30">
    <div class="row">
        <div class="col-12">
            <div class="row gi_breadcrumb_inner">
                <div class="col-md-6 col-sm-12">
                    <h2 class="mn-breadcrumb-title">Compare Products</h2>
                </div>
                <div class="col-md-6 col-sm-12">
                    <!-- mn-breadcrumb-list start -->
                    <ul class="mn-breadcrumb-list">
                        <li class="mn-breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="mn-breadcrumb-item active">Compare</li>
                    </ul>
                    <!-- mn-breadcrumb-list end -->
                </div>
            </div>
        </div>
    </div>
</div>

<div id="compare-container">
    <div class="no-products">
        <h3>No Products to Compare</h3>
        <p>Add products to compare by clicking the compare icon <i class="ri-repeat-line"></i> on product cards.</p>
        <a href="<?php echo e(route('product.list')); ?>" class="mn-btn-1">Browse Products</a>
    </div>
</div>

<template id="compare-template">
    <section class="p-b-15">
    <div class="row">
        <div class="col-md-12">
            <div class="mn-compare-box">
                <div class="mn-compare-col title-col">
                    <div class="mn-compare-cell">
                        <div class="title">
                            <h5>Product Image</h5>
                        </div>
                    </div>
                    <div class="mn-compare-cell">
                        <h5>Name</h5>
                    </div>
                    <div class="mn-compare-cell">
                        <h5>Category</h5>
                    </div>
                            <div class="mn-compare-cell">
                                <h5>Brand</h5>
                            </div>
                            <div class="mn-compare-cell">
                                <h5>Price</h5>
                            </div>
                    <div class="mn-compare-cell">
                        <h5>Ratings</h5>
                    </div>
                    <div class="mn-compare-cell">
                        <h5>Availability</h5>
                    </div>
                            <?php $__currentLoopData = $compareAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($key != 'brand'): ?> 
                    <div class="mn-compare-cell">
                                    <h5><?php echo e($label); ?></h5>
                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </div>
                        <!-- Product columns will be added here dynamically -->
                    </div>
                </div>
                            </div>
    </section>
</template>

<template id="product-column-template">
    <div class="mn-compare-col product-col" data-product-id="">
                    <a href="javascript:void(0)" class="remove-compare-product"><i class="ri-close-large-line"></i></a>
                    <div class="mn-compare-cell">
                        <div class="list">
                <img src="" alt="product">
                        </div>
                    </div>
        <div class="mn-compare-cell product-name">
            <p></p>
                    </div>
        <div class="mn-compare-cell product-category">
            <p></p>
                    </div>
        <div class="mn-compare-cell product-brand">
            <p></p>
                    </div>
        <div class="mn-compare-cell product-price">
            <p></p>
                    </div>
        <div class="mn-compare-cell product-rating">
                        <span class="mn-pro-rating">
                <!-- Stars will be added dynamically -->
                        </span>
            <p class="rating-info"></p>
                    </div>
        <div class="mn-compare-cell product-stock">
            <p></p>
                    </div>
        <?php $__currentLoopData = $compareAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($key != 'brand'): ?> 
            <div class="mn-compare-cell product-<?php echo e($key); ?>">
                <p></p>
                    </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
    </div>
</template>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize compare functionality
    initCompare();
});

function initCompare() {
    // Get compare products from localStorage
    const compareProducts = getCompareProducts();
    
    // Update compare count in header
    window.updateCompareCount && window.updateCompareCount();
    
    // If there are products to compare, load them
    if (compareProducts.length > 0) {
        loadCompareProducts(compareProducts);
    }
    
    // Add event listeners for remove buttons
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-compare-product')) {
            const productCol = e.target.closest('.product-col');
            const productId = productCol.dataset.productId;
            
            // Remove from localStorage
            removeFromCompare(productId);
            
            // Remove from DOM
            productCol.remove();
            
            // Update compare count in header
            window.updateCompareCount && window.updateCompareCount();
            
            // If no products left, show empty state
            const compareProducts = getCompareProducts();
            if (compareProducts.length === 0) {
                showEmptyState();
            }
        }
    });
}

function getCompareProducts() {
    const compareProducts = localStorage.getItem('compareProducts');
    return compareProducts ? JSON.parse(compareProducts) : [];
}


function loadCompareProducts(productIds) {
    // Show loading state
    document.getElementById('compare-container').innerHTML = '<div class="text-center p-5"><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div></div>';
    
    // Fetch products data
    fetch('<?php echo e(route("compare.products")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({ product_ids: productIds })
    })
    .then(response => response.json())
    .then(data => {
        if (data.products && data.products.length > 0) {
            renderCompareProducts(data.products);
        } else {
            showEmptyState();
        }
    })
    .catch(error => {
        console.error('Error fetching compare products:', error);
        showEmptyState();
    });
}

function renderCompareProducts(products) {
    // Get template
    const compareTemplate = document.getElementById('compare-template');
    const compareHTML = compareTemplate.innerHTML;
    
    // Create compare container
    document.getElementById('compare-container').innerHTML = compareHTML;
    
    // Get compare box
    const compareBox = document.querySelector('.mn-compare-box');
    
    // Get product column template
    const productColumnTemplate = document.getElementById('product-column-template');
    
    // Add each product
    products.forEach(product => {
        // Clone template
        const productColumn = document.importNode(productColumnTemplate.content, true);
        
        // Set product ID
        productColumn.querySelector('.product-col').dataset.productId = product.id;
        
        // Set product image
        productColumn.querySelector('.list img').src = product.image;
        productColumn.querySelector('.list img').alt = product.title;
        
        // Set product name
        productColumn.querySelector('.product-name p').textContent = product.title;
        
        // Set product category
        productColumn.querySelector('.product-category p').textContent = product.category;
        
        // Set product brand
        productColumn.querySelector('.product-brand p').textContent = product.brand;
        
        // Set product price
        const priceElement = productColumn.querySelector('.product-price p');
        priceElement.innerHTML = `৳${product.price.toLocaleString()}`;
        if (product.regular_price > product.price) {
            priceElement.innerHTML += ` <del class="text-muted">৳${product.regular_price.toLocaleString()}</del>`;
        }
        
        // Set product rating
        const ratingElement = productColumn.querySelector('.product-rating .mn-pro-rating');
        ratingElement.innerHTML = '';
        
        for (let i = 1; i <= 5; i++) {
            const star = document.createElement('i');
            if (i <= Math.floor(product.rating)) {
                star.className = 'ri-star-fill';
            } else if (i <= Math.ceil(product.rating) && product.rating % 1 !== 0) {
                star.className = 'ri-star-half-fill';
            } else {
                star.className = 'ri-star-fill grey';
            }
            ratingElement.appendChild(star);
        }
        
        productColumn.querySelector('.rating-info').textContent = `(${product.ratings_count} Review${product.ratings_count !== 1 ? 's' : ''})`;
        
        // Set product stock
        const stockElement = productColumn.querySelector('.product-stock p');
        stockElement.textContent = product.in_stock ? 'In Stock' : 'Out of Stock';
        stockElement.className = product.in_stock ? 'i-stock' : 'o-stock';
        
        // Set product specs
        <?php $__currentLoopData = $compareAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($key != 'brand'): ?>
                if (product.<?php echo e($key); ?>) {
                    productColumn.querySelector('.product-<?php echo e($key); ?> p').textContent = product.<?php echo e($key); ?>;
                } else {
                    productColumn.querySelector('.product-<?php echo e($key); ?> p').textContent = 'N/A';
                }
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
        
        // Add to compare box
        compareBox.appendChild(productColumn);
    });
}

function showEmptyState() {
    document.getElementById('compare-container').innerHTML = `
        <div class="no-products">
            <h3>No Products to Compare</h3>
            <p>Add products to compare by clicking the compare icon on product cards.</p>
            <a href="<?php echo e(route('product.list')); ?>" class="mn-btn-1">Browse Products</a>
        </div>
    `;
}

function removeFromCompare(productId) {
    let compareProducts = getCompareProducts();
    compareProducts = compareProducts.filter(id => id != productId);
    localStorage.setItem('compareProducts', JSON.stringify(compareProducts));
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('general_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/axesba/public_html/edemo/resources/views/general/compare.blade.php ENDPATH**/ ?>