<?php $__env->startSection('title', 'Track Your Order'); ?>
<?php $__env->startSection('style'); ?>
<style>
:root {
    --ot-primary: #ffc107;
    --ot-muted: #6c757d;
    --ot-border: rgba(0,0,0,0.1);
    --ot-success: #10b981;
    --ot-danger: #dc3545;
}

.ot-container {
    position: relative;
    padding: 40px 0;
    width: 100%;
    margin: 0 auto;
}

.ot-hero {
    text-align: center;
    margin-bottom: 40px;
}
.ot-title {
    margin: 0 0 12px;
    color: #1a1a1a;
    font-weight: 700;
    font-size: 32px;
}
.ot-subtitle {
    color: var(--ot-muted);
    max-width: 600px;
    margin: 0 auto;
    font-size: 15px;
    line-height: 1.6;
}

.ot-form-card {
    background: #ffffff;
    border-radius: 20px;
    padding: 30px;
    box-shadow: 0 2px 20px rgba(0,0,0,0.06);
    border: 1px solid var(--ot-border);
    margin-bottom: 40px;
    max-width: 700px;
    margin-left: auto;
    margin-right: auto;
}

.ot-form {
    display: grid;
    grid-template-columns: 1fr;
    gap: 24px;
}

.ot-group {
    display: grid;
    gap: 10px;
}
.ot-label {
    font-size: 14px;
    color: #1a1a1a;
    font-weight: 500;
}
.ot-input-wrap {
    position: relative;
}
.ot-input-icon {
    position: absolute;
    left: 16px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--ot-muted);
    font-size: 18px;
}
.ot-input {
    width: 100%;
    height: 52px;
    padding: 0 16px 0 46px;
    color: #1a1a1a;
    background: #f8f9fa;
    border: 1px solid var(--ot-border);
    border-radius: 14px;
    outline: none;
    transition: all 0.2s ease;
    font-size: 15px;
}
.ot-input::placeholder { color: var(--ot-muted); }
.ot-input:hover { background: #ffffff; }
.ot-input:focus { 
    background: #ffffff;
    border-color: var(--ot-primary);
    box-shadow: 0 0 0 4px rgba(255, 193, 7, 0.1);
}

.ot-status {
    padding: 40px;
    border-radius: 20px;
    background: rgb(255, 255, 255);
    border: 1px solid var(--ot-border);
}

.ot-steps {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 30px;
    position: relative;
    padding: 0 40px;
}

.ot-steps::before {
    content: "";
    position: absolute;
    top: 6px;
    left: 50px;
    right: 50px;
    height: 3px;
    background: #e9ecef;
    z-index: 0;
}

.ot-step {
    text-align: center;
    color: var(--ot-muted);
    font-size: 14px;
    position: relative;
    z-index: 1;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 8px;
}

.ot-step .dot {
    width: 14px;
    height: 14px;
    border-radius: 999px;
    background: #ffffff;
    border: 2px solid #dee2e6;
    position: relative;
}

.ot-step.active .dot {
    background: var(--ot-primary);
    border-color: var(--ot-primary);
    box-shadow: 0 0 0 4px rgba(255, 193, 7, 0.2);
}

.ot-step.active {
    color: #1a1a1a;
    font-weight: 600;
}

.ot-step.done .dot {
    background: var(--ot-primary);
    border-color: var(--ot-primary);
}

.ot-step.done {
    color: #1a1a1a;
}

.ot-step.cancelled {
    color: var(--ot-danger);
}

.ot-step.cancelled .dot {
    background: var(--ot-danger);
    border-color: var(--ot-danger);
    box-shadow: 0 0 0 4px rgba(220, 53, 69, 0.2);
}

.ot-step-label {
    font-weight: 500;
    margin-bottom: -4px;
}

.ot-step-time {
    font-size: 12px;
    color: var(--ot-muted);
    font-weight: normal;
}

@media (max-width: 991px)  { 
    .ot-container { padding: 40px 20px; }
    .ot-steps { padding: 0 30px; }
    .ot-steps::before { left: 40px; right: 40px; }
}
@media (max-width: 767px)  { 
    .ot-status { padding: 30px 20px; }
    .ot-steps { 
        gap: 15px;
        padding: 0 15px;
    }
    .ot-steps::before { left: 20px; right: 20px; }
    .ot-step { font-size: 13px; }
    .ot-step-time { font-size: 11px; }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="ot-container">
    <div class="ot-hero">
        <h2 class="ot-title">Order Tracking</h2>
        <p class="ot-subtitle">Enter your order details below to check the current status and estimated delivery time</p>
    </div>

    <div class="ot-form-card">
        <form method="GET" action="<?php echo e(route('product.order.track')); ?>" class="ot-form" novalidate>
            <?php if(session('error')): ?>
            <div class="text-danger">
                <i class="ri-error-warning-line"></i>
                <?php echo e(session('error')); ?>

            </div>
            <?php endif; ?>
            <div class="ot-group">
                <label for="email" class="ot-label">Email Address</label>
                <div class="ot-input-wrap">
                    <i class="ri-mail-line ot-input-icon"></i>
                    <input id="email" name="email" type="email" class="ot-input" placeholder="Enter your email address" value="<?php echo e(request('email', auth()->user()->email ?? '')); ?>">
                </div>
            </div>
            <div class="ot-group">
                <label for="order_id" class="ot-label">Order ID</label>
                <div class="ot-input-wrap">
                    <i class="ri-shopping-bag-line ot-input-icon"></i>
                    <input id="order_id" name="order_id" type="text" class="ot-input" placeholder="e.g. SBXXXXXXXX" value="<?php echo e(request('order_id')); ?>">
                </div>
            </div>
            <div class="text-center mt-2">
                <button type="submit" class="mn-btn-1 px-4 py-2">
                    <span class="d-flex align-items-center gap-2">
                        <i class="ri-search-line"></i>
                        Track Now
                    </span>
                </button>
            </div>
        </form>
    </div>

    <?php if(isset($statusInfo)): ?>
    <div class="ot-status">
        <div class="ot-steps">
            <?php
                $currentFound = false;
                $statusTimes = collect($statusInfo['history'])->pluck('timestamp', 'status');
            ?>

            <div class="ot-step <?php echo e($statusInfo['statuses']['pending'] ? 'active' : (!$currentFound && !$statusInfo['statuses']['cancelled'] ? 'done' : '')); ?>">
                <div class="dot"></div>
                <div class="ot-step-label">Order Placed</div>
                <?php if($time = $statusTimes->get('pending')): ?>
                    <div class="ot-step-time"><?php echo e($time); ?></div>
                <?php endif; ?>
            </div>

            <div class="ot-step <?php echo e($statusInfo['statuses']['processing'] ? 'active' : (!$currentFound && !$statusInfo['statuses']['cancelled'] && $statusInfo['current'] !== 'pending' ? 'done' : '')); ?>">
                <div class="dot"></div>
                <div class="ot-step-label">Processing</div>
                <?php if($time = $statusTimes->get('processing')): ?>
                    <div class="ot-step-time"><?php echo e($time); ?></div>
                <?php endif; ?>
            </div>

            <div class="ot-step <?php echo e($statusInfo['statuses']['shipped'] ? 'active' : (!$currentFound && !$statusInfo['statuses']['cancelled'] && !in_array($statusInfo['current'], ['pending', 'processing']) ? 'done' : '')); ?>">
                <div class="dot"></div>
                <div class="ot-step-label">Shipped</div>
                <?php if($time = $statusTimes->get('shipped')): ?>
                    <div class="ot-step-time"><?php echo e($time); ?></div>
                <?php endif; ?>
            </div>

            <div class="ot-step <?php echo e($statusInfo['statuses']['delivered'] ? 'active' : ($statusInfo['statuses']['cancelled'] ? 'cancelled' : '')); ?>">
                <div class="dot"></div>
                <div class="ot-step-label"><?php echo e($statusInfo['statuses']['cancelled'] ? 'Cancelled' : 'Delivered'); ?></div>
                <?php if($time = $statusTimes->get($statusInfo['statuses']['cancelled'] ? 'cancelled' : 'delivered')): ?>
                    <div class="ot-step-time"><?php echo e($time); ?></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('general_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/axesba/public_html/edemo/resources/views/product/order_track.blade.php ENDPATH**/ ?>