<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductController;

Route::get('/my-cart', [ProductController::class, 'cart'])->name('product.cart');
Route::post('/cart/items', [ProductController::class, 'getCartItems'])->name('product.cart.items');
Route::get('/my-cart/checkout', [ProductController::class, 'checkout'])->name('product.checkout');
Route::get('/products', [ProductController::class, 'list'])->name('product.list');
Route::get('/product/{slug}', [ProductController::class, 'view'])->name('product.view');
Route::get('/search/products', [ProductController::class, 'search'])->name('product.search');
// Reviews (AJAX-friendly)
Route::get('/product/{product}/reviews', [ProductController::class, 'reviews'])->name('product.reviews');

// Public Order Tracking page (GET)
Route::get('/order-track', [ProductController::class, 'orderTrack'])->name('product.order.track');
// Public order invoice view (redirect target after payment)
Route::get('/order-invoice/{order_id}', [ProductController::class, 'orderInvoice'])->name('product.order.invoice');
// Retry digital payment for an existing order
Route::get('/order/{order_id}/payment/retry', [ProductController::class, 'retryPayment'])->name('product.payment.retry');

// SSLCommerz callbacks must be PUBLIC (no auth middleware) and CSRF-exempt
Route::any('/payment/sslcommerz/success', [ProductController::class, 'sslSuccess'])->name('payment.ssl.success');
Route::any('/payment/sslcommerz/fail', [ProductController::class, 'sslFail'])->name('payment.ssl.fail');
Route::any('/payment/sslcommerz/cancel', [ProductController::class, 'sslCancel'])->name('payment.ssl.cancel');
Route::post('/payment/sslcommerz/ipn', [ProductController::class, 'sslIpn'])->name('payment.ssl.ipn');

Route::middleware(['auth', 'verified', 'active'])->group(function () {
    Route::post('/wishlist/toggle/{product}', [ProductController::class, 'toggleWishlist'])->name('product.wishlist.toggle');
    Route::get('/wishlist/check/{product}', [ProductController::class, 'checkWishlist'])->name('product.wishlist.check');

    Route::post('/cart/validate-coupon', [ProductController::class, 'validateCoupon'])->name('product.validate.coupon');
    Route::post('/place-order', [ProductController::class, 'placeOrder'])->name('product.place.order');

    // Ratings
    Route::post('/product/{product}/rating', [ProductController::class, 'storeRating'])->name('product.rating.store');
    Route::delete('/product/{product}/rating', [ProductController::class, 'destroyRating'])->name('product.rating.delete');
});