<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ProductExportController;


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Public API secured via API Key (no version prefix)
Route::middleware(['api.key'])->group(function () {
    // Unified endpoints: /api/products/{condition}
    Route::get('/products/all', [ProductExportController::class, 'all']);
    Route::get('/products/title/{title}', [ProductExportController::class, 'showByTitle']);
    Route::get('/products/limit/{limit}', [ProductExportController::class, 'latest'])->whereNumber('limit');

    // Backward-compat route (optional): latest items
    Route::get('/item/{limit}', [ProductExportController::class, 'latest'])->whereNumber('limit');
});