@if ($paginator->hasPages())
    @php
        $maxLinks = 2;
        $current = $paginator->currentPage();
        $last = $paginator->lastPage();
        $start = max(1, min($current - $maxLinks, $last - 2 * $maxLinks));
        $end = min($last, max(2 * $maxLinks + 1, $current + $maxLinks));
    @endphp

    <div class="mn-pro-pagination m-b-15">
        <span>Showing {{ $paginator->firstItem() }} to {{ $paginator->lastItem() }} of {{ $paginator->total() }} item(s)</span>
        <ul class="mn-pro-pagination-inner">
            {{-- Previous Page Link --}}
            <li>
                @if ($paginator->onFirstPage())
                    <span class="disabled"><i class="ri-arrow-left-double-line"></i> Previous</span>
                @else
                    <a href="{{ $paginator->previousPageUrl() }}" class="prev"><i class="ri-arrow-left-double-line"></i> Previous</a>
                @endif
            </li>

            {{-- First Page + Dots --}}
            @if($start > 1)
                <li><a href="{{ $paginator->url(1) }}">1</a></li>
                @if($start > 2)<li><span class="dots">...</span></li>@endif
            @endif

            {{-- Page Numbers --}}
            @foreach(range($start, $end) as $i)
                <li>
                    <a href="{{ $paginator->url($i) }}" class="{{ $i == $current ? 'active' : '' }}">{{ $i }}</a>
                </li>
            @endforeach

            {{-- Last Page + Dots --}}
            @if($end < $last)
                @if($end < $last - 1)<li><span class="dots">...</span></li>@endif
                <li><a href="{{ $paginator->url($last) }}">{{ $last }}</a></li>
            @endif

            {{-- Next Page Link --}}
            <li>
                @if ($paginator->hasMorePages())
                    <a href="{{ $paginator->nextPageUrl() }}" class="next">Next <i class="ri-arrow-right-double-line"></i></a>
                @else
                    <span class="disabled">Next <i class="ri-arrow-right-double-line"></i></span>
                @endif
            </li>
        </ul>
    </div>
@endif