<!DOCTYPE html>
<html lang="en">
<head>
@php
$gaId = isset($appSettings) && $appSettings->google_analytics_id ? $appSettings->google_analytics_id : null;
@endphp
@if($gaId)
<script async src="https://www.googletagmanager.com/gtag/js?id={{ $gaId }}"></script>
<script>
   window.dataLayer = window.dataLayer || [];
   function gtag(){dataLayer.push(arguments);} 
   gtag('js', new Date());
   gtag('config', '{{ $gaId }}');
</script>
@endif
   <meta charset="utf-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <meta name="robots" content="index, follow">
   <meta name="author" content="{{ config('app.name') }}">
   <meta name="description" content="{{ $appSettings->meta_description ?? '' }}">
   <meta name="keywords" content="{{ $appSettings->meta_keywords ?? '' }}">
   <meta name="csrf-token" content="{{ csrf_token() }}">
   @hasSection('meta')
      @yield('meta')
   @else
      <meta property="og:title" content="{{ config('app.name') }}">
      <meta property="og:description" content="{{ $appSettings->meta_description ?? '' }}">
      <meta property="og:image" content="{{ Storage::url($appSettings->site_logo_path) ?? '' }}">
      <meta property="og:url" content="{{ config('app.url') }}">
      <meta property="og:type" content="website">
   @endif
   <link rel="shortcut icon" type="image/x-icon" href="{{ Storage::url($appSettings->favicon_path) ?? '' }}" />
   <link rel="stylesheet" type="text/css" href="{{ asset('css/materialdesignicons.min.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/remixicon.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/bootstrap.min.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/animate.min.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/owl.carousel.min.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/slick.min.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/swiper-bundle.min.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/nouislider.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/style.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/second-navbar.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/header-info.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/header-container.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('css/footer-container.css') }}">


   <title>@yield("title") | {{ config('app.name') }}</title>
   {!! isset($appSettings) && $appSettings->pixel_code ? $appSettings->pixel_code : '' !!}
</head>
<style>
.all-categories-btn {
    background-color: #159abe !important;
}

.toast-container {
    position: fixed;
    top: 20px;
    right: 20px;
    z-index: 9999;
}
.toast {
    background: #fff;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    min-width: 300px;
    margin-bottom: 10px;
}
.toast.success {
    border-left: 4px solid #198754;
}
.toast.error {
    border-left: 4px solid #dc3545;
}
.toast.info {
    border-left: 4px solid #0dcaf0;
}
.toast-header {
    background: transparent;
    border: none;
}
.toast-header .btn-close {
    margin-right: -0.375rem;
}
.toast-body {
    padding: 0.75rem 1.25rem;
    color: #333;
}
.toast-body ul {
    margin-top: 0.5rem;
    margin-bottom: 0;
}
.toast-body ul li {
    font-size: 0.875rem;
    margin-bottom: 0.25rem;
    color: #666;
}
.toast-body ul li:last-child {
    margin-bottom: 0;
}
.mn-add-cart.in-cart {
    background-color: #dc3545 !important;
    border-color: #dc3545 !important;
}
.mn-add-cart.in-cart, .mn-add-cart.in-cart i {
    color: #fff !important;
}
.main-product-cart.in-cart {
    background-color: #dc3545 !important;
    border-color: #dc3545 !important;
}
.main-product-cart.in-cart i {
    color: #fff;
}
.mn-options .mn-add-cart {
    font-size: 13px;
    padding: 8px 12px;
}
.mn-options .mn-add-cart i {
    margin-right: 4px;
}
.variant-name {
    font-size: 0.75rem;
    font-weight: 500;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: calc(100% - 30px);
    display: inline-block;
}
.variant-qty, .variant-price {
    font-size: 0.75rem;
}
.variant-remove {
    font-size: 0.85rem;
}
/* -------------------------------------------------
   Global image normalization
   - Make all product card images uniform (center-cropped square)
   - Unify homepage category tile thumbnails
   - Fix cart sidebar thumbnails sizing
   ------------------------------------------------- */
/* Product cards (used across home, lists, carousels) */
.mn-product-card .mn-product-img .mn-img {
    position: relative;
    overflow: hidden;
    border-radius: 15px;
    /* square frame so all cards are equal height */
    aspect-ratio: 1 / 1;
    background: #fff;
}
.mn-product-card .mn-product-img .mn-img .image {
    width: 100%;
    height: 100%;
}
.mn-product-card .mn-product-img .mn-img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
}

/* Homepage category tiles product thumbs */
.mn-category .mn-cat .mn-cat-card ul {
    display: flex;
    gap: 10px;
}
.mn-category .mn-cat .mn-cat-card ul li {
    width: 72px;
    height: 72px;
    border-radius: 12px;
    overflow: hidden;
}
.mn-category .mn-cat .mn-cat-card ul li img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
}

/* Cart sidebar thumbnails */
.mn-side-cart .mn-cart-inner .mn-cart-pro-items li .mn-pro-img {
    width: 72px;
    height: 72px;
    -webkit-box-flex: 0;
        -ms-flex: 0 0 72px;
            flex: 0 0 72px;
    border-radius: 8px;
    overflow: hidden;
}
.mn-side-cart .mn-cart-inner .mn-cart-pro-items li .mn-pro-img img {
    width: 100% !important;
    height: 100% !important;
    object-fit: cover;
    object-position: center;
    border-radius: 8px;
}
/* Equal-height product cards across grids & carousels */
/* Make every product card a flex column so content can pin to bottom */
.mn-product-card {
    display: flex;
    flex-direction: column;
    height: 100%;
}
.mn-product-box { display: flex; }
.mn-product-box > .mn-product-card { width: 100%; }
.mn-product-card .mn-product-detail {
    display: flex;
    flex-direction: column;
    flex: 1 1 auto;
}
/* Keep meta pinned to bottom for alignment */
.mn-product-card .mn-card-meta { margin-top: auto; }
/* Stabilize the category row height */
.mn-product-card .mn-product-detail .cat { min-height: 18px; }
/* Ensure image link fills frame */
.mn-product-card .mn-product-img .mn-img a.image { display: block; width: 100%; height: 100%; }
/* Owl items should stretch too */
.owl-carousel .mn-product-card { height: 100%; }
/* Enforce same square image frame in Related Products carousel */
.mn-related .mn-product-card .mn-product-img .mn-img { aspect-ratio: 1 / 1; }
.mn-related .mn-product-card .mn-product-img .mn-img a.image { width: 100%; height: 100%; }
.mn-related .mn-product-card .mn-product-img .mn-img img { width: 100%; height: 100%; object-fit: cover; object-position: center; }
/* Fix product title to exactly 2 lines for uniform card height */
.mn-product-card .mn-product-detail h5 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
    text-overflow: ellipsis;
    line-height: 1.4;
    min-height: calc(1.4em * 2);
    max-height: calc(1.4em * 2);
}

/* Header layout overrides to allow wide desktop search */
@media (min-width: 992px) {
  .mn-header .mn-header-items { align-items: center; justify-content: flex-start !important; gap: 12px; }
  .mn-header .mn-header-items .left-header {
      display: flex;
      align-items: center;
      flex: 1 1 auto !important;
      min-width: 0; /* allow child to shrink */
  }
  .mn-header .mn-header-items .right-header { flex: 0 0 auto !important; margin-left: auto !important; }
  .mn-header .mn-header-items .right-header .mn-main-menu { flex: 0 0 auto !important; }
  .mn-header .mn-header-items .right-header .mn-main-menu ul { width: auto !important; }
}

/* Desktop Search Styles */
.desktop-search-container {
    position: relative;
    margin-left: 30px;
    margin-right: 20px;
    flex: 1 1 auto;
    max-width: 600px;
    z-index: 1001;
    flex-direction: column;
    height: 46px;
}

/* Responsive adjustments for 1100-1300px screens */
@media (min-width: 1100px) and (max-width: 1300px) {
    .desktop-search-container {
        max-width: 500px;
    }
}

.desktop-search-container form {
    display: flex;
    width: 100%;
    position: relative;
}

.desktop-search-container input {
    flex: 1;
    height: 46px;
    border-radius: 23px;
    border: 1px solid #e0e0e0;
    padding: 0 50px 0 20px;
    font-size: 14px;
    outline: none;
    transition: all 0.3s ease;
    background-color: #f5f5f5;
    width: 100%;
}

.desktop-search-container input:focus {
    border-color: #159abe;
    box-shadow: 0 0 0 2px rgba(21, 154, 190, 0.1);
}

.desktop-search-container button {
    position: absolute;
    right: 8px;
    top: 8px;
    height: 30px;
    width: 30px;
    border-radius: 50%;
    background: #159abe;
    border: none;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 16px;
}

.desktop-search-container button:hover {
    background: #0f7a96;
}


.desktop-search-overlay {
    position: fixed;
    top: 70px; /* Height of navbar */
    left: 0;
    width: 100%;
    height: calc(100vh - 70px);
    background: rgba(0, 0, 0, 0.5);
    z-index: 16;
    display: none;
}

.desktop-search-results {
    position: absolute;
    top: 100%;
    left: 0;
    width: 100%;
    background: white;
    border-radius: 10px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
    overflow-y: visible;
    display: none;
    border: 1px solid #e0e0e0;
    padding: 8px 0;
    margin-top: 5px;
    z-index: 1000;
    max-width: 100%;
}

.desktop-search-results ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.desktop-search-results li {
    padding: 12px 14px;
    display: flex;
    align-items: center;
    border: 1px solid #eaeaea;
    border-radius: 12px;
    margin: 8px 12px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.04);
    transition: background 0.2s ease, box-shadow 0.2s ease;
}

.desktop-search-results li:last-child {
    border-bottom: none;
}

.desktop-search-results li .mn-pro-img {
    width: 50px;
    height: 50px;
    border-radius: 5px;
    overflow: hidden;
    margin-right: 10px;
}

.desktop-search-results li .mn-pro-img img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.desktop-search-results li .mn-pro-content {
    flex: 1;
}

.desktop-search-results li .search-pro-title {
    display: block;
    font-size: 14px;
    font-weight: 500;
    color: #333;
    margin-bottom: 5px;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 100%;
    white-space: normal;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    line-height: 1.3;
    max-height: 2.6em;
}

.desktop-search-results li .search-price {
    font-size: 13px;
    color: #159abe;
    font-weight: 600;
}

.desktop-search-results li:hover {
    background: #fafafa;
    box-shadow: 0 4px 10px rgba(0,0,0,0.06);
}

/* Show search results when active */
.desktop-search-overlay.active {
    display: block;
}

.desktop-search-results.active {
    display: block;
}

.desktop-search-container.active .desktop-search-results {
    display: block;
}
</style>
@yield("style")
<body>

<!-- Toast Container -->
<div class="toast-container">
    @if(session('success'))
    <div class="toast success align-items-center show" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                <i class="ri-checkbox-circle-line me-1 text-success"></i>
                {{ session('success') }}
            </div>
            <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
    @endif

    @if(session('error'))
    <div class="toast error align-items-center show" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                <i class="ri-error-warning-line me-1 text-danger"></i>
                {{ session('error') }}
            </div>
            <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
    @endif

    @if(session('info'))
    <div class="toast info align-items-center show" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                <i class="ri-information-line me-1 text-info"></i>
                {{ session('info') }}
            </div>
            <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
    @endif

    @if($errors->any())
    <div class="toast error align-items-center show" role="alert" aria-live="assertive" aria-atomic="true">
        <div class="d-flex">
            <div class="toast-body">
                <div class="fw-semibold mb-1"><i class="ri-error-warning-line text-danger"></i> Please fix the following errors:</div>
                <ul class="list-unstyled m-0">
                    @foreach($errors->all() as $error)
                    <li>- {{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
        </div>
    </div>
    @endif
</div>

<main class="wrapper sb-default">
   <!-- Loader -->
   <div id="mn-overlay">
      <div class="loader">
         <img src="{{ Storage::url($appSettings->loader_image_path) }}" alt="loader" width="43px">
         <span class="shape"></span>
      </div>
   </div>
   <!-- Sidebar -->
   <div class="mn-sidebar-overlay"></div>
   <div class="mn-sidebar sidebar-hide">
      <button type="button" class="sb-rail-trigger" title="Open categories"></button>
      <div class="mn-sidebar-header">
         <button type="button" class="side-close" title="Close"></button>
         <div class="all-categories-btn" id="allCategoriesBtn" tabindex="0">
            <div class="hamburger-icon">
               <span></span>
               <span></span>
               <span></span>
            </div>
            <span class="btn-text">All Categories</span>
         </div>
      </div>
      <div class="mn-sidebar-body">
         <ul class="mn-sb-list">
            @foreach(($allCategories ?? []) as $category)
                <li class="mn-sb-item sb-drop-item">
                    <a href="{{ $category->children->isEmpty() ? route('product.list', ['category' => $category->slug]) : 'javascript:void(0)' }}" class="mn-drop-toggle">
                        <img src="{{ asset('storage/' . $category->icon) }}" alt="{{ $category->name }}">
                        <span class="condense">{{ $category->name }}
                            @if(!$category->children->isEmpty())
                                <i class="drop-arrow ri-arrow-down-s-line"></i>
                            @endif
                        </span>
                    </a>
                    @if(!$category->children->isEmpty())
                        <ul class="mn-sb-drop">
                            @foreach($category->children as $child)
                                <li class="list">
                                    <a href="{{ route('product.list', ['category' => $child->slug]) }}" class="mn-page-link drop">{{ $child->name }}</a>
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </li>
            @endforeach
         </ul>
      </div>
   </div>
   <!-- Header -->
   <header>
      <div class="mn-header">
         <div class="header-container">
            <div class="mn-header-items">
            <div class="left-header">
               <a href="javascript:void(0)" class="mn-toggle-sidebar d-none">
			   <div class="hamburger-menu">
				   <span></span>
				   <span></span>
				   <span></span>
			   </div>
               </a>
               	<a href="{{ route('home') }}" class="logo">
			   	<img src="{{ Storage::url($appSettings->site_logo_path) }}" alt="logo">
			   </a>
                <!-- Desktop Search Input - Only visible on desktop/laptop -->
                <div class="desktop-search-container d-none d-lg-flex">
                    <form id="desktopSearchForm" onsubmit="return false;">
                        <input type="text" id="desktopSearchInput" placeholder="Search products..." autocomplete="off">
                        <button type="button" id="desktopSearchButton"><i class="ri-search-line"></i></button>
                    </form>
                    <div class="desktop-search-results">
                        <ul id="desktopSearchResults"></ul>
                    </div>
                </div>
                <div class="desktop-search-overlay"></div>
                
                <!-- Support and Shipping Info -->
                <div class="header-info d-none d-lg-flex">
                    <div class="support-info">
                        <i class="ri-customer-service-2-line"></i>
                        <div class="info-content">
                            <span class="info-label">24/7 Support</span>
                            <span class="info-value"><a href="tel:{{ $appSettings->contact_phone ?? '' }}">{{ $appSettings->contact_phone ?? '' }}</a></span>
                        </div>
                    </div>
                    <div class="shipping-info">
                        <i class="ri-mail-line"></i>
                        <div class="info-content">
                            <span class="info-label">Email Us</span>
                            <span class="info-value"><a href="mailto:{{ $appSettings->contact_email ?? '' }}">{{ $appSettings->contact_email ?? '' }}</a></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="right-header">
            <div class="mn-mobile-menu-overlay"></div>
				<div id="mn-mobile-menu" class="mn-mobile-menu">
					<div class="mn-menu-title">
						<span class="menu_title">My Menu</span>
						<button type="button" class="mn-close-menu">×</button>
					</div>
					<div class="mn-menu-inner">
						<div class="mn-menu-content">
							<ul>
                                <li>
                                    <a href="{{ route('best.deals') }}">Best Deals</a>
                                </li>
                                <li>
                                    <a href="{{ route('contact') }}">Contact</a>
                                </li>
                                <li>
                                    <a href="{{ route('blog.index') }}">Blogs</a>
                                </li>
                                <li>
                                    <a href="{{ route('compare') }}">Compare</a>
                                </li>
                                <li>
                                    <a href="{{ route('pc.builder') }}">PC Builder</a>
                                </li>
                        @auth
                        <li>
                           <div class="divider_dark"></div>
                        </li>
                        @if(auth()->user()->role === 'admin')
                        <li>
                           <a href="{{ route('admin.dashboard') }}">Admin Dashboard</a>
                        </li>
                        @endif
                        <li>
                           <a href="{{ route('account') }}">My Account</a>
                        </li>
                        <li>
                           <a href="{{ route('user.orders') }}">My Orders</a>
                        </li>
                        <li>
                           <a href="{{ route('user.orders') }}">Track Order</a>
                        </li>
                        <li>
                           <a href="{{ route('wishlist') }}">Wishlist</a>
                        </li>
                        <li>
                           <a href="javascript:void(0)" onclick="event.preventDefault(); document.getElementById('logout_form').submit();">Logout</a>
                        </li>
                        <form id="logout_form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                        @endauth
							</ul>
						</div>

						<div class="header-res-lan-curr">
							<!-- Social Start -->
							<div class="header-res-social">
								<div class="header-top-social">
									<ul class="mb-0">
                                        @php $socialMedia = $appSettings->social_media ?? []; @endphp
                                        @forelse($socialMedia as $social)
                                            <li class="list-inline-item">
                                                <a href="{{ $social['url'] }}" target="_blank"><i class="{{ $social['platform'] }}"></i></a>
                                            </li>
                                        @empty
                                        @endforelse
									</ul>
								</div>
							</div>
							<!-- Social End -->
						</div>
					</div>
				</div>
               <!-- Mobile search icon -->
               <div class="mn-tool-icons">
                    <div class="mn-tool-search d-lg-none">
                        <a href="javascript:void(0)" class="mn-main-search mn-search-toggle">
                            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="512" height="512" x="0"
                            y="0" viewBox="0 0 612.01 612.01" style="enable-background:new 0 0 512 512"
                            xml:space="preserve">
                            <g>
                                <path
                                    d="M606.209 578.714 448.198 423.228C489.576 378.272 515 318.817 515 253.393 514.98 113.439 399.704 0 257.493 0S.006 113.439.006 253.393s115.276 253.393 257.487 253.393c61.445 0 117.801-21.253 162.068-56.586l158.624 156.099c7.729 7.614 20.277 7.614 28.006 0a19.291 19.291 0 0 0 .018-27.585zM257.493 467.8c-120.326 0-217.869-95.993-217.869-214.407S137.167 38.986 257.493 38.986c120.327 0 217.869 95.993 217.869 214.407S377.82 467.8 257.493 467.8z"
                                    fill="#000000" opacity="1" data-original="#000000"></path>
                            </g>
                            </svg>
                        </a>
                    </div>
               </div>
            </div>
         </div>
         </div>
      </header>
      
      <!-- Second Navbar - Only visible on desktop -->
      <div class="second-navbar d-none d-lg-block">
         <div class="container">
            <!-- Category Toggler (opens sidebar) -->
            <div class="second-nav-categories">
               <button type="button" class="category-toggler" id="categoryToggler">
                  <div class="hamburger-icon">
                     <span></span>
                     <span></span>
                     <span></span>
                  </div>
                  <span>All Categories</span>
               </button>
            </div>
            
            <!-- Navigation Links -->
            <ul class="second-navbar-nav">
               <li><a href="{{ route('best.deals') }}">Best Deals</a></li>
               <li><a href="{{ route('blog.index') }}">Blog</a></li>
               <li><a href="{{ route('pc.builder') }}">PC Builder</a></li>
            </ul>
            
            <!-- Right Side Elements -->
            <div class="second-navbar-right">
               <div class="nav-item">
                  <a href="{{ route('contact') }}" class="nav-link">
                     <i class="ri-customer-service-2-line"></i> Support
                  </a>
               </div>
               <div class="nav-item">
                  <a href="{{ route('product.order.track') }}" class="nav-link">
                     <i class="ri-truck-line"></i> Track Order
                  </a>
               </div>
               
               <!-- User Account Icon -->
               <div class="nav-item nav-icon-item">
                  @auth
                  <a href="javascript:void(0)" class="nav-link nav-icon">
                     <i class="ri-user-3-line"></i>
                  </a>
                  <ul class="sub-menu">
                     @if(auth()->user()->role === 'admin')
                     <li>
                        <a href="{{ route('admin.dashboard') }}">Admin Dashboard</a>
                     </li>
                     <li>
                        <div class="divider"></div>
                     </li>
                     @endif
                     <li>
                        <a href="{{ route('account') }}">My Account</a>
                     </li>
                     <li>
                        <div class="divider"></div>
                     </li>
                     <li>
                        <a href="{{ route('user.orders') }}">My Orders</a>
                     </li>
                     <li>
                        <div class="divider"></div>
                     </li>
                     <li>
                        <a href="{{ route('wishlist') }}">Wishlist</a>
                     </li>
                     <li>
                        <div class="divider"></div>
                     </li>
                     <li>
                        <a href="javascript:void(0)" onclick="event.preventDefault(); document.getElementById('logout_form_header').submit();">Logout</a>
                     </li>
                  </ul>
                  <form id="logout_form_header" action="{{ route('logout') }}" method="POST" class="d-none">
                      @csrf
                  </form>
                  @else
                  <a href="{{ route('login') }}" class="nav-link nav-icon">
                     <i class="ri-user-3-line"></i>
                  </a>
                  @endauth
               </div>
               
               <!-- Wishlist Icon -->
               <div class="nav-item nav-icon-item">
                  <a href="{{ route('wishlist') }}" class="nav-link nav-icon">
                     <i class="ri-heart-3-line"></i>
                  </a>
               </div>
               
               <!-- Compare Icon -->
               <div class="nav-item nav-icon-item">
                  <a href="{{ route('compare') }}" class="nav-link nav-icon">
                     <span class="label lbl-2 compare-count">0</span>
                     <i class="ri-repeat-line"></i>
                  </a>
               </div>
               
               <!-- Cart Icon -->
               <div class="nav-item nav-icon-item">
                  <a href="javascript:void(0);" class="nav-link nav-icon mn-cart-toggle">
                     <span class="label lbl-2 cart-count">0</span>
                     <i class="ri-shopping-cart-2-line"></i>
                  </a>
               </div>
            </div>
         </div>
      </div>
      
      <!-- Main Content -->
      <div class="mn-main-content">
      @yield("content")
      </div>
   </div>
   <!-- Header + Content Container End -->
   <!-- Footer -->
   <footer class="m-t-15 footer_container" style="width: 100% !important; background-color: #f8f9fa;">
      <div class="mn-footer" style="width: 100% !important; padding: 0 15px !important;">
         <div class="footer-container" style="max-width: 1380px !important; width: 100% !important; margin: 0 auto !important;">
            <div class="footer-top p-tb-30">
               <div class="row m-minus-991">
                  <div class="col-sm-12 col-lg-3 mn-footer-cat">
                     <div class="mn-footer-widget mn-footer-company">
                        <img src="{{ Storage::url($appSettings->site_logo_path) }}" class="mn-footer-dark-logo" alt="logo">
                        <p class="mn-footer-detail">{{ $appSettings->footer_description ?? '' }}
                        </p>
                     </div>
                  </div>
                  <div class="col-sm-12 col-lg-2 mn-footer-info">
                     <div class="mn-footer-widget">
                        <h4 class="mn-footer-heading">Popular Categories</h4>
                        <div class="mn-footer-links mn-footer-dropdown">
                           <ul class="align-items-center">
                             @foreach($topCategories as $category)
                             <li class="mn-footer-link">
                                <a href="{{ route('product.list', ['category' => $category->slug]) }}">
                                   {{ $category->name }}
                                   @if(!empty($category->total_products) && $category->total_products > 0)
                                       <small class="text-muted">({{ $category->total_products }})</small>
                                   @endif
                                </a>
                             </li>
                             @endforeach
                           </ul>
                        </div>
                     </div>
                  </div>
                  <div class="col-sm-12 col-lg-2 mn-footer-account">
                        <div class="mn-footer-widget">
                           <h4 class="mn-footer-heading">Account</h4>
                           <div class="mn-footer-links mn-footer-dropdown">
                              <ul class="align-items-center">
                                 <li class="mn-footer-link">
                                    <a href="{{ route('account') }}">My Account</a>
                                 </li>
                                 <li class="mn-footer-link">
                                    <a href="{{ route('user.orders') }}">Orders</a>
                                 </li>
                                 <li class="mn-footer-link">
                                    <a href="{{ route('wishlist') }}">Wishlist</a>
                                 </li>
                                 <li class="mn-footer-link">
                                    <a href="{{ route('product.order.track') }}">Track Order</a>
                                 </li>
                                 <li class="mn-footer-link">
                                    <a href="{{ route('compare') }}">Compare</a>
                                 </li>
                                 <li class="mn-footer-link">
                                    <a href="{{ route('pc.builder') }}">PC Builder</a>
                                 </li>
                              </ul>
                           </div>
                        </div>
                  </div>
                  <div class="col-sm-12 col-lg-2 mn-footer-service">
                     <div class="mn-footer-widget">
                        <h4 class="mn-footer-heading">Company</h4>
                        <div class="mn-footer-links mn-footer-dropdown">
                           <ul class="align-items-center">
                              @foreach($pages as $page)
                              <li class="mn-footer-link">
                                 <a href="{{ route('page', $page->slug) }}">{{ $page->name }}</a>
                              </li>
                              @endforeach                              
                              <li class="mn-footer-link">
                                 <a href="{{ route('contact') }}">Contact or Support</a>
                              </li>
                              <li class="mn-footer-link">
                                 <a href="{{ route('faq') }}">FAQ</a>
                              </li>
                           </ul>
                        </div>
                     </div>
                  </div>
                  <div class="col-sm-12 col-lg-3 mn-footer-cont-social">
                     <div class="mn-footer-contact">
                        <div class="mn-footer-widget">
                           <h4 class="mn-footer-heading">Contact</h4>
                           <div class="mn-footer-links mn-footer-dropdown">
                              <ul class="align-items-center">
                                 <li class="mn-footer-link mn-foo-location">
                                    <span class="mt-15px">
                                    <i class="ri-map-pin-line"></i>
                                    </span>
                                    <p>{{ $appSettings->contact_address ?? '' }}
                                    </p>
                                 </li>
                                 <li class="mn-footer-link mn-foo-call">
                                    <span>
                                    <i class="ri-phone-line"></i>
                                    </span>
                                    <a href="tel:{{ $appSettings->contact_phone ?? '' }}">{{ $appSettings->contact_phone ?? '' }}</a>
                                 </li>
                                 <li class="mn-footer-link mn-foo-mail">
                                    <span>
                                    <i class="ri-mail-line"></i>
                                    </span>
                                    <a href="mailto:{{ $appSettings->contact_email ?? '' }}">{{ $appSettings->contact_email ?? '' }}</a>
                                 </li>
                              </ul>
                           </div>
                        </div>
                     </div>
                     <div class="mn-footer-social">
                        <div class="mn-footer-widget">
                           <div class="mn-footer-links mn-footer-dropdown">
                              <ul class="align-items-center">
                                 @forelse($socialMedia as $social)
                                    <li class="mn-footer-link">
                                       <a href="{{ $social['url'] }}" target="_blank"><i class="{{ $social['platform'] }}"></i></a>
                                    </li>
                                 @empty
                                 @endforelse
                              </ul>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="text-center mt-5">
                    <img src="{{ asset('assets/pay_with_icons.png') }}" class="img-fluid" alt="available payment methods" style="width:1000px;max-width:100%;">
                  </div>
               </div>
            </div>
            <div class="footer-bottom">
               <div class="mn-copy">{{ $appSettings->footer_copyright ?? ('© '.date('Y').' '.config('app.name').' | All Rights Reserved.') }}</div>
            </div>
         </div>
      </div>
   </footer>
   <!-- Footer Nav For Mobile -->
   <div class="mn-footer-nav">
      <ul>
         <li>
            <a href="javascript:void(0);" class="mn-main-search mn-search-toggle">
               <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="512" height="512" x="0" y="0"
                  viewBox="0 0 612.01 612.01" style="enable-background:new 0 0 512 512" xml:space="preserve">
                  <g>
                     <path
                        d="M606.209 578.714 448.198 423.228C489.576 378.272 515 318.817 515 253.393 514.98 113.439 399.704 0 257.493 0S.006 113.439.006 253.393s115.276 253.393 257.487 253.393c61.445 0 117.801-21.253 162.068-56.586l158.624 156.099c7.729 7.614 20.277 7.614 28.006 0a19.291 19.291 0 0 0 .018-27.585zM257.493 467.8c-120.326 0-217.869-95.993-217.869-214.407S137.167 38.986 257.493 38.986c120.327 0 217.869 95.993 217.869 214.407S377.82 467.8 257.493 467.8z"
                        fill="#000000" opacity="1" data-original="#000000"></path>
                  </g>
               </svg>
            </a>
         </li>
         <li>
            <a href="{{ auth()->check() ? route('account') : route('login') }}" class="mn-main-user">
               <svg class="svg-icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg">
                  <path
                     d="M512.476 648.247c-170.169 0-308.118-136.411-308.118-304.681 0-168.271 137.949-304.681 308.118-304.681 170.169 0 308.119 136.411 308.119 304.681C820.594 511.837 682.645 648.247 512.476 648.247L512.476 648.247zM512.476 100.186c-135.713 0-246.12 109.178-246.12 243.381 0 134.202 110.407 243.381 246.12 243.381 135.719 0 246.126-109.179 246.126-243.381C758.602 209.364 648.195 100.186 512.476 100.186L512.476 100.186zM935.867 985.115l-26.164 0c-9.648 0-17.779-6.941-19.384-16.35-2.646-15.426-6.277-30.52-11.142-44.95-24.769-87.686-81.337-164.13-159.104-214.266-63.232 35.203-134.235 53.64-207.597 53.64-73.555 0-144.73-18.537-208.084-53.922-78 50.131-134.75 126.68-159.564 214.549 0 0-4.893 18.172-11.795 46.4-2.136 8.723-10.035 14.9-19.112 14.9L88.133 985.116c-9.415 0-16.693-8.214-15.47-17.452C91.698 824.084 181.099 702.474 305.51 637.615c58.682 40.472 129.996 64.267 206.966 64.267 76.799 0 147.968-23.684 206.584-63.991 124.123 64.932 213.281 186.403 232.277 329.772C952.56 976.901 945.287 985.115 935.867 985.115L935.867 985.115z">
                  </path>
               </svg>
            </a>
         </li>
         <li>
            <a href="{{ route('home') }}" class="mn-toggle-menu">
               <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="512" height="512" x="0" y="0"
                  viewBox="0 0 24 24" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                  <g>
                     <path
                        d="M19 22.42H5c-2.07 0-3.75-1.68-3.75-3.75v-8.44c0-1.22.6-2.37 1.6-3.07l7-4.9c1.29-.9 3.02-.9 4.3 0l7 4.9c1 .7 1.6 1.85 1.6 3.07v8.44c0 2.07-1.68 3.75-3.75 3.75zM12 3.08c-.45 0-.9.14-1.29.41l-7 4.9c-.6.42-.96 1.11-.96 1.84v8.44c0 1.24 1.01 2.25 2.25 2.25h14c1.24 0 2.25-1.01 2.25-2.25v-8.44c0-.73-.36-1.42-.96-1.84l-7-4.9c-.39-.27-.84-.4-1.29-.4z"
                        fill="#000000" opacity="1" data-original="#000000"></path>
                     <path
                        d="M16 22.42H8c-.41 0-.75-.34-.75-.75v-5c0-2.62 2.13-4.75 4.75-4.75s4.75 2.13 4.75 4.75v5c0 .41-.34.75-.75.75zm-7.25-1.5h6.5v-4.25c0-1.79-1.46-3.25-3.25-3.25s-3.25 1.46-3.25 3.25z"
                        fill="#000000" opacity="1" data-original="#000000"></path>
                  </g>
               </svg>
            </a>
         </li>
         <li>
            <a href="{{ route('wishlist') }}" class="mn-main-wishlist">
               <svg xmlns="http://www.w3.org/2000/svg" version="1.1" width="512" height="512" x="0" y="0"
                  viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve">
                  <g>
                     <path
                        d="M474.644 74.27C449.391 45.616 414.358 29.836 376 29.836c-53.948 0-88.103 32.22-107.255 59.25-4.969 7.014-9.196 14.047-12.745 20.665-3.549-6.618-7.775-13.651-12.745-20.665-19.152-27.03-53.307-59.25-107.255-59.25-38.358 0-73.391 15.781-98.645 44.435C13.267 101.605 0 138.213 0 177.351c0 42.603 16.633 82.228 52.345 124.7 31.917 37.96 77.834 77.088 131.005 122.397 19.813 16.884 40.302 34.344 62.115 53.429l.655.574c2.828 2.476 6.354 3.713 9.88 3.713s7.052-1.238 9.88-3.713l.655-.574c21.813-19.085 42.302-36.544 62.118-53.431 53.168-45.306 99.085-84.434 131.002-122.395C495.367 259.578 512 219.954 512 177.351c0-39.138-13.267-75.746-37.356-103.081zM309.193 401.614c-17.08 14.554-34.658 29.533-53.193 45.646-18.534-16.111-36.113-31.091-53.196-45.648C98.745 312.939 30 254.358 30 177.351c0-31.83 10.605-61.394 29.862-83.245C79.34 72.007 106.379 59.836 136 59.836c41.129 0 67.716 25.338 82.776 46.594 13.509 19.064 20.558 38.282 22.962 45.659a15 15 0 0 0 28.524 0c2.404-7.377 9.453-26.595 22.962-45.66 15.06-21.255 41.647-46.593 82.776-46.593 29.621 0 56.66 12.171 76.137 34.27C471.395 115.957 482 145.521 482 177.351c0 77.007-68.745 135.588-172.807 224.263z"
                        fill="#000000" opacity="1" data-original="#000000"></path>
                  </g>
               </svg>
            </a>
         </li>
         <li>
            <a href="javascript:void(0);" class="mn-main-cart mn-cart-toggle">
               <span class="label lbl-2 cart-count">0</span>
               <svg class="svg-icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg">
                  <path
                     d="M351.552 831.424c-35.328 0-63.968 28.64-63.968 63.968 0 35.328 28.64 63.968 63.968 63.968 35.328 0 63.968-28.64 63.968-63.968C415.52 860.064 386.88 831.424 351.552 831.424L351.552 831.424 351.552 831.424 351.552 831.424zM799.296 831.424c-35.328 0-63.968 28.64-63.968 63.968 0 35.328 28.64 63.968 63.968 63.968 35.328 0 63.968-28.64 63.968-63.968C863.264 860.064 834.624 831.424 799.296 831.424L799.296 831.424 799.296 831.424zM862.752 799.456 343.264 799.456c-46.08 0-86.592-36.448-92.224-83.008L196.8 334.592 165.92 156.128c-1.92-15.584-16.128-28.288-29.984-28.288L95.2 127.84c-17.664 0-32-14.336-32-31.968 0-17.664 14.336-32 32-32l40.736 0c46.656 0 87.616 36.448 93.28 83.008l30.784 177.792 54.464 383.488c1.792 14.848 15.232 27.36 28.768 27.36l519.488 0c17.696 0 32 14.304 32 31.968S880.416 799.456 862.752 799.456L862.752 799.456zM383.232 671.52c-16.608 0-30.624-12.8-31.872-29.632-1.312-17.632 11.936-32.928 29.504-34.208l433.856-31.968c15.936-0.096 29.344-12.608 31.104-26.816l50.368-288.224c1.28-10.752-1.696-22.528-8.128-29.792-4.128-4.672-9.312-7.04-15.36-7.04L319.04 223.84c-17.664 0-32-14.336-32-31.968 0-17.664 14.336-31.968 32-31.968l553.728 0c24.448 0 46.88 10.144 63.232 28.608 18.688 21.088 27.264 50.784 23.52 81.568l-50.4 288.256c-5.44 44.832-45.92 81.28-92 81.28L385.6 671.424C384.8 671.488 384 671.52 383.232 671.52L383.232 671.52zM383.232 671.52">
                  </path>
               </svg>
            </a>
         </li>
      </ul>
   </div>

   <!-- Search Sidebar -->
   <div class="mn-side-search-overlay"></div>
   <div class="mn-side-search">
      <div class="mn-search-inner">
         <div class="mn-search-title">
            <span class="search_title">Search</span>
            <a href="javascript:void(0)" class="mn-search-close">
            <i class="ri-close-line"></i>
            </a>
         </div>
         <div class="mn-search">
            <form id="searchForm" onsubmit="return false;">
               <input type="text" id="searchInput" placeholder="Search here..." autocomplete="off">
               <a href="javascript:void(0)" id="searchButton"><i class="ri-search-line"></i></a>
            </form>
         </div>
         <div class="mn-search-list">
            <ul class="mn-search-pro-items" id="searchResults">
               <!-- Search results will be populated here -->
            </ul>
         </div>
      </div>
   </div>
   <!-- Cart sidebar Start -->
   <div class="mn-side-cart-overlay"></div>
   <div id="mn-side-cart" class="mn-side-cart">
      <div class="mn-cart-inner">
         <div class="mn-cart-top">
            <div class="mn-cart-title">
               <span class="cart_title">My Cart</span>
               <a href="javascript:void(0)" class="mn-cart-close">
               <i class="ri-close-line"></i>
               </a>
            </div>
            <ul class="mn-cart-pro-items">
               <li class="cart-sidebar-list">
                  <a href="product-detail.html" class="mn-pro-img">
                     <img src="assets/img/product/11.jpg">
                  </a>
                  <div class="mn-pro-content">
                     <a href="product-detail.html" class="cart-pro-title">Smart watch</a>
                     <span class="cart-price"><span>$255.00</span> x 1</span>
                     <a href="javascript:void(0)" class="cart-remove-item">×</a>
                  </div>
               </li>
            </ul>
         </div>
         <div class="mn-cart-bottom">
            <div class="cart-sub-total">
                <table class="table cart-table">
                    <tbody>
                        <tr>
                            <td class="text-left fw-medium">Total :</td>
                            <td class="text-right primary-color fw-medium">৳${Math.round(totals.total)}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="cart_btn">
                <a href="{{ route('product.cart') }}" class="mn-btn-2"><span>Cart<i class="ri-arrow-right-s-line"></i></span></a>
            </div>
         </div>
      </div>
   </div>
@php $tawk = config('services.tawk.key'); @endphp
@if($tawk)
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
 s1.async=true;
 s1.src='https://embed.tawk.to/{{ $tawk }}';
 s1.charset='UTF-8';
 s1.setAttribute('crossorigin','*');
 s0.parentNode.insertBefore(s1,s0);
})();
</script>
@endif
</main>

   <script src="{{ asset('js/jquery.min.js') }}"></script>
   <script src="{{ asset('js/bootstrap.bundle.min.js') }}"></script>
   <script src="{{ asset('js/owl.carousel.min.js') }}"></script>
   <script src="{{ asset('js/second-navbar.js') }}"></script>
   <script src="{{ asset('js/slick.min.js') }}"></script>
   <script src="{{ asset('js/swiper-bundle.min.js') }}"></script>
   <script src="{{ asset('js/infiniteslidev2.js') }}"></script>
   <script src="{{ asset('js/nouislider.js') }}"></script>
   <script src="{{ asset('js/smoothscroll.min.js') }}"></script>
   <script src="{{ asset('js/jquery.zoom.min.js') }}"></script>
   <script src="{{ asset('js/script.js') }}"></script>
   <script src="{{ asset('js/compare.js') }}"></script>
   <script>
// Global variables
const cartKey = 'sb_cart';
let cart = JSON.parse(localStorage.getItem(cartKey) || '[]');
const CART_UPDATED_EVENT = 'cartUpdated';

document.addEventListener('DOMContentLoaded', function() {
    // Initialize all toasts
    var toasts = document.querySelectorAll('.toast');
    toasts.forEach(function(toast) {
        setTimeout(function() {
            var bsToast = new bootstrap.Toast(toast, {
                autohide: true,
                delay: 5000
            });
            bsToast.show();
        }, 100);
    });

    // Initialize cart
    cart = JSON.parse(localStorage.getItem(cartKey) || '[]');
    updateCartCount();
    updateCartButtons();

    // Initialize wishlist
    initializeWishlist();

    // Initialize product quantity controls
    initializeQuantityControls();

    // Initialize variation controls
    initializeVariationControls();

    // Initialize cart sidebar
    initializeCartSidebar();

    // Initialize cart buttons
    initializeCartButtons();
});

// Wishlist Functions
function initializeWishlist() {
    // Check wishlist status for all wishlist buttons
    $('.mn-wishlist').each(function() {
        const productId = $(this).data('product-id');
        if (productId) {
            checkWishlistStatus(productId);
        }
    });

    // Handle wishlist toggle
    $('.mn-wishlist').on('click', function() {
        const productId = $(this).data('product-id');
        if (productId) {
            toggleWishlist(productId);
        }
    });
}

function checkWishlistStatus(productId) {
    $.get(`/wishlist/check/${productId}`)
        .done(function(response) {
            updateWishlistUI(productId, response.in_wishlist);
        });
}

function toggleWishlist(productId) {
    $.ajax({
        url: `/wishlist/toggle/${productId}`,
        type: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                updateWishlistUI(productId, response.in_wishlist);
                if (response.message) {
                    showNotification(response.message, 'success');
                }
            }
        },
        error: function(xhr) {
            if (xhr.status === 401) {
                showNotification('Please login to add items to wishlist', 'warning');
            } else if (xhr.responseJSON && xhr.responseJSON.message) {
                showNotification(xhr.responseJSON.message, 'error');
            } else {
                showNotification('Error updating wishlist. Please try again.', 'error');
            }
            console.error('Wishlist Error:', xhr.responseJSON || xhr.statusText);
        }
    });
}

function updateWishlistUI(productId, inWishlist) {
    $(`.mn-wishlist[data-product-id="${productId}"]`).each(function() {
        const icon = $(this).find('i');
        if (inWishlist) {
            icon.removeClass('ri-heart-line').addClass('ri-heart-fill');
        } else {
            icon.removeClass('ri-heart-fill').addClass('ri-heart-line');
        }
    });
}

// Cart Functions
function dispatchCartUpdate() {
    window.dispatchEvent(new CustomEvent(CART_UPDATED_EVENT));
}

function isProductInCart(productId) {
    return cart.some(item => item.productId === productId);
}

function isInCart(productId, variantId) {
    return cart.some(item => item.productId === productId && item.variantId === variantId);
}

function updateCartCount() {
    const uniqueProductIds = [...new Set(cart.map(item => item.productId))];
    const productCount = uniqueProductIds.length;
    document.querySelectorAll('.cart-count').forEach(el => {
        el.textContent = productCount;
    });
}

function updateCartButtons() {
    // Update list/related product buttons
    document.querySelectorAll('.mn-add-cart:not(.main-product-cart)').forEach(button => {
        // Skip update for special buttons
        if (button.classList.contains('open-link') || button.classList.contains('out-stock') || button.classList.contains('disabled')) {
            return;
        }

        const productCard = button.closest('[data-product-id]');
        if (!productCard) return;

        const productId = productCard.dataset.productId;

        if (isProductInCart(productId)) {
            button.classList.add('in-cart');
            button.innerHTML = '<i class="ri-shopping-cart-line" style="color: #666;"></i>Remove';
        } else {
            button.classList.remove('in-cart');
            button.innerHTML = '<i class="ri-shopping-cart-line" style="color: #666;"></i>Add to Cart';
        }
    });

    // Update main product variation buttons if on product view page
    const variationList = document.querySelector('.mn-pro-variation-content');
    if (variationList) {
        const productId = document.querySelector('[data-product-id]')?.dataset.productId;
        if (productId) {
            const mainCartBtn = document.querySelector('.main-product-cart');
            const activeVariation = document.querySelector('.mn-pro-variation-content li.active');
            
            if (mainCartBtn && activeVariation) {
                const variantId = activeVariation.dataset.variationId;
                if (isInCart(productId, variantId)) {
                    mainCartBtn.innerHTML = '<span><i class="ri-shopping-cart-line me-1"></i>Remove from Cart</span>';
                    mainCartBtn.classList.add('in-cart');
                } else {
                    mainCartBtn.innerHTML = '<span><i class="ri-shopping-cart-line me-1"></i>Add to Cart</span>';
                    mainCartBtn.classList.remove('in-cart');
                }
            }
        }
    }
}

function addToCart(productId, variantId, quantity = 1, isMainProduct = false) {
    if (isMainProduct) {
        // Product view page - handle single variant
        const existingItemIndex = cart.findIndex(item => 
            item.productId === productId && item.variantId === variantId
        );

        if (existingItemIndex > -1) {
            cart.splice(existingItemIndex, 1);
            showNotification('Product removed from cart', 'success');
        } else {
            cart.push({ productId, variantId, quantity: parseInt(quantity) });
            showNotification('Product added to cart successfully', 'success');
        }
        // Reset quantity to 1 on product view page
        const qtyField = document.querySelector('.qty-input');
        if (qtyField) qtyField.value = '1';
    } else {
        // List/Related pages - handle entire product
        if (isProductInCart(productId)) {
            cart = cart.filter(item => item.productId !== productId);
            showNotification('Product removed from cart', 'success');
        } else {
            cart.push({ productId, variantId, quantity: parseInt(quantity) });
            showNotification('Product added to cart successfully', 'success');
        }
    }

    localStorage.setItem(cartKey, JSON.stringify(cart));
    updateCartCount();
    updateCartButtons();
    dispatchCartUpdate();
}

// Quantity Controls
function initializeQuantityControls() {
    // Handle quantity controls for all products
    document.querySelectorAll('.qty-plus-minus').forEach(container => {
        const qtyInput = container.querySelector('.qty-input');
        const qtyPlus = container.querySelector('.qty-plus');
        const qtyMinus = container.querySelector('.qty-minus');

        if (qtyInput && qtyPlus && qtyMinus) {
            // Handle plus button click
            qtyPlus.addEventListener('click', () => {
                const currentQty = parseInt(qtyInput.value) || 1;
                const maxStock = parseInt(qtyInput.dataset.maxStock || '999999');
                if (currentQty < maxStock) {
                    qtyInput.value = currentQty + 1;
                }
            });

            // Handle minus button click
            qtyMinus.addEventListener('click', () => {
                const currentQty = parseInt(qtyInput.value) || 1;
                if (currentQty > 1) {
                    qtyInput.value = currentQty - 1;
                }
            });

            // Prevent manual input
            qtyInput.addEventListener('keydown', (e) => {
                e.preventDefault();
            });
        }
    });
}

// Variation Controls
function initializeVariationControls() {
    const variationItems = document.querySelectorAll('.mn-pro-variation-content li');
    const stockBarEl = document.querySelector('.stock-bar');
    const stockStatusEl = document.querySelector('.status-indicator');
    const addToCartBtn = document.querySelector('.main-product-cart');
    const priceEl = document.querySelector('.final-price');
    const mrpEl = document.querySelector('.mrp');
    const qtyInput = document.querySelector('.qty-input');

    if (variationItems.length) {
        variationItems.forEach(item => {
            item.addEventListener('click', function() {
                // Remove active class from all items
                variationItems.forEach(i => i.classList.remove('active'));
                
                // Add active class to clicked item
                this.classList.add('active');
                
                // Get variation data
                const variation = {
                    id: this.dataset.variationId,
                    in_stock: parseInt(this.dataset.inStock),
                    sale_price: parseFloat(this.dataset.salePrice),
                    regular_price: parseFloat(this.dataset.regularPrice)
                };
                
                // Update UI
                updateVariationUI(variation);
            });
        });

        // Initialize with default variation
        const defaultVariation = document.querySelector('.mn-pro-variation-content li.active');
        if (defaultVariation) {
            const variation = {
                id: defaultVariation.dataset.variationId,
                in_stock: parseInt(defaultVariation.dataset.inStock),
                sale_price: parseFloat(defaultVariation.dataset.salePrice),
                regular_price: parseFloat(defaultVariation.dataset.regularPrice)
            };
            updateVariationUI(variation);
        }
    }
}

function updateVariationUI(variation) {
    const stockBarEl = document.querySelector('.stock-bar');
    const stockStatusEl = document.querySelector('.status-indicator');
    const addToCartBtn = document.querySelector('.main-product-cart');
    const priceEl = document.querySelector('.final-price');
    const mrpEl = document.querySelector('.mrp');
    const qtyInput = document.querySelector('.qty-input');

    if (!stockBarEl || !stockStatusEl || !addToCartBtn || !priceEl || !mrpEl || !qtyInput) return;

    // Update stock UI
    if (variation.in_stock <= 0) {
        stockBarEl.className = 'stock-bar out';
        stockStatusEl.className = 'status-indicator out-of-stock';
        stockStatusEl.querySelector('span').textContent = 'Sorry, Out of Stock';
    } else if (variation.in_stock <= 5) {
        stockBarEl.className = 'stock-bar low';
        stockStatusEl.className = 'status-indicator in-stock';
        stockStatusEl.querySelector('span').textContent = 'We have a few left';
    } else if (variation.in_stock <= 10) {
        stockBarEl.className = 'stock-bar medium';
        stockStatusEl.className = 'status-indicator in-stock';
        stockStatusEl.querySelector('span').textContent = 'Low Stock';
    } else {
        stockBarEl.className = 'stock-bar high';
        stockStatusEl.className = 'status-indicator in-stock';
        stockStatusEl.querySelector('span').textContent = 'In Stock';
    }

    // Update quantity input max
    qtyInput.dataset.maxStock = variation.in_stock;
    if (parseInt(qtyInput.value) > variation.in_stock) {
        qtyInput.value = '1';
    }

    // Update add to cart button
    addToCartBtn.disabled = variation.in_stock <= 0;

    // Update price
    priceEl.innerHTML = `৳${Number(variation.sale_price).toLocaleString()}`;
    if (variation.regular_price > variation.sale_price) {
        const discount = Math.round(((variation.regular_price - variation.sale_price) / variation.regular_price) * 100);
        priceEl.innerHTML += ` <span class="price-des">-${discount}%</span>`;
        mrpEl.innerHTML = `Regular Price: <span>৳${Number(variation.regular_price).toLocaleString()}</span>`;
        mrpEl.style.display = 'block';
    } else {
        mrpEl.style.display = 'none';
    }
}

// Cart Sidebar
function initializeCartSidebar() {
    const cartSidebar = document.getElementById('mn-side-cart');
    const cartOverlay = document.querySelector('.mn-side-cart-overlay');
    const cartItemsList = document.querySelector('.mn-cart-pro-items');
    const cartSubTotal = document.querySelector('.cart-sub-total');

    // Toggle cart sidebar
    document.querySelectorAll('.mn-cart-toggle').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            openCartSidebar();
        });
    });

    // Close cart sidebar
    document.querySelector('.mn-cart-close')?.addEventListener('click', function(e) {
        e.preventDefault();
        closeCartSidebar();
    });

    cartOverlay?.addEventListener('click', closeCartSidebar);

    function openCartSidebar() {
        cartSidebar.classList.add('mn-cart-active');
        cartOverlay.classList.add('mn-cart-overlay-active');
        fetchAndRenderCartItems();
    }

    function closeCartSidebar() {
        cartSidebar.classList.remove('mn-cart-active');
        cartOverlay.classList.remove('mn-cart-overlay-active');
    }

    function fetchAndRenderCartItems() {
        if (!cartItemsList || !cartSubTotal) return;

        // Show loading state
        cartItemsList.innerHTML = '<div class="text-center py-4"><div class="spinner-border text-primary" role="status"></div></div>';
        cartSubTotal.style.opacity = '0.5';

        // Fetch cart items from backend
        fetch(`${window.location.origin}/cart/items`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(cart),
            credentials: 'same-origin'
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (!data || !data.items) {
                throw new Error('Invalid response data');
            }
            renderCartItems(data.items, data.totals);
        })
        .catch(error => {
            console.error('Error fetching cart items:', error);
            cartItemsList.innerHTML = `
                <div class="text-center py-4">
                    <i class="ri-error-warning-line" style="font-size: 24px; color: #dc3545;"></i>
                    <p class="text-danger mt-2">Error loading cart items.<br>Please try refreshing the page.</p>
                </div>`;
            cartSubTotal.innerHTML = `
                <table class="table cart-table">
                    <tbody>
                        <tr>
                            <td class="text-left fw-medium">Total :</td>
                            <td class="text-right primary-color fw-medium">৳0</td>
                        </tr>
                    </tbody>
                </table>`;
            cartSubTotal.style.opacity = '1';
            showNotification('Error loading cart items. Please try refreshing the page.', 'error');
        });
    }

    function renderCartItems(items, totals) {
        if (items.length === 0) {
            cartItemsList.innerHTML = '<div class="text-center py-4">Your cart is empty</div>';
            cartSubTotal.innerHTML = `
                <table class="table cart-table">
                    <tbody>
                        <tr>
                            <td class="text-left fw-medium">Total :</td>
                            <td class="text-right primary-color fw-medium">৳0</td>
                        </tr>
                    </tbody>
                </table>`;
            return;
        }

        // Render cart items
        cartItemsList.innerHTML = items.map(item => {
            // Find all variants of this product
            const variants = items.filter(i => i.id === item.id);
            // Skip if we've already rendered this product
            if (variants.find(v => v.variant_id < item.variant_id)) return '';
            
            // If product has only one variant, render simple view
            if (variants.length === 1) {
                return `
                <li class="cart-sidebar-list p-2">
                    <div class="d-flex align-items-start">
                        <a href="${item.url}" class="mn-pro-img me-2">
                            <img src="${item.image}" alt="${item.title}" style="width: 70px; height: 70px; object-fit: cover; border-radius: 8px;">
                        </a>
                        <div class="mn-pro-content flex-grow-1 pe-4">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <a href="${item.url}" class="cart-pro-title">${item.title}</a>
                                <a href="javascript:void(0)" class="cart-remove-item text-danger position-absolute end-3" 
                                   data-product-id="${item.id}" data-variant-id="${variants[0].variant_id}">×</a>
                            </div>
                            <div class="cart-price">৳${Math.round(variants[0].price)} ×${variants[0].quantity}</div>
                        </div>
                    </div>
                </li>`;
            }
            
            // For products with multiple variants
            return `
            <li class="cart-sidebar-list p-2">
                <div class="d-flex align-items-start">
                    <a href="${item.url}" class="mn-pro-img me-2">
                        <img src="${item.image}" alt="${item.title}" style="width: 70px; height: 70px; object-fit: cover; border-radius: 8px;">
                    </a>
                    <div class="mn-pro-content flex-grow-1 pe-4">
                        <div class="d-flex justify-content-between align-items-start mb-1">
                            <a href="${item.url}" class="cart-pro-title">${item.title}</a>
                            <a href="javascript:void(0)" class="cart-remove-item text-danger position-absolute end-3" 
                               data-product-id="${item.id}" data-variant-id="${variants[0].variant_id}">×</a>
                        </div>
                        ${variants.map(variant => `
                            <div class="mb-1">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="text-muted variant-name fw-medium" style="border-bottom: 1px solid #eee; padding-bottom: 2px">${variant.unit}</div>
                                    <a href="javascript:void(0)" class="text-danger variant-remove cart-remove-variant" 
                                       data-product-id="${item.id}" data-variant-id="${variant.variant_id}">×</a>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mt-1">
                                    <span class="variant-qty">×${variant.quantity}</span>
                                    <span class="variant-price">৳${Math.round(variant.price)}</span>
                                </div>
                            </div>
                        `).join('')}
                    </div>
                </div>
            </li>
        `}).join('');

        // Render totals
        cartSubTotal.innerHTML = `
            <table class="table cart-table">
                <tbody>
                    <tr>
                        <td class="text-left fw-medium">Total :</td>
                        <td class="text-right primary-color fw-medium">৳${Math.round(totals.total)}</td>
                    </tr>
                </tbody>
            </table>`;

        // Restore opacity
        cartSubTotal.style.opacity = '1';

        // Add event listeners for remove buttons
        document.querySelectorAll('.cart-remove-item').forEach(button => {
            button.addEventListener('click', function() {
                const productId = this.dataset.productId;
                
                // Remove ALL variants of this product from cart
                cart = cart.filter(item => item.productId !== productId);
                localStorage.setItem(cartKey, JSON.stringify(cart));
                
                // Update UI and dispatch event
                updateCartCount();
                updateCartButtons();
                dispatchCartUpdate();
                
                showNotification('Product removed from cart', 'success');
            });
        });

        // Add event listeners for variant remove buttons
        document.querySelectorAll('.cart-remove-variant').forEach(button => {
            button.addEventListener('click', function(e) {
                e.stopPropagation(); // Prevent event from bubbling up
                
                const productId = this.dataset.productId;
                const variantId = this.dataset.variantId;
                
                // Remove only this specific variant
                const itemIndex = cart.findIndex(item => 
                    item.productId === productId && item.variantId === variantId
                );
                
                if (itemIndex > -1) {
                    cart.splice(itemIndex, 1);
                    localStorage.setItem(cartKey, JSON.stringify(cart));
                    
                    // Update UI and dispatch event
                    updateCartCount();
                    updateCartButtons();
                    dispatchCartUpdate();
                    
                    showNotification('Variant removed from cart', 'success');
                }
            });
        });
    }

    // Listen for cart updates
    window.addEventListener(CART_UPDATED_EVENT, function() {
        cart = JSON.parse(localStorage.getItem(cartKey) || '[]');
        
        if (cartSidebar?.classList.contains('mn-cart-active')) {
            fetchAndRenderCartItems();
        }
        
        updateCartCount();
        updateCartButtons();
    });
}

// Notification Function
function showNotification(message, type = 'info') {
    const toast = $(`
        <div class="toast align-items-center show" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">
                    <i class="me-1"></i>
                    ${message}
                </div>
                <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    `);
    
    toast.addClass(type);
    
    let iconClass = '';
    switch(type) {
        case 'success':
            iconClass = 'ri-checkbox-circle-line text-success';
            break;
        case 'error':
            iconClass = 'ri-error-warning-line text-danger';
            break;
        case 'warning':
            iconClass = 'ri-alert-line text-warning';
            break;
        default:
            iconClass = 'ri-information-line text-info';
    }
    
    toast.find('.toast-body i').addClass(iconClass);
    $('.toast-container').append(toast);
    
    const bsToast = new bootstrap.Toast(toast[0], {
        autohide: true,
        delay: 5000
    });
    bsToast.show();
    
    toast.on('hidden.bs.toast', function() {
        $(this).remove();
    });
}

// Add this new function
function initializeCartButtons() {
    // Handle main product add to cart (product view page)
    const mainProductCartBtn = document.querySelector('.main-product-cart');
    if (mainProductCartBtn) {
        mainProductCartBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const productId = this.dataset.productId;
            const selectedVariation = document.querySelector('.mn-pro-variation-content li.active');
            const qtyInput = document.querySelector('.qty-input');
            
            if (productId && selectedVariation && qtyInput) {
                const variantId = selectedVariation.dataset.variationId;
                const quantity = parseInt(qtyInput.value);
                addToCart(productId, variantId, quantity, true);
            }
        });

        // Update cart button when variation changes
        document.querySelectorAll('.mn-pro-variation-content li').forEach(variation => {
            variation.addEventListener('click', function() {
                const qtyInput = document.querySelector('.qty-input');
                if (qtyInput) qtyInput.value = '1';
                setTimeout(updateCartButtons, 100);
            });
        });
    }
    
    // Handle related products and list page add to cart
    document.querySelectorAll('.mn-add-cart:not(.main-product-cart)').forEach(button => {
        button.addEventListener('click', function(e) {
            // Ignore clicks for open-link and out-of-stock placeholders
            if (this.classList.contains('open-link')) {
                // let the anchor navigate
                return;
            }
            if (this.classList.contains('out-stock') || this.classList.contains('disabled')) {
                e.preventDefault();
                return;
            }
            
            e.preventDefault();
            const productCard = this.closest('[data-product-id]');
            if (!productCard) return;
            
            const productId = productCard.dataset.productId;
            const defaultVariantId = productCard.dataset.defaultVariantId;
            
            if (productId && defaultVariantId) {
                addToCart(productId, defaultVariantId, 1, false);
            }
        });
    });
}

// Mobile Search Functionality
let searchTimeout;
const searchInput = document.getElementById('searchInput');
const searchResults = document.getElementById('searchResults');

if (searchInput && searchResults) {
    searchInput.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        const query = this.value.trim();
        
        if (query.length < 2) {
            searchResults.innerHTML = '';
            return;
        }
        
        searchResults.innerHTML = '<li class="search-sidebar-list text-center"><div class="spinner-border text-primary" role="status"></div></li>';
        
        searchTimeout = setTimeout(() => {
            fetch(`{{ route('product.search') }}?query=${encodeURIComponent(query)}`, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(products => {
                searchResults.innerHTML = '';
                if (products.length === 0) {
                    searchResults.innerHTML = '<li class="search-sidebar-list text-center">No products found</li>';
                    return;
                }
                products.forEach(product => {
                    const li = document.createElement('li');
                    li.className = 'search-sidebar-list';
                    li.innerHTML = `
                        <a href="{{ url('product') }}/${product.id}" class="mn-pro-img">
                            <img src="${product.thumbnail}" alt="${product.name}" onerror="this.src='{{ asset('assets/default_img.png') }}'">
                        </a>
                        <div class="mn-pro-content">
                            <a href="{{ url('product') }}/${product.id}" class="search-pro-title">${product.name}</a>
                            <span class="search-price">
                                <span>৳${product.default_price}</span>
                            </span>
                        </div>
                    `;
                    searchResults.appendChild(li);
                });
            })
            .catch(error => {
                console.error('Search error:', error);
                searchResults.innerHTML = '<li class="search-sidebar-list text-center">Error occurred while searching</li>';
            });
        }, 300);
    });
}

// Desktop Search Functionality
let desktopSearchTimeout;
const desktopSearchInput = document.getElementById('desktopSearchInput');
const desktopSearchResults = document.getElementById('desktopSearchResults');
const desktopSearchContainer = document.querySelector('.desktop-search-container');
const desktopSearchOverlay = document.querySelector('.desktop-search-overlay');
const desktopSearchResultsContainer = document.querySelector('.desktop-search-results');

if (desktopSearchInput && desktopSearchResults) {
    const renderDesktopResults = (products) => {
        desktopSearchResults.innerHTML = '';
        if (!products || products.length === 0) {
            desktopSearchResults.innerHTML = '<li class="text-center py-3">No products found</li>';
            return;
        }
        products.forEach(product => {
            const li = document.createElement('li');
            li.innerHTML = `
                <a href="{{ url('product') }}/${product.id}" class="mn-pro-img">
                    <img src="${product.thumbnail}" alt="${product.name}" onerror="this.src='{{ asset('assets/default_img.png') }}'">
                </a>
                <div class="mn-pro-content">
                    <a href="{{ url('product') }}/${product.id}" class="search-pro-title">${product.name}</a>
                    <span class="search-price">
                        <span>৳${product.default_price}</span>
                    </span>
                </div>
            `;
            desktopSearchResults.appendChild(li);
        });
    };

    const fetchDesktopResults = (q) => {
        desktopSearchResults.innerHTML = '<li class="text-center"><div class="spinner-border text-primary" role="status"></div></li>';
        return fetch(`{{ route('product.search') }}${q ? `?query=${encodeURIComponent(q)}` : ''}` , {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) throw new Error('Network response was not ok');
            return response.json();
        })
        .then(renderDesktopResults)
        .catch(err => {
            console.error('Desktop search error:', err);
            desktopSearchResults.innerHTML = '<li class="text-center py-3">Error occurred while searching</li>';
        });
    };

    // Handle input in desktop search
    desktopSearchInput.addEventListener('input', function() {
        clearTimeout(desktopSearchTimeout);
        const query = this.value.trim();
        desktopSearchOverlay.classList.add('active');
        desktopSearchContainer.classList.add('active');
        desktopSearchTimeout = setTimeout(() => {
            if (query.length < 2) {
                fetchDesktopResults(''); // default suggestions
            } else {
                fetchDesktopResults(query);
            }
        }, 250);
    });

    // Show dropdown and default suggestions when input is focused
    desktopSearchInput.addEventListener('focus', function() {
        desktopSearchOverlay.classList.add('active');
        desktopSearchContainer.classList.add('active');
        if (this.value.trim().length < 2) {
            fetchDesktopResults('');
        } else {
            fetchDesktopResults(this.value.trim());
        }
    });
    
    // Close search results when clicking outside
    document.addEventListener('click', function(e) {
        if (!desktopSearchContainer.contains(e.target)) {
            desktopSearchOverlay.classList.remove('active');
            desktopSearchContainer.classList.remove('active');
        }
    });
    
    // Close search results when clicking on overlay
    desktopSearchOverlay.addEventListener('click', function() {
        desktopSearchOverlay.classList.remove('active');
        desktopSearchContainer.classList.remove('active');
    });
    
    // Handle search button click
    document.getElementById('desktopSearchButton').addEventListener('click', function() {
        if (desktopSearchInput.value.trim().length >= 2) {
            window.location.href = `{{ route('product.list') }}?search=${encodeURIComponent(desktopSearchInput.value.trim())}`;
        }
    });
    
    // Handle Enter key in search input
    desktopSearchInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter' && this.value.trim().length >= 2) {
            window.location.href = `{{ route('product.list') }}?search=${encodeURIComponent(this.value.trim())}`;
        }
    });
}

$(document).ready(function() {
    $('#allCategoriesBtn').on('click keyup', function(e) {
        if (e.type === 'click' || e.key === 'Enter' || e.key === ' ') {
            var sidebar = $('.mn-sidebar');
            sidebar.toggleClass('sidebar-hide');
            sidebar.toggleClass('sidebar-collapsed', sidebar.hasClass('sidebar-hide'));
            $(this).toggleClass('active');
        }
    });
});
</script>
@yield("script")
</body>
</html>