@extends("general_base")
@section("title", "Contact Us")
@section("style")
<style>
    .contact-section {
        padding: 30px 0 80px 0;
    }
    .contact-info-box {
        background: #fff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0,0,0,0.05);
        margin-bottom: 30px;
        transition: transform 0.3s ease;
    }
    .contact-info-box:hover {
        transform: translateY(-5px);
    }
    .contact-info-box i {
        font-size: 2.5rem;
        color: #159abe;
        margin-bottom: 20px;
    }
    .contact-form {
        background: #fff;
        padding: 40px;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0,0,0,0.05);
        height: 100%;
    }
    .form-control {
        border: 1px solid #e1e1e1;
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 5px;
    }
    .form-control:focus {
        border-color: #159abe;
        box-shadow: none;
    }
    .btn-submit {
        background: #159abe;
        color: #fff;
        padding: 15px 30px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        transition: background 0.3s ease;
    }
    .btn-submit:hover {
        background: #2c3bb3;
    }
    .map-container {
        height: 100%;
        min-height: 600px;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 0 20px rgba(0,0,0,0.05);
    }
    .section-title {
        margin-bottom: 50px;
        text-align: center;
    }
    .section-title h2 {
        font-size: 2.5rem;
        color: #333;
        margin-bottom: 15px;
    }
    .section-title p {
        color: #666;
        font-size: 1.1rem;
    }
    .equal-height {
        height: 100%;
    }
</style>
@endsection

@section("content")
<div class="contact-section">
    <div class="container">
        <div class="section-title">
            <h2>Get in Touch</h2>
            <p>We're here to help and answer any questions you might have</p>
        </div>
        
        <div class="row">
            <div class="col-md-4">
                <div class="contact-info-box text-center">
                    <i class="ri-map-pin-line"></i>
                    <h4>Visit Us</h4>
                    {!! $contact['address'] ?? '' !!}
                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-box text-center">
                    <i class="ri-phone-line"></i>
                    <h4>Call Us</h4>
                    {!! $contact['phone'] ?? '' !!}
                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-box text-center">
                    <i class="ri-mail-line"></i>
                    <h4>Email Us</h4>
                    {!! $contact['email'] ?? '' !!}
                </div>
            </div>
        </div>

        <div class="row mt-5">
            <div class="col-lg-6">
                <div class="map-container">
                    {!! $contact['map_embed'] ?? '' !!}
                </div>
            </div>
            <div class="col-lg-6">
                <div class="contact-form">
                    <h3 class="mb-4">Send us a Message</h3>
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('contact.submit') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                    name="name" placeholder="Your Name" value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                    name="email" placeholder="Your Email" value="{{ old('email') }}" required>
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <input type="tel" class="form-control @error('phone') is-invalid @enderror" 
                                    name="phone" placeholder="Phone Number" value="{{ old('phone') }}" required>
                                @error('phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <select class="form-control @error('type') is-invalid @enderror" name="type" required>
                                    <option value="">Select One</option>
                                    <option value="general" {{ old('type') == 'general' ? 'selected' : '' }}>General Inquiry</option>
                                    <option value="order" {{ old('type') == 'order' ? 'selected' : '' }}>Order Status & Issues</option>
                                    <option value="return" {{ old('type') == 'return' ? 'selected' : '' }}>Return & Refund</option>
                                    <option value="account" {{ old('type') == 'account' ? 'selected' : '' }}>Account & Login</option>
                                    
                                    <option value="feedback" {{ old('type') == 'feedback' ? 'selected' : '' }}>Feedback & Suggestions</option>
                                    <option value="complaint" {{ old('type') == 'complaint' ? 'selected' : '' }}>File a Complaint</option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <textarea class="form-control @error('message') is-invalid @enderror" 
                            name="message" rows="5" placeholder="Your Message" required>{{ old('message') }}</textarea>
                        @error('message')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        
                        <div class="mb-3">
                            {!! NoCaptcha::renderJs() !!}
                            {!! NoCaptcha::display() !!}
                        </div>
                        @error('g-recaptcha-response')
                            <div class="text-danger mb-3">{{ $message }}</div>
                        @enderror
                        
                        <button type="submit" class="btn mn-btn-2" style="padding: 18px 40px; font-size: 1.1rem;"><span>Send Message</span></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection