<!DOCTYPE html>
<html>
<head>
    <title>Stock Alert</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0; background-color: #f5f5f5;">
    <div style="max-width: 600px; margin: 0 auto; padding: 20px;">
        <div style="background-color: white; border-radius: 8px; padding: 30px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            <!-- Header -->
            @php
                $stock = $lowStockItems[0]['stock'];
                $isOutOfStock = $stock <= 0;
                $isCritical = $stock > 0 && $stock <= \App\Models\ProductVariation::CRITICAL_STOCK_THRESHOLD;
                $isLow = $stock > \App\Models\ProductVariation::CRITICAL_STOCK_THRESHOLD && $stock <= \App\Models\ProductVariation::LOW_STOCK_THRESHOLD;
                
                $headerColor = $isOutOfStock ? '#dc3545' : ($isCritical ? '#dc3545' : '#ffc107');
                $headerIcon = $isOutOfStock ? '❌' : ($isCritical ? '⚠️' : '⚠️');
                $headerText = $isOutOfStock ? 'Out of Stock Alert' : ($isCritical ? 'Critical Stock Alert' : 'Low Stock Alert');
                $stockColor = $isOutOfStock ? '#dc3545' : ($isCritical ? '#dc3545' : '#ffc107');
            @endphp

            <div style="text-align: center; margin-bottom: 30px;">
                <h1 style="color: {{ $headerColor }}; margin: 0; font-size: 24px;">{{ $headerIcon }} {{ $headerText }}</h1>
            </div>

            <!-- Main Content -->
            <div style="margin-bottom: 30px;">
                <p style="color: #666; margin-bottom: 20px;">
                    @if($isOutOfStock)
                        The following product is out of stock and requires immediate attention:
                    @elseif($isCritical)
                        The following product has reached critical stock level and requires urgent attention:
                    @else
                        The following product is running low on stock and requires your attention:
                    @endif
                </p>

                <!-- Product Details -->
                <div style="background-color: #f8f9fa; border-radius: 6px; padding: 20px; margin-bottom: 20px;">
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #495057;">Product:</strong>
                        <span style="color: #212529;">{{ $lowStockItems[0]['product']->title }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #495057;">Variation:</strong>
                        <span style="color: #212529;">{{ $lowStockItems[0]['variation']->unit_value }} {{ $lowStockItems[0]['variation']->unit_type }}</span>
                    </div>
                    <div style="margin-bottom: 20px;">
                        <strong style="color: #495057;">Current Stock:</strong>
                        <span style="color: {{ $stockColor }}; font-weight: bold;">
                            {{ $stock }} units
                            <span style="font-size: 14px; margin-left: 5px;">
                                @if($isOutOfStock)
                                    (Out of Stock)
                                @elseif($isCritical)
                                    (Critical Level)
                                @else
                                    (Low Stock)
                                @endif
                            </span>
                        </span>
                    </div>

                    <!-- Action Button -->
                    <a href="{{ route('admin.products.edit', ['product' => $lowStockItems[0]['product']->id]) }}" 
                       style="display: inline-block; background-color: {{ $isOutOfStock || $isCritical ? '#dc3545' : '#0d6efd' }}; color: white; text-decoration: none; padding: 12px 24px; border-radius: 6px; font-weight: 500; text-align: center;">
                        @if($isOutOfStock)
                            Replenish Stock Now
                        @elseif($isCritical)
                            Update Stock Urgently
                        @else
                            Update Stock Level
                        @endif
                    </a>
                </div>

                <!-- Warning Note -->
                <div style="background-color: {{ $isOutOfStock ? '#f8d7da' : ($isCritical ? '#f8d7da' : '#fff3cd') }}; 
                            border-left: 4px solid {{ $isOutOfStock ? '#dc3545' : ($isCritical ? '#dc3545' : '#ffc107') }}; 
                            padding: 15px; border-radius: 4px;">
                    <p style="margin: 0; color: {{ $isOutOfStock ? '#721c24' : ($isCritical ? '#721c24' : '#856404') }};">
                        <strong>Note:</strong> 
                        @if($isOutOfStock)
                            This product is currently out of stock. Immediate action is required to prevent loss of sales.
                        @elseif($isCritical)
                            Stock has reached a critical level. Quick action is needed to prevent stockout.
                        @else
                            Please update the stock levels to ensure product availability and prevent potential stockouts.
                        @endif
                    </p>
                </div>
            </div>

            <!-- Footer -->
            <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee;">
                <p style="color: #6c757d; font-size: 14px; margin: 0;">
                    This is an automated notification from {{ config('app.name') }}
                </p>
            </div>
        </div>
    </div>
</body>
</html> 