@extends("general_base")
@section("title", "Set New Password")
@section("style")
<style>
.mn-login-content {
  max-width: 530px;
  margin: 40px auto;
  padding: 30px 15px;
  background-color: #fff;
  border-radius: 15px;
  border: 1px solid #e5e5e5;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}
.mn-login-box, .mn-login-wrapper, .mn-login-form {
  width: 100%;
  margin: 0 auto;
  padding: 0;
}
.mn-login-form h2 {
  font-weight: 700;
  font-size: 1.6rem;
  color: #313b50;
}
.mn-login-form p {
  color: #999;
  font-size: 0.95rem;
  font-weight: 400;
}
.mn-login-form label {
  margin-bottom: 10px;
  color: #313b50;
  font-size: 14px;
  font-weight: 500;
  line-height: 1;
}
.mn-login-form input {
  height: 50px;
  margin-bottom: 24px;
  padding: 0 15px;
  background-color: transparent;
  border: 1px solid #e5e5e5;
  border-radius: 15px;
  font-size: 14px;
  outline: none;
}
.text-center {
  text-align: center;
}
.mn-btn-1.btn {
  padding: 8px 15px;
  border-radius: 8px;
  background: #ffe3a3;
  color: #313b50;
  border: none;
  font-weight: 600;
  transition: all 0.3s ease;
}
.mn-btn-1.btn:hover {
  background: #313b50;
}
.mn-btn-1.btn span {
  color: #313b50;
  transition: all 0.3s ease;
}
.mn-btn-1.btn:hover span {
  color: #fff;
}
.back-to-login {
  margin-top: 15px;
  text-align: center;
}
.back-to-login a {
  color: #313b50;
  font-size: 14px;
  text-decoration: none;
  display: inline-flex;
  align-items: center;
  gap: 5px;
  transition: transform 0.2s ease;
}
.back-to-login a:hover {
  transform: scale(1.05);
  text-decoration: none;
}
@media only screen and (max-width: 575px) {
  .mn-login-content {
    padding: 15px 0;
  }
}
</style>
@endsection
@section("content")
<section class="mn-login p-b-15">
    <div class="mn-login-content">
        <div class="mn-login-box">
            <div class="mn-login-wrapper">
                <div class="mn-login-container">
                    <div class="mn-login-form">
    <h2 class="text-center mb-2" style="font-weight:700;font-size:1.6rem;color:#313b50;">Set New Password</h2>
    <p class="text-center mb-4" style="color:#999;font-size:0.95rem;font-weight:400;">Set a new password for your account. Choose a strong password that you can remember.</p>
                        <form action="{{ route('password.store') }}" method="POST">
                            @csrf
                            <!-- Password Reset Token -->
                            <input type="hidden" name="token" value="{{ $request->route('token') }}">
                            
                            <span class="mn-login-wrap">
                            <label>Email Address</label>
                            <input type="text" name="email" value="{{ old('email', $request->email) }}" placeholder="example@gmail.com" required>
                            </span>
                            <span class="mn-register-wrap">
                            <label>Password</label>
                            <input type="password" name="password" placeholder="Min 6 characters" minlength="6" maxlength="128" required>
                            </span>
                            <span class="mn-register-wrap">
                            <label>Confirm Password</label>
                            <input type="password" name="password_confirmation" placeholder="Min 6 characters" minlength="6" maxlength="128" required>
                            </span> 
                            <div class="mb-3">
                                {!! NoCaptcha::renderJs() !!}
                                {!! NoCaptcha::display() !!}
                            </div>
                            <div class="text-center">
                                <button type="submit" class="mn-btn-1 btn"><span>Reset Password</span></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection