<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" type="image/x-icon" href="{{ Storage::url($appSettings->favicon_path) ?? '' }}" />
  <link rel="preconnect" href="https://fonts.bunny.net">
  <link rel="stylesheet" href="https://fonts.bunny.net/css?family=Figtree:400,500,600&display=swap" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
  <link rel="stylesheet" href="{{ asset('admin/css/dashboard.css') }}">
  <link rel="stylesheet" href="{{ asset('admin/css/dataTables.css') }}">
  <link rel="stylesheet" href="{{ asset('admin/css/responsiveTable.css') }}">
  <title>@yield("title") | {{ config('app.name') }} - Admin Panel</title>
<meta name="robots" content="noindex, nofollow">
</head>
<style>
body{
  font-family: "Figtree", sans-serif;
}
a.brand-link img{
  max-height: 40px;
  width: 100%;
}
.sidebar-dark-primary .nav-sidebar>.nav-item>.nav-link:hover{
  transition: all 0.3s ease-in-out;
  background-color: #1cbce8;
  color: #fff;
}
.sidebar-dark-primary .nav-sidebar>.nav-item>.nav-link.active{
  background-color: #1cbce8;
  color: #fff;
}
div.divider{
  height: 1px;
  margin: 3px 0;
  background-color: #4b545c;
}
.bg_sb_primary{
  background-color: #1cbce8;
  color: #ffffff;
}
.bg_sb_secondary{
  background-color: #9d2323;
  color: #4b545c;
}
.sb_btn {
  display: inline-block;
  padding: 8px 20px;
  font-size: 14px;
  font-weight: 500;
  text-align: center;
  text-decoration: none;
  cursor: pointer;
  border: none;
  border-radius: 5px;
  color: #fff;
  background-color: #1cbce8;
  transition: all 0.3s ease;
  position: relative;
  overflow: hidden;
  z-index: 1;
}
.sb_btn::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 0;
  height: 100%;
  background-color: #159abe;
  transition: all 0.3s ease;
  z-index: -1;
}
.sb_btn:hover {
  color: #4b545c;
}
.sb_btn:hover::before {
  width: 100%;
}
.sb_btn:active {
  transform: translateY(1px);
}
.sb_btn i {
  margin-right: 5px;
  position: relative;
}
/* Toast Notification */
.toast-container {
  position: fixed;
  top: 20px;
  right: 20px;
  z-index: 9999;
}
.toast {
  min-width: 300px;
  opacity: 1 !important;
  background: white;
  box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}
.toast-success .toast-header {
  background-color: #28a745;
  color: white;
  border: none;
}
.toast-error .toast-header {
  background-color: #dc3545;
  color: white;
  border: none;
}
.toast-header {
  border-bottom: none;
}
.toast-header .close {
  color: inherit;
  text-shadow: none;
  opacity: 1;
  font-size: 1.1rem;
  padding: 0.5rem;
}
.toast-header .close:hover {
  opacity: 0.8;
}
.toast-body {
  background: white;
  padding: 1rem;
  font-size: 0.95rem;
}

/* Pagination Styles */
.pagination {
  margin: 0;
  gap: 2px;
}

.page-item {
  margin: 0 2px;
}

.page-link {
  padding: 8px 12px;
  border: 1px solid #dee2e6;
  color: #333;
  background-color: #fff;
  border-radius: 4px;
  transition: all 0.2s;
}

.page-item.active .page-link {
  background-color: #1cbce8;
  border-color: #1cbce8;
  color: white;
}

.page-item.disabled .page-link {
  color: #6c757d;
  pointer-events: none;
  background-color: #fff;
}

.page-link:hover:not(.disabled) {
  background-color: #f8f9fa;
  border-color: #1cbce8;
  color: #1cbce8;
  z-index: 2;
}

.showing-text {
  color: #666;
  font-size: 0.9rem;
}

.pagination-wrapper {
  display: flex;
  align-items: center;
}

.nav-sidebar .nav-item .nav-link .badge {
  margin-left: 5px;
  padding: 3px 6px;
  font-size: 11px;
  line-height: 1;
  min-width: 20px;
  text-align: center;
}

.nav-sidebar .nav-item .nav-link .badge.right {
  float: right;
  margin-right: 0;
  margin-top: 3px;
}

.nav-sidebar .nav-item .nav-link { display: flex; align-items: center; gap: 8px; }
.nav-sidebar .nav-item .nav-link .nav-icon { flex: 0 0 auto; }
.nav-sidebar .nav-item .nav-link .nav-text { flex: 1 1 auto; margin: 0; }
.nav-sidebar .nav-item .nav-link .badge-container { flex: 0 0 auto; margin-left: auto; display: inline-flex; gap: 4px; }

.table-responsive {
  width: 100%;
  overflow-x: auto;
}
@media (max-width: 991px) {
  .table-responsive table {
    min-width: 600px;
  }
}
</style>
@yield("style")
<body class="hold-transition sidebar-mini">
<!-- Toast Container -->
<div class="toast-container">
    @if(session('success'))
    <div class="toast toast-success" role="alert" aria-live="assertive" aria-atomic="true" data-delay="5000">
        <div class="toast-header">
            <i class="fas fa-check-circle mr-2"></i>
            <strong class="mr-auto">Success</strong>
            <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="toast-body">
            {{ session('success') }}
        </div>
    </div>
    @endif

    @if(session('error'))
    <div class="toast toast-error" role="alert" aria-live="assertive" aria-atomic="true" data-delay="5000">
        <div class="toast-header">
            <i class="fas fa-exclamation-circle mr-2"></i>
            <strong class="mr-auto">Error</strong>
            <button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="toast-body">
            {{ session('error') }}
        </div>
    </div>
    @endif
</div>
<!-- body wrapper :start -->
<div class="wrapper">
<!-- navbar :start -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a href="javascript:void(0)" class="nav-link" data-widget="pushmenu" role="button"><i class="fas fa-bars"></i></a>
      </li>
    </ul>
  </nav>
  <!-- navbar :end-->
  <!-- left sidebar :start -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="{{ route('admin.dashboard') }}" class="brand-link py-3 mb-2">
      <img src="{{ isset($appSettings) && $appSettings->admin_logo_path ? asset('storage/'.$appSettings->admin_logo_path) : asset('assets/logo.png') }}" alt="logo">
    </a>

      <nav>
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <li class="nav-item">
            <a href="{{ route('admin.dashboard') }}" class="nav-link {{ Route::is('admin.dashboard') ? 'active' : '' }}">
              <i class="nav-icon fas fa-chart-bar"></i>
              <p>Dashboard</p>
            </a>
          </li>
          <li class="nav-item {{ Route::is('admin.users*') ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ Route::is('admin.users') || Route::is('admin.users.edit') ? 'active' : '' }}">
              <i class="nav-icon fas fa-users"></i>
              <p>Users
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="{{ route('admin.users') }}" class="nav-link {{ Route::is('admin.users') || Route::is('admin.users.edit') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>List</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('admin.users.create') }}" class="nav-link {{ Route::is('admin.users.create') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Add New</p>
                </a>
              </li>
            </ul>
          </li>
          <li class="nav-item">
            <a href="{{ route('admin.orders') }}" class="nav-link {{ Route::is('admin.orders') || Route::is('admin.orders.show') ? 'active' : '' }}">
              <i class="nav-icon fas fa-shopping-cart"></i>
              <p class="nav-text">Orders</p>
              <span class="badge-container">
                @if($orderCounts['pending'] > 0)
                  <span class="badge badge-warning">{{ $orderCounts['pending'] > 9 ? '9+' : $orderCounts['pending'] }}</span>
                @endif
                @if($orderCounts['processing'] > 0)
                  <span class="badge badge-info">{{ $orderCounts['processing'] > 9 ? '9+' : $orderCounts['processing'] }}</span>
                @endif
                @if($orderCounts['shipped'] > 0)
                  <span class="badge badge-primary">{{ $orderCounts['shipped'] > 9 ? '9+' : $orderCounts['shipped'] }}</span>
                @endif
              </span>
            </a>
          </li>
          <li class="nav-item {{ Route::is('admin.payments') ? 'menu-open' : '' }}">
            <a href="{{ route('admin.payments') }}" class="nav-link {{ Route::is('admin.payments') ? 'active' : '' }}">
              <i class="nav-icon fas fa-money-bill-wave"></i>
              <p>Payments</p>
            </a>
          </li>
          <li class="nav-item {{ Route::is('admin.products*') || Route::is('admin.categories') || Route::is('admin.coupons') || Route::is('admin.deals*') || Route::is('admin.brands*') ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ Route::is('admin.products') || Route::is('admin.products.edit') || Route::is('admin.products.reviews') || Route::is('admin.products.analytics') || Route::is('admin.deals*') ? 'active' : '' }}">
                <i class="nav-icon fas fa-box"></i>
                <p>Products
                    <i class="fas fa-angle-left right"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="{{ route('admin.products') }}" class="nav-link {{ Route::is('admin.products') || Route::is('admin.products.edit') || Route::is('admin.products.analytics') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Inventory</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.products.create') }}" class="nav-link {{ Route::is('admin.products.create') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Add New</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.categories') }}" class="nav-link {{ Route::is('admin.categories') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Categories</p>
                    </a>
                </li>
                <li class="nav-item">
                  <a href="{{ route('admin.brands') }}" class="nav-link {{ Route::is('admin.brands*') ? 'active' : '' }}">
                      <i class="far fa-circle nav-icon"></i>
                      <p>Brands</p>
                  </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.coupons') }}" class="nav-link {{ Route::is('admin.coupons') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Coupons</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.deals') }}" class="nav-link {{ Route::is('admin.deals*') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Best Deals</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.products.reviews') }}" class="nav-link {{ Route::is('admin.products.reviews') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Reviews</p>
                    </a>
                </li>
            </ul>
          </li>
          <li class="nav-item {{ Route::is('admin.blogs*') ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ Route::is('admin.blogs') || Route::is('admin.blogs.edit') ? 'active' : '' }}">
              <i class="nav-icon fas fa-blog"></i>
              <p>Blog
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="{{ route('admin.blogs') }}" class="nav-link {{ Route::is('admin.blogs') || Route::is('admin.blogs.edit') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Posts</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('admin.blogs.create') }}" class="nav-link {{ Route::is('admin.blogs.create') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Add New</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('admin.blogs.comments') }}" class="nav-link {{ Route::is('admin.blogs.comments') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Comments</p>
                </a>
              </li>
            </ul>
          </li>

          <li class="nav-item {{ Route::is('admin.pages*') || Route::is('admin.faqs') ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ Route::is('admin.pages') || Route::is('admin.pages.edit') || Route::is('admin.faqs') ? 'active' : '' }}">
              <i class="nav-icon fas fa-file-alt"></i>
              <p>Pages
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="{{ route('admin.pages') }}" class="nav-link {{ Route::is('admin.pages') || Route::is('admin.pages.edit') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>List</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('admin.pages.create') }}" class="nav-link {{ Route::is('admin.pages.create') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Add New</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('admin.faqs') }}" class="nav-link {{ Route::is('admin.faqs') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>FAQ</p>
                </a>
              </li>
            </ul>
          </li>

          

          <li class="nav-item {{ Route::is('admin.customize*') ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ Route::is('admin.customize*') ? 'active' : '' }}">
              <i class="nav-icon fas fa-paint-brush"></i>
              <p>Customize
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="{{ route('admin.customize.home') }}" class="nav-link {{ Route::is('admin.customize.home') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Home</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('admin.customize.contact') }}" class="nav-link {{ Route::is('admin.customize.contact') ? 'active' : '' }}">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Contact</p>
                </a>
              </li>
            </ul>
          </li>

          <li class="nav-item">
            <a href="{{ route('admin.settings') }}" class="nav-link {{ Route::is('admin.settings*') ? 'active' : '' }}">
              <i class="nav-icon fas fa-cog"></i>
              <p>Settings</p>
            </a>
          </li>

          <li class="nav-item">
            <div class="divider">
          </li>
          <li class="nav-item">
            <a href="https://dashboard.tawk.to/#/dashboard" class="nav-link" target="_blank">
              <i class="nav-icon fas fa-comments"></i>
              <p>Chat</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="{{ route('home') }}" class="nav-link">
              <i class="nav-icon fas fa-pager"></i>
              <p>Client Area</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="javascript:void(0)" class="nav-link" onclick="submitLogoutForm()">
              <i class="nav-icon fa fa-share-square"></i>
              <p>Logout</p>
            </a>
          </li>
        </ul>
      </nav>
    </div>
  </aside>
<!-- left sidebar :end -->
<!-- content wrapper :start -->
<div class="content-wrapper">
<div class="content">
<div class="container-fluid pt-3">
@yield("content")
</div>
</div>
</div>
<form action="{{ route('logout') }}" method="POST" id="logoutForm" style="display: none;">
@csrf
</form>
<!-- content wrapper :end -->
</div>
<!-- body wrapper :end -->
<script src="{{ asset('admin/js/jquery.js') }}"></script>
<script src="{{ asset('admin/js/bootstrap4.js') }}"></script>
<script src="{{ asset('admin/js/dashboard.js') }}"></script>
<script src="{{ asset('admin/js/JQdataTables.js') }}"></script>
<script src="{{ asset('admin/js/dataTables.js') }}"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    $('.toast').toast('show');
    $('[data-toggle="tooltip"]').tooltip();
});

function submitLogoutForm() {
    document.getElementById('logoutForm').submit();
}
</script>
@yield("script")
</body>
</html>