@foreach($products as $product)
    <div class="product-card">
        <div class="product-image">
            @if($product->primary_image)
                <img src="{{ asset('storage/' . $product->primary_image->path) }}" 
                     alt="{{ $product->title }}">
            @else
                <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                    <i class="fas fa-image text-muted fa-2x"></i>
                </div>
            @endif
            <div class="product-badges">
                @foreach($product->variations as $variant)
                    @if($variant->default)
                        @if($variant->is_out_of_stock())
                            <span class="badge-item bg-danger">Out of Stock</span>
                        @elseif($variant->is_critical_stock())
                            <span class="badge-item" style="background-color: #dc3545">Critical Stock</span>
                        @elseif($variant->is_low_stock())
                            <span class="badge-item" style="background-color: #ffc107">Low Stock</span>
                        @endif
                        @break
                    @endif
                @endforeach
            </div>
        </div>
        
        <div class="product-content">
            <h3 class="product-title">{{ $product->title }}</h3>
            <div class="product-category">{{ $product->category->full_path }}</div>
            
            @if($product->tags && count($product->tags) > 0)
                <div class="product-tags">
                    @foreach($product->tags as $index => $tag)
                        @if($index < 3)
                            <span class="tag">{{ $tag }}</span>
                        @elseif($index === 3)
                            <span class="tag tag-more" 
                                  onclick="toggleTags(this)" 
                                  data-tags='@json(array_slice($product->tags, 3))'>
                                +{{ count($product->tags) - 3 }} more
                            </span>
                        @endif
                    @endforeach
                </div>
            @endif
            
            <div class="variants-section">
                @foreach($product->variations->take(3) as $index => $variant)
                    <div class="variant-item">
                        <div class="variant-info">
                            <div class="variant-name">
                                {{ $variant->unit_type }}: {{ $variant->unit_value }}
                                @if($variant->default)
                                    <span class="badge bg-primary" style="font-size: 0.7rem;">Default</span>
                                @endif
                            </div>
                            <div class="variant-price">
                                <span class="sale-price">৳{{ number_format($variant->sale_price) }}</span>
                                @if($variant->regular_price > $variant->sale_price)
                                    <span class="regular-price">৳{{ number_format($variant->regular_price) }}</span>
                                @endif
                            </div>
                        </div>
                        <div>
                            @if($variant->is_out_of_stock())
                                <span class="stock-badge out-of-stock">Out</span>
                            @elseif($variant->is_critical_stock())
                                <span class="stock-badge critical-stock">{{ $variant->in_stock }}</span>
                            @elseif($variant->is_low_stock())
                                <span class="stock-badge low-stock">{{ $variant->in_stock }}</span>
                            @else
                                <span class="stock-badge in-stock">{{ $variant->in_stock }}</span>
                            @endif
                        </div>
                    </div>
                @endforeach
                @if($product->variations->count() > 3)
                    <div class="variant-more">
                        +{{ $product->variations->count() - 3 }} more variants
                    </div>
                @endif
            </div>
        </div>
        
        <div class="card-actions">
            <a href="{{ route('admin.products.edit', $product->id) }}" 
               class="btn btn-sm btn-outline-primary">
                <i class="fas fa-edit"></i> Edit
            </a>
            <button type="button" 
                    class="btn btn-sm btn-outline-danger"
                    onclick="deleteProduct({{ $product->id }})">
                <i class="fas fa-trash"></i> Delete
            </button>
        </div>
    </div>
@endforeach 