@extends('admin_base')

@section('title', 'FAQs')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Frequently Asked Questions</h3>
                <div class="card-tools">
                    <button type="button" class="btn sb_btn" data-toggle="modal" data-target="#addFaqModal">
                        <i class="fas fa-plus"></i> Add New
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="faqTable" class="table table-bordered table-striped">
                        <thead class="bg_sb_primary">
                            <tr>
                                <th>SL</th>
                                <th>Question</th>
                                <th>Answer</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($faqs as $key => $faq)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $faq->question }}</td>
                                <td>{{ \Illuminate\Support\Str::limit(strip_tags($faq->answer), 100, '...') }}</td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-sm btn-info" onclick="editFaq({{ $faq->id }}, '{{ addslashes($faq->question) }}', '{{ addslashes($faq->answer) }}')">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button type="button" class="btn btn-sm btn-danger" onclick="deleteFaq({{ $faq->id }})">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add FAQ Modal -->
<div class="modal fade" id="addFaqModal" tabindex="-1" role="dialog" aria-labelledby="addFaqModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addFaqModalLabel">Add New FAQ</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="addFaqForm">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="question">Question</label>
                        <input type="text" class="form-control" id="question" name="question" required>
                    </div>
                    <div class="form-group">
                        <label for="answer">Answer</label>
                        <textarea class="form-control" id="answer" name="answer" rows="5" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn sb_btn">Save FAQ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit FAQ Modal -->
<div class="modal fade" id="editFaqModal" tabindex="-1" role="dialog" aria-labelledby="editFaqModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editFaqModalLabel">Edit FAQ</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="editFaqForm">
                <input type="hidden" id="edit_faq_id">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="edit_question">Question</label>
                        <input type="text" class="form-control" id="edit_question" name="question" required>
                    </div>
                    <div class="form-group">
                        <label for="edit_answer">Answer</label>
                        <textarea class="form-control" id="edit_answer" name="answer" rows="5" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn sb_btn">Update FAQ</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('style')
<style>
    #faqTable td {
        vertical-align: middle;
    }
</style>
@endsection

@section('script')
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#faqTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "order": [[0, 'asc']],
        "columnDefs": [
            { "orderable": false, "targets": 3 }
        ]
    });

    // Add FAQ Form Submit
    $('#addFaqForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: "{{ route('admin.faqs.store') }}",
            method: 'POST',
            data: {
                _token: "{{ csrf_token() }}",
                question: $('#question').val(),
                answer: $('#answer').val()
            },
            success: function(response) {
                $('#addFaqModal').modal('hide');
                location.reload();
            },
            error: function(xhr) {
                alert('Error occurred. Please try again.');
            }
        });
    });

    // Edit FAQ Form Submit
    $('#editFaqForm').on('submit', function(e) {
        e.preventDefault();
        var id = $('#edit_faq_id').val();
        $.ajax({
            url: "/admin/faqs/" + id + "/update",
            method: 'PUT',
            data: {
                _token: "{{ csrf_token() }}",
                question: $('#edit_question').val(),
                answer: $('#edit_answer').val()
            },
            success: function(response) {
                $('#editFaqModal').modal('hide');
                location.reload();
            },
            error: function(xhr) {
                alert('Error occurred. Please try again.');
            }
        });
    });
});

function editFaq(id, question, answer) {
    $('#edit_faq_id').val(id);
    $('#edit_question').val(question);
    $('#edit_answer').val(answer);
    $('#editFaqModal').modal('show');
}

function deleteFaq(id) {
    if(confirm('Are you sure you want to delete this FAQ?')) {
        $.ajax({
            url: "/admin/faqs/" + id + "/delete",
            method: 'DELETE',
            data: {
                _token: "{{ csrf_token() }}"
            },
            success: function(response) {
                location.reload();
            },
            error: function(xhr) {
                alert('Error occurred. Please try again.');
            }
        });
    }
}
</script>
@endsection 