@extends('admin_base')

@section('title', 'Customize Contact Page')

@section('style')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<style>
.section-card { background: #ffffff; border: 1px solid #e0e0e0; border-radius: 8px; }
.item-card { border: 1px solid #e9ecef; border-radius: 8px; padding: 12px; margin-bottom: 12px; background: #fff; }
</style>
@endsection

@section('content')
<div class="row">
  <div class="col-12">
    <div class="section-card">
      <div class="card-header d-flex align-items-center justify-content-between">
        <h5 class="mb-0">Contact Page Customization</h5>
      </div>
      <div class="card-body p-3">
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        @endif

        <form action="{{ route('admin.customize.contact.update') }}" method="POST">
          @csrf
          @method('PUT')

          <div class="mb-3">
            <h6 class="mb-2">Contact Information</h6>
            
            <div class="item-card">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Address Information</label>
                    <textarea class="form-control summernote" name="address" rows="3">{{ old('address', $contact['address']) }}</textarea>
                    @error('address')
                    <div class="text-danger">{{ $message }}</div>
                    @enderror
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Phone Numbers</label>
                    <textarea class="form-control summernote" name="phone" rows="3">{{ old('phone', $contact['phone']) }}</textarea>
                    @error('phone')
                    <div class="text-danger">{{ $message }}</div>
                    @enderror
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Email Addresses</label>
                    <textarea class="form-control summernote" name="email" rows="3">{{ old('email', $contact['email']) }}</textarea>
                    @error('email')
                    <div class="text-danger">{{ $message }}</div>
                    @enderror
                  </div>
                </div>

                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label">Google Maps Embed Code</label>
                    <textarea class="form-control" name="map_embed" rows="5" placeholder="Paste your Google Maps embed code here...">{{ old('map_embed', $contact['map_embed']) }}</textarea>
                    <small class="form-text text-muted">Paste the complete iframe code from Google Maps embed.</small>
                    @error('map_embed')
                    <div class="text-danger">{{ $message }}</div>
                    @enderror
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="text-right">
            <button type="submit" class="btn sb_btn">Save Changes</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<script>
$(document).ready(function() {
    $('.summernote').summernote({
        height: 150,
        toolbar: [
            ['style', ['bold', 'italic', 'underline', 'clear']],
            ['font', ['strikethrough']],
            ['para', ['ul', 'ol', 'paragraph']],
        ]
    });
});
</script>
@endsection 