<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('favicon_path')->nullable();
            $table->string('site_logo_path')->nullable();
            $table->string('admin_logo_path')->nullable();
            $table->string('footer_copyright')->nullable();
            $table->string('google_analytics_id')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('loader_image_path')->nullable();
            $table->text('pixel_code')->nullable();
            $table->string('contact_address')->nullable();
            $table->string('contact_phone', 50)->nullable();
            $table->string('contact_email')->nullable();
            $table->json('social_media')->nullable();
            $table->string('footer_description', 500)->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
}; 