<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_variations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->string('unit_type')->nullable();
            $table->string('unit_value')->nullable();
            $table->integer('in_stock')->default(0);
            $table->integer('sale_price')->default(0);
            $table->integer('regular_price')->nullable();
            $table->boolean('default')->default(false);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_variations');
    }
}; 