<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable implements MustVerifyEmail
{
    use Notifiable;
    
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'phone',
        'password',
        'is_active',
        'role',
        'two_factor_secret',
        'two_factor_recovery_codes',
        'two_factor_enabled',
        'two_factor_confirmed_at',
        'shipping_addr'
    ];

    protected $hidden = [
        'password',
        'two_factor_secret',
        'two_factor_recovery_codes',
        'remember_token'
    ];

    protected $casts = [
        'password' => 'hashed',
        'two_factor_enabled' => 'boolean',
        'two_factor_confirmed_at' => 'datetime',
        'email_verified_at' => 'datetime',
        'shipping_addr' => 'array',
        'role' => 'string'
    ];

    const ROLE_USER = 'user';
    const ROLE_ADMIN = 'admin';

    public function wishlist()
    {
        return $this->hasMany(Wishlist::class);
    }

    public function productRatings()
    {
        return $this->hasMany(ProductRating::class);
    }

    public function wishlist_products()
    {
        return $this->wishlist->map(function ($item) {
            return $item->product;
        });
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function has_two_factor_enabled(): bool
    {
        return $this->two_factor_enabled && 
               $this->two_factor_confirmed_at !== null && 
               $this->two_factor_secret !== null;
    }

    public function get_shipping_address(): ?array
    {
        return $this->shipping_addr;
    }

    public function update_shipping_address(array $data): void
    {
        $this->update(['shipping_addr' => $data]);
    }

    public function isAdmin(): bool
    {
        return $this->role === self::ROLE_ADMIN;
    }

    public function getNameAttribute(): string
    {
        return trim($this->first_name . ' ' . $this->last_name);
    }
}