<?php

namespace App\Listeners;

use App\Mail\VerifyEmail;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Mail;

class SendQueuedEmailVerificationNotification
{
    public function handle(Registered $event): void
    {
        if ($event->user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $event->user->hasVerifiedEmail()) {
            Mail::to($event->user)->queue(new VerifyEmail($event->user));
        }
    }
} 