<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;

class PaymentController extends Controller
{
    // Show SSLCommerz payment history (no manual methods)
    public function index(Request $request)
    {
        $status = $request->get('status'); // paid|unpaid|failed|cancelled|null

        $payments = Order::query()
            ->where('payment_method', 'sslcommerz')
            ->when($status, function($q) use ($status) {
                $q->where('payment_status', $status);
            })
            ->latest()
            ->paginate(20)
            ->withQueryString();

        return view('admin.payments.list', [
            'payments' => $payments,
            'currentStatus' => $status
        ]);
    }
}
