<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Pages;
use Illuminate\Http\Request;

class PagesController extends Controller
{
    public function index()
    {
        $pages = Pages::all();
        return view('admin.pages.list', compact('pages'));
    }

    public function create()
    {
        return view('admin.pages.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'content' => 'required|string',
            'slug' => 'required|string|unique:pages,slug',
        ]);

        Pages::create($request->all());

        return redirect()->route('admin.pages')
            ->with('success', 'Page created successfully.');
    }

    public function edit(Pages $page)
    {
        return view('admin.pages.edit', compact('page'));
    }

    public function update(Request $request, Pages $page)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'content' => 'required|string',
            'slug' => 'required|string|unique:pages,slug,' . $page->id,
        ]);

        $page->update($request->all());

        return redirect()->route('admin.pages')
            ->with('success', 'Page updated successfully.');
    }

    public function destroy(Pages $page)
    {
        $page->delete();
        return redirect()->route('admin.pages')
            ->with('success', 'Page deleted successfully.');
    }
} 