

<?php $__env->startSection('title', 'Best Deals'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="card-title">Best Deals</h3>
            <a href="<?php echo e(route('admin.deals.create')); ?>" class="sb_btn">
                <i class="fas fa-plus"></i> Add New Deal
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="dealsTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Products</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $deals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($deal->id); ?></td>
                        <td><?php echo e($deal->name); ?></td>
                        <td><?php echo e($deal->start_date->format('M d, Y h:i A')); ?></td>
                        <td><?php echo e($deal->end_date->format('M d, Y h:i A')); ?></td>
                        <td>
                            <span class="badge badge-<?php echo e($deal->status ? 'success' : 'danger'); ?>">
                                <?php echo e($deal->status ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>
                        <td><?php echo e($deal->products->count()); ?> products</td>
                        <td>
                            <div class="btn-group">
                                <a href="<?php echo e(route('admin.deals.edit', $deal)); ?>" class="btn btn-sm btn-info mr-2">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="btn btn-sm btn-danger" onclick="confirmDelete(<?php echo e($deal->id); ?>)">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                            <form id="delete-form-<?php echo e($deal->id); ?>" action="<?php echo e(route('admin.deals.destroy', $deal)); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    $('#dealsTable').DataTable({
        "order": [[0, "desc"]]
    });
});

function confirmDelete(dealId) {
    if (confirm('Are you sure you want to delete this deal?')) {
        document.getElementById('delete-form-' + dealId).submit();
    }
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/products/deals/list.blade.php ENDPATH**/ ?>