<?php $__env->startSection("title", "Verify Your Email"); ?>
<?php $__env->startSection("style"); ?>
<style>
.mn-login-content {
  max-width: 700px;
  margin: 40px auto;
  padding: 40px 30px;
  background-color: #fff;
  border-radius: 20px;
  border: 1px solid #e5e5e5;
  box-shadow: 0 10px 30px rgba(0,0,0,0.1);
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}
.mn-login-form {
  width: 100%;
  text-align: center;
}
.verification-icon {
  text-align: center;
  margin-bottom: 25px;
  position: relative;
}
.verification-icon i {
  font-size: 5rem;
  color: #28a745;
  background: linear-gradient(135deg, #28a745, #20c997);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  filter: drop-shadow(0 2px 4px rgba(40, 167, 69, 0.3));
}
.verify-title {
  font-weight: 700;
  font-size: 1.8rem;
  color: #313b50;
  margin-bottom: 15px;
}
.verify-desc {
  color: #666;
  font-size: 1rem;
  font-weight: 400;
  line-height: 1.6;
  margin-bottom: 30px;
}
.verify-desc .user-name {
  color: #28a745;
  font-weight: 600;
}
.verify-desc .emoji {
  font-size: 1.2em;
}
.resend-section {
  background: #f8f9fa;
  border-radius: 15px;
  padding: 25px;
  margin: 20px 0;
  border: 1px solid #e9ecef;
}
.resend-text {
  color: #6c757d;
  font-size: 0.9rem;
  margin-bottom: 15px;
}

.alert {
  border-radius: 10px;
  padding: 15px 20px;
  margin-bottom: 20px;
  border: none;
  font-size: 14px;
}
.alert-success {
  background: linear-gradient(135deg, #d4edda, #c3e6cb);
  color: #155724;
  border-left: 4px solid #28a745;
}
.alert-info {
  background: linear-gradient(135deg, #d1ecf1, #bee5eb);
  color: #0c5460;
  border-left: 4px solid #17a2b8;
}
.alert-danger {
  background: linear-gradient(135deg, #f8d7da, #f5c6cb);
  color: #721c24;
  border-left: 4px solid #dc3545;
}
.email-info {
  background: #e8f4fd;
  border: 1px solid #b8daff;
  border-radius: 10px;
  padding: 15px;
  margin: 15px 0;
  color: #004085;
  font-size: 0.9rem;
}
@media only screen and (max-width: 575px) {
  .mn-login-content {
    margin: 20px 15px;
    padding: 30px 20px;
  }
  .verify-title {
    font-size: 1.5rem;
  }
  .verification-icon i {
    font-size: 4rem;
  }
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<section class="mn-login p-b-15">
    <div class="mn-login-content">
        <div class="mn-login-form">
            <div class="verification-icon">
                <i class="ri-mail-check-line"></i>
            </div>
            
            <h2 class="verify-title">Check Your Email</h2>
            
            <p class="verify-desc">
                Thanks <span class="user-name"><?php echo e(auth()->user()->first_name); ?></span> for signing up <span class="emoji">🎉</span><br><br>
                Before getting started, could you verify your email address by clicking on the link we just emailed to you?<br><br>
                If you didn't receive the email, we will gladly send you another.
            </p>

            <div class="email-info">
                <i class="ri-mail-line me-2"></i>
                <strong>Email sent to:</strong> <?php echo e(auth()->user()->email); ?>

            </div>

            <div class="resend-section">
                <p class="resend-text">
                    <i class="ri-time-line me-1"></i>
                    Didn't receive the email? Check your spam folder or click below to resend.
                </p>
                
                <form method="POST" action="<?php echo e(route('verification.send')); ?>" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">
                        <i class="ri-mail-send-line me-2"></i>
                        Resend Verification Email
                    </button>
                </form>
            </div>            
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/auth/verify_email.blade.php ENDPATH**/ ?>