<?php $__env->startSection('title', 'Payments'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center w-100">
                    <h3 class="card-title">Payment History</h3>
                    <div>
                        <a href="<?php echo e(route('admin.payments', ['status' => null])); ?>" class="btn btn-sm <?php echo e($currentStatus === null ? 'sb_btn' : 'btn-outline-secondary'); ?>">All</a>
                        <a href="<?php echo e(route('admin.payments', ['status' => 'paid'])); ?>" class="btn btn-sm <?php echo e($currentStatus === 'paid' ? 'sb_btn' : 'btn-outline-secondary'); ?>">Paid</a>
                        <a href="<?php echo e(route('admin.payments', ['status' => 'unpaid'])); ?>" class="btn btn-sm <?php echo e($currentStatus === 'unpaid' ? 'sb_btn' : 'btn-outline-secondary'); ?>">Unpaid</a>
                        <a href="<?php echo e(route('admin.payments', ['status' => 'failed'])); ?>" class="btn btn-sm <?php echo e($currentStatus === 'failed' ? 'sb_btn' : 'btn-outline-secondary'); ?>">Failed</a>
                        <a href="<?php echo e(route('admin.payments', ['status' => 'cancelled'])); ?>" class="btn btn-sm <?php echo e($currentStatus === 'cancelled' ? 'sb_btn' : 'btn-outline-secondary'); ?>">Cancelled</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Customer</th>
                                <th>Total</th>
                                <th>Method</th>
                                <th>Status</th>
                                <th>TrxID</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="text-primary"><?php echo e($order->order_number); ?></a></td>
                                <td><?php echo e($order->contact_name); ?></td>
                                <td>৳<?php echo e(number_format($order->total)); ?></td>
                                <td><span class="badge bg-info">SSLCommerz</span></td>
                                <td>
                                    <span class="badge bg-<?php echo e($order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : ($order->payment_status === 'cancelled' ? 'secondary' : 'warning'))); ?>">
                                        <?php echo e(ucfirst($order->payment_status ?? 'unpaid')); ?>

                                    </span>
                                </td>
                                <td class="font-monospace"><?php echo e($order->payment_trxid ?? '-'); ?></td>
                                <td><?php echo e($order->created_at->format('d M, Y h:i A')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="btn btn-sm btn-secondary">View</a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center">No payments found</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="mt-3 d-flex justify-content-end">
                    <?php echo e($payments->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/payments/list.blade.php ENDPATH**/ ?>