
<?php $__env->startSection('title', 'Product Reviews'); ?>
<?php $__env->startSection('content'); ?>
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Product Reviews</h1>
      </div>
      <div class="col-sm-6 mt-md-0 mt-3">
        <form method="GET" class="float-sm-right" style="max-width: 480px;">
          <div class="input-group">
            <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="form-control" placeholder="Search product or user">
            <div class="input-group-append">
              <button class="btn sb_btn" type="submit"><i class="fas fa-search"></i> Search</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>

<section class="content">
  <div class="container-fluid">
    <div class="card">
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-striped table-hover mb-0">
            <thead class="bg_sb_primary">
              <tr>
                <th width="60">#</th>
                <th>Product</th>
                <th>User</th>
                <th class="text-center" width="150">Rating</th>
                <th>Comment</th>
                <th width="180">Date</th>
                <th width="80" class="text-center">Action</th>
              </tr>
            </thead>
            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $ratings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td><?php echo e($rating->id); ?></td>
                <td>
                  <a href="<?php echo e(route('product.view', $rating->product->slug)); ?>" target="_blank" class="text-primary">
                    <?php echo e($rating->product->title); ?>

                  </a>
                </td>
                <td>
                  <?php if($rating->user): ?>
                    <a href="<?php echo e(route('admin.users.edit', $rating->user->id)); ?>" class="text-primary">
                      <?php echo e($rating->user->name); ?>

                    </a>
                    <br/>
                    <small class="text-muted"><?php echo e($rating->user->email); ?></small>
                  <?php else: ?>
                    <span class="text-muted">User</span>
                  <?php endif; ?>
                </td>
                <td class="text-center">
                  <div class="mn-pro-rating" style="font-size: 16px; color:#f5c518;">
                    <?php for($i=1;$i<=5;$i++): ?>
                      <?php if($i <= $rating->rating): ?>
                        <i class="fas fa-star"></i>
                      <?php else: ?>
                        <i class="far fa-star"></i>
                      <?php endif; ?>
                    <?php endfor; ?>
                  </div>
                </td>
                <td><?php echo e($rating->comment); ?></td>
                <td><small><?php echo e($rating->created_at->format('d M Y, h:i A')); ?></small></td>
                <td class="text-center">
                  <form action="<?php echo e(route('admin.products.reviews.delete', $rating->id)); ?>" method="POST" onsubmit="return confirm('Delete this review?');">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-sm btn-danger" title="Delete Review">
                      <i class="fas fa-minus-circle"></i>
                    </button>
                  </form>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="7" class="text-center py-4">
                  <div class="text-muted">
                    <i class="fas fa-info-circle mr-1"></i> No reviews found
                  </div>
                </td>
              </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
        <?php if($ratings->hasPages()): ?>
        <div class="card-footer bg-white">
          <div class="d-flex justify-content-between align-items-center">
            <div class="showing-text">
              Showing <?php echo e($ratings->firstItem()); ?> to <?php echo e($ratings->lastItem()); ?> of <?php echo e($ratings->total()); ?> reviews
            </div>
            <?php echo e($ratings->onEachSide(1)->links('pagination::bootstrap-4')); ?>

          </div>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/products/reviews.blade.php ENDPATH**/ ?>