<?php $__env->startSection('title', $dealName ? $dealName : 'Best Deals'); ?>

<?php $__env->startSection('style'); ?>
<style>
:root {
    --brand-primary: #159abe; /* override via inline style or global CSS */
    --brand-secondary: #159abe; /* same as primary to keep a single-brand look */
    --brand-accent: #1cbce8; /* warm accent for highlights */

    --deal-gradient: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-secondary) 100%);
    --deal-accent: var(--brand-secondary);
    --deal-text: #ffffff;
    --deal-muted: rgba(255, 255, 255, 0.7);
    --deal-glow: rgba(139, 92, 246, 0.65);
}

@keyframes gradientShift {
    0% { background-position: 0% 50%; }
    50% { background-position: 100% 50%; }
    100% { background-position: 0% 50%; }
}

@keyframes floatOrb {
    0% { transform: translate3d(0, 0, 0) scale(1); opacity: .7; }
    50% { transform: translate3d(12px, -8px, 0) scale(1.05); opacity: .9; }
    100% { transform: translate3d(0, 0, 0) scale(1); opacity: .7; }
}

@keyframes shine {
    0% { transform: translateX(-120%); }
    100% { transform: translateX(120%); }
}

@keyframes pulseTick {
    0% { transform: translateZ(0) scale(1); }
    30% { transform: translateZ(0) scale(1.03); }
    100% { transform: translateZ(0) scale(1); }
}

@keyframes progressIndeterminate {
    0% { background-position-x: 0; }
    100% { background-position-x: 200%; }
}

/* Product card styling to match home */
.mn-product-card .mn-product-detail .cat a { text-transform: none !important; }
.mn-card-meta { display:flex; align-items:center; justify-content:space-between; margin:-4px 0 6px 0; }
.mn-card-rating { display:inline-flex; align-items:center; gap:4px; font-size:14px; }
.mn-card-rating .num { color:#666; }

.deal-header {
    position: relative;
    background: var(--deal-gradient);
    background-size: 200% 200%;
    animation: gradientShift 18s ease-in-out infinite;
    padding: 5.5rem 0 4.5rem;
    margin-bottom: 2.25rem;
    color: var(--deal-text);
    overflow: hidden;
}

.deal-header::before {
    content: "";
    position: absolute;
    inset: -20% -10% -10% -10%;
    background:
        radial-gradient(1200px 400px at -10% -20%, rgba(255, 255, 255, 0.08), transparent 60%),
        radial-gradient(800px 300px at 110% 20%, rgba(255, 255, 255, 0.06), transparent 60%),
        radial-gradient(600px 600px at 50% 120%, rgba(0, 0, 0, 0.12), transparent 60%);
    pointer-events: none;
}

.deal-header .container { position: relative; z-index: 1; }

/* floating decorative orbs */
.bg-orb {
    position: absolute;
    border-radius: 999px;
    filter: blur(18px);
    opacity: .85;
    will-change: transform;
    animation: floatOrb 12s ease-in-out infinite;
}
.bg-orb.orb-1 { width: 220px; height: 220px; left: 6%; top: 18%; background: radial-gradient(circle at 30% 30%, var(--brand-accent), transparent 60%); }
.bg-orb.orb-2 { width: 300px; height: 300px; right: 8%; bottom: 6%; background: radial-gradient(circle at 70% 70%, var(--brand-secondary), transparent 60%); animation-duration: 16s; }

.deal-header-inner {
    position: relative;
    isolation: isolate;
    max-width: 980px;
    margin: 0 auto;
    text-align: center;
    padding: 1.75rem 1.25rem 1.5rem;
    background: rgba(255, 255, 255, 0.08);
    border-radius: 22px;
    border: 1px solid rgba(255, 255, 255, 0.14);
    backdrop-filter: blur(8px);
    -webkit-backdrop-filter: blur(8px);
    box-shadow: 0 18px 40px rgba(0, 0, 0, 0.18), 0 0 0 1px rgba(255, 255, 255, 0.08) inset;
    transition: transform 300ms ease, box-shadow 300ms ease;
}

/* animated gradient border using mask trick */
.deal-header-inner::before {
    content: "";
    position: absolute; inset: 0;
    padding: 1.2px; border-radius: inherit;
    background: linear-gradient(90deg, var(--brand-secondary), var(--brand-primary));
    background-size: 200% 100%;
    animation: gradientShift 10s linear infinite;
    -webkit-mask: linear-gradient(#000 0 0) content-box, linear-gradient(#000 0 0);
    -webkit-mask-composite: xor; mask-composite: exclude; pointer-events: none;
}

/* subtle sheen */
.deal-header-inner::after {
    content: "";
    position: absolute; inset: 0; border-radius: inherit; overflow: hidden; pointer-events: none;
    background: linear-gradient(100deg, transparent 30%, rgba(255,255,255,.28) 50%, transparent 70%);
    transform: translateX(-120%);
    animation: shine 6s ease-in-out infinite;
}

.deal-badge {
    display: inline-flex; align-items: center; gap: 0.6rem;
    padding: 0.5rem 0.85rem; border-radius: 999px;
    background: rgba(255, 255, 255, 0.16);
    border: 1px solid rgba(255, 255, 255, 0.22);
    font-weight: 700; letter-spacing: 0.02em; color: var(--deal-text);
    box-shadow: 0 2px 10px rgba(0,0,0,.12);
}

.deal-badge img { width: 22px; height: 22px; filter: drop-shadow(0 2px 4px rgba(0,0,0,.1)); }

.deal-title {
    margin: 0.9rem 0 0.2rem;
    font-size: clamp(1.6rem, 2.3vw + 1rem, 2.8rem);
    font-weight: 800; line-height: 1.15;
    text-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
}

.deal-countdown {
    margin-top: 1.2rem;
    display: flex; align-items: stretch; justify-content: center; gap: 0.8rem; flex-wrap: wrap;
}

.count-segment {
    min-width: 86px; padding: 0.85rem 0.9rem;
    background: rgba(255, 255, 255, 0.14);
    border: 1px solid rgba(255, 255, 255, 0.28);
    border-radius: 16px;
    box-shadow: inset 0 -6px 24px rgba(0, 0, 0, 0.08), 0 8px 18px rgba(0,0,0,.08);
    transition: transform 180ms ease;
}

.count-segment span {
    display: block; font-variant-numeric: tabular-nums;
    font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
    font-size: 1.75rem; font-weight: 900; color: #fff;
}

.count-segment small { display: block; margin-top: 0.3rem; font-size: 0.72rem; text-transform: uppercase; letter-spacing: 0.08em; color: var(--deal-muted); }

.deal-countdown.tick .count-segment { animation: pulseTick 300ms ease; }

.deal-ends { margin-top: 0.85rem; color: var(--deal-muted); font-weight: 600; }

/* progress bar */
.deal-progress { position: relative; height: 6px; border-radius: 999px; overflow: hidden; background: rgba(255,255,255,.18); margin: 1rem auto 0; max-width: 560px; }
.deal-progress-bar {
    height: 100%; width: 0%; border-radius: inherit;
    background: linear-gradient(90deg, var(--brand-primary), var(--brand-secondary));
    box-shadow: 0 0 16px rgba(0,0,0,.15), 0 0 12px rgba(255, 215, 131, 0.25);
    transition: width 300ms ease;
}
.deal-progress-bar.indeterminate {
    width: 40%;
    background: repeating-linear-gradient(90deg, rgba(255,255,255,.65) 0 10px, rgba(255,255,255,.25) 10px 20px);
    animation: progressIndeterminate 1.4s linear infinite;
}

/* CTA */
.deal-actions { margin-top: 1rem; display: flex; justify-content: center; }
.mn-btn-glow {
    position: relative; display: inline-flex; align-items: center; justify-content: center; gap: .5rem;
    padding: .65rem 1.25rem; border-radius: 12px; font-weight: 700; letter-spacing: .02em;
    background: linear-gradient(90deg, var(--brand-primary), var(--brand-secondary));
    color: #fff; border: 1px solid rgba(255,255,255,.22);
    box-shadow: 0 6px 18px rgba(0,0,0,.18), 0 0 0 1px rgba(255,255,255,.08) inset;
    transition: transform .2s ease, box-shadow .2s ease, background .2s ease;
}
.mn-btn-glow:hover { transform: translateY(-2px); box-shadow: 0 10px 24px rgba(0,0,0,.22), 0 0 16px rgba(255, 215, 131, .45); }

@media (max-width: 576px) {
    .deal-header { padding: 4rem 0 3rem; }
    .count-segment { min-width: 70px; padding: 0.65rem 0.7rem; border-radius: 14px; }
    .count-segment span { font-size: 1.45rem; }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Deal Header -->
<?php if($dealName): ?>
<div class="deal-header" style="--brand-primary: <?php echo e($brandPrimary ?? '#159abe'); ?>; --brand-secondary: <?php echo e($brandSecondary ?? '#159abe'); ?>; --brand-accent: <?php echo e($brandAccent ?? '#1cbce8'); ?>;">
    <!-- decorative orbs -->
    <span class="bg-orb orb-1" aria-hidden="true"></span>
    <span class="bg-orb orb-2" aria-hidden="true"></span>

    <div class="container">
        <div class="deal-header-inner" id="dealHeader" data-end="<?php echo e($dealEndDate ?? ''); ?>" data-start="<?php echo e($dealStartDate ?? ''); ?>">
            <div class="deal-badge">
                <span>Best Deals</span>
            </div>
            <h1 class="deal-title"><?php echo e($dealName); ?></h1>
            <p class="text-light"><?php echo e($dealDescription); ?></p>
        <?php if($dealEndDate): ?>
            <div class="deal-countdown" aria-live="polite" role="timer">
                <div class="count-segment"><span id="dd">00</span><small>Days</small></div>
                <div class="count-segment"><span id="hh">00</span><small>Hours</small></div>
                <div class="count-segment"><span id="mm">00</span><small>Minutes</small></div>
                <div class="count-segment"><span id="ss">00</span><small>Seconds</small></div>
            </div>
            <div class="deal-ends" id="dealStatus">Ends soon</div>
            <div class="deal-progress" aria-hidden="true"><div class="deal-progress-bar" id="dealProgressBar"></div></div>

            <?php endif; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Products Section -->
<section class="mn-new-product p-tb-15">
        <?php if($products->isEmpty()): ?>
        <div class="text-center py-5">
            <h3>No active deals at the moment</h3>
            <p>Please check back later for exciting deals!</p>
            <a href="<?php echo e(route('product.list')); ?>" class="mn-btn-2"><span>Browse All Products</span></a>
        </div>
        <?php else: ?>
        <div class="row">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-12 m-b-24 mn-product-box pro-gl-content">
                <div class="mn-product-card"
                     data-product-id="<?php echo e($product->id); ?>"
                     data-default-variant-id="<?php echo e(optional($product->variations->firstWhere('default', true))->id); ?>">
                    <div class="mn-product-img">
                        <div class="mn-img">
                            <a href="<?php echo e(route('product.view', ['slug' => $product->slug])); ?>" class="image">
                                <?php if($product->primary_image): ?>
                                    <img class="main-img" src="<?php echo e($product->primary_image->url); ?>" alt="<?php echo e($product->title); ?>">
                                <?php else: ?>
                                    <img class="main-img" src="<?php echo e(asset('assets/default_img.png')); ?>" alt="<?php echo e($product->title); ?>">
                                <?php endif; ?>
                            </a>
                            <div class="mn-options mn-options-always-visible">
                                <ul>
                                    <li>
                                        <a href="javascript:void(0)" data-tooltip title="Wishlist" class="mn-wishlist" data-product-id="<?php echo e($product->id); ?>">
                                            <i class="ri-heart-line"></i>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" data-tooltip title="Compare" class="mn-compare" data-product-id="<?php echo e($product->id); ?>">
                                            <i class="ri-repeat-line"></i>
                                        </a>
                                    </li>
                                    <li>
                                        <?php
                                            $defaultVariation = $product->variations->firstWhere('default', true);
                                            $defaultInStock = $defaultVariation && $defaultVariation->in_stock > 0;
                                            $variantsCount = $product->variants_count ?? $product->variations->count();
                                            $inStockCount = $product->in_stock_variants_count ?? $product->variations->where('in_stock', '>', 0)->count();
                                            $allOut = ($inStockCount === 0);
                                            $defaultOut = !$defaultInStock;
                                        ?>
                                        <?php if($variantsCount > 1 && $defaultOut && !$allOut): ?>
                                            <a href="<?php echo e(route('product.view', ['slug' => $product->slug])); ?>" data-tooltip title="Open" class="mn-add-cart open-link">
                                                <i class="ri-eye-line"></i>
                                                Open
                                            </a>
                                        <?php elseif(($variantsCount === 1 && $defaultOut) || ($variantsCount > 1 && $allOut)): ?>
                                            <a href="javascript:void(0)" class="mn-add-cart out-stock disabled" style="pointer-events: none; opacity: .85; background: #dc3545; border-color: #dc3545; color: #fff;">
                                                <i class="ri-close-line"></i>
                                                Out of stock
                                            </a>
                                        <?php else: ?>
                                            <a href="javascript:void(0)" data-tooltip title="Add To Cart" class="mn-add-cart">
                                                <i class="ri-shopping-cart-line"></i>
                                                Add to Cart
                                            </a>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="mn-product-detail">
                        <div class="cat" style="display:flex; align-items:center; justify-content:space-between; gap:10px;">
                            <a href="<?php echo e(route('product.list', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->name); ?></a>
                            <?php if($product->brand): ?>
                                <a href="<?php echo e(route('product.list', ['brand' => Str::slug($product->brand->title)])); ?>"><?php echo e($product->brand->title); ?></a>
                            <?php endif; ?>
                        </div>
                        <h5>
                            <a href="<?php echo e(route('product.view', ['slug' => $product->slug])); ?>"><?php echo e($product->title); ?></a>
                        </h5>
                        <?php $avg = $product->average_rating ?? ($product->averageRating ?? 0); ?>
                        <div class="mn-card-meta">
                            <div class="mn-price" style="margin:0;">
                                <?php $defaultVariation = $product->variations->firstWhere('default', true); ?>
                                <?php if($defaultVariation): ?>
                                    <div class="mn-price-new">৳<?php echo e(number_format($defaultVariation->sale_price)); ?></div>
                                    <?php if($defaultVariation->regular_price > $defaultVariation->sale_price): ?>
                                        <div class="mn-price-old">৳<?php echo e(number_format($defaultVariation->regular_price)); ?></div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            <div class="mn-card-rating">
                                <?php
                                    $icon = 'ri-star-line';
                                    if ($avg >= 0.75) { $icon = 'ri-star-fill'; }
                                    elseif ($avg >= 0.25) { $icon = 'ri-star-half-s-fill'; }
                                ?>
                                <i class="<?php echo e($icon); ?>"></i>
                                <span class="num"><?php echo e(number_format($avg,1)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <?php if($products instanceof \Illuminate\Pagination\LengthAwarePaginator && $products->hasPages()): ?>
        <div class="mt-4">
            <?php echo e($products->links('partial.pagination')); ?>

        </div>
        <?php endif; ?>
        <?php endif; ?>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php if($dealEndDate): ?>
<script>
(function () {
    var container = document.getElementById('dealHeader');
    var endAttr = container ? container.getAttribute('data-end') : null;
    var startAttr = container ? container.getAttribute('data-start') : null;
    var targetTime = endAttr ? new Date(endAttr).getTime() : null;
    var startTime = startAttr ? new Date(startAttr).getTime() : null;

    var statusEl = document.getElementById('dealStatus');
    var progressEl = document.getElementById('dealProgressBar');
    var countdownEl = document.querySelector('.deal-countdown');

    function pad(n) { return String(n).padStart(2, '0'); }
    function clamp(n, min, max) { return Math.max(min, Math.min(max, n)); }

    function updateProgress(now) {
        if (!progressEl) return;
        if (!startTime || !targetTime || startTime >= targetTime) {
            progressEl.classList.add('indeterminate');
            return;
        }
        var total = targetTime - startTime;
        var elapsed = now - startTime;
        var pct = clamp((elapsed / total) * 100, 0, 100);
        progressEl.classList.remove('indeterminate');
        progressEl.style.width = pct + '%';
    }

    function formatEnd(ts) {
        try {
            var d = new Date(ts);
            return d.toLocaleString([], { year: 'numeric', month: 'short', day: '2-digit', hour: '2-digit', minute: '2-digit' });
        } catch(e) { return 'soon'; }
    }

    function tick() {
        var now = Date.now();
        if (!targetTime) return;
        var diff = targetTime - now;

        if (diff <= 0) {
            ['dd','hh','mm','ss'].forEach(function(id){ var el = document.getElementById(id); if (el) el.textContent = '00'; });
            if (statusEl) statusEl.textContent = 'Expired';
            if (progressEl) { progressEl.classList.remove('indeterminate'); progressEl.style.width = '100%'; }
            return clearInterval(timerId);
        }

        var days = Math.floor(diff / (1000 * 60 * 60 * 24));
        var hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((diff % (1000 * 60)) / 1000);

        var dd = document.getElementById('dd');
        var hh = document.getElementById('hh');
        var mm = document.getElementById('mm');
        var ss = document.getElementById('ss');

        if (dd) dd.textContent = pad(days);
        if (hh) hh.textContent = pad(hours);
        if (mm) mm.textContent = pad(minutes);
        if (ss) ss.textContent = pad(seconds);
        if (statusEl) statusEl.textContent = 'Ends on ' + formatEnd(targetTime);

        updateProgress(now);

        if (countdownEl) {
            countdownEl.classList.remove('tick');
            // Force reflow to restart animation
            void countdownEl.offsetWidth;
            countdownEl.classList.add('tick');
        }
    }

    // Parallax micro-interaction
    if (container) {
        var baseX = 0, baseY = 0;
        container.addEventListener('mousemove', function (e) {
            var rect = container.getBoundingClientRect();
            var x = (e.clientX - rect.left) / rect.width - 0.5;
            var y = (e.clientY - rect.top) / rect.height - 0.5;
            var rotateY = x * 4; // tilt horizontally
            var rotateX = -y * 4; // tilt vertically
            container.style.transform = 'perspective(800px) rotateX(' + rotateX + 'deg) rotateY(' + rotateY + 'deg)';
        });
        container.addEventListener('mouseleave', function () {
            container.style.transform = 'none';
        });
    }

    var timerId = setInterval(tick, 1000);
    tick();
})();
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('general_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/general/best_deals.blade.php ENDPATH**/ ?>